/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf.proto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferOutputStream;
import org.fusesource.hawtbuf.proto.WireFormat;

public final class CodedOutputStream
extends FilterOutputStream {
    private BufferOutputStream bos;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    public CodedOutputStream(OutputStream os) {
        super(os);
        if (os instanceof BufferOutputStream) {
            this.bos = (BufferOutputStream)os;
        }
    }

    public CodedOutputStream(byte[] data) {
        super(new BufferOutputStream(data));
    }

    public CodedOutputStream(Buffer data) {
        super(new BufferOutputStream(data));
    }

    public void writeDouble(int fieldNumber, double value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(value));
    }

    public void writeFloat(int fieldNumber, float value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeRawLittleEndian32(Float.floatToRawIntBits(value));
    }

    public void writeUInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawVarint64(value);
    }

    public void writeInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawVarint64(value);
    }

    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        if (value >= 0) {
            this.writeRawVarint32(value);
        } else {
            this.writeRawVarint64(value);
        }
    }

    public void writeFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeRawLittleEndian64(value);
    }

    public void writeFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeRawLittleEndian32(value);
    }

    public void writeBool(int fieldNumber, boolean value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawByte(value ? 1 : 0);
    }

    public void writeString(int fieldNumber, String value) throws IOException {
        this.writeTag(fieldNumber, 2);
        byte[] bytes = value.getBytes("UTF-8");
        this.writeRawVarint32(bytes.length);
        this.writeRawBytes(bytes);
    }

    public void writeBytes(int fieldNumber, Buffer value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeRawVarint32(value.length);
        this.writeRawBytes(value.data, value.offset, value.length);
    }

    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawVarint32(value);
    }

    public void writeEnum(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawVarint32(value);
    }

    public void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeRawLittleEndian32(value);
    }

    public void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeRawLittleEndian64(value);
    }

    public void writeSInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32(value));
    }

    public void writeSInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64(value));
    }

    public static int computeDoubleSize(int fieldNumber, double value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeFloatSize(int fieldNumber, float value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    public static int computeUInt64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint64Size(value);
    }

    public static int computeInt64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint64Size(value);
    }

    public static int computeInt32Size(int fieldNumber, int value) {
        if (value >= 0) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint32Size(value);
        }
        return CodedOutputStream.computeTagSize(fieldNumber) + 10;
    }

    public static int computeFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    public static int computeBoolSize(int fieldNumber, boolean value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 1;
    }

    public static int computeStringSize(int fieldNumber, String value) {
        try {
            byte[] bytes = value.getBytes("UTF-8");
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint32Size(bytes.length) + bytes.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.", e);
        }
    }

    public static int computeBytesSize(int fieldNumber, Buffer value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint32Size(value.length) + value.length;
    }

    public static int computeUInt32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint32Size(value);
    }

    public static int computeEnumSize(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint32Size(value);
    }

    public static int computeSFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    public static int computeSFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeSInt32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(value));
    }

    public static int computeSInt64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(value));
    }

    public void writeRawByte(byte value) throws IOException {
        this.out.write(value);
    }

    public void writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
    }

    public void writeRawBytes(byte[] value) throws IOException {
        this.writeRawBytes(value, 0, value.length);
    }

    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.out.write(value, offset, length);
    }

    public void writeRawBytes(Buffer data) throws IOException {
        this.out.write(data.data, data.offset, data.length);
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(WireFormat.makeTag(fieldNumber, wireType));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(fieldNumber, 0));
    }

    public void writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int value) throws IOException {
        this.writeRawByte(value & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long value) throws IOException {
        this.writeRawByte((int)value & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(value >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public void checkNoSpaceLeft() {
    }

    public Buffer getNextBuffer(int size2) throws IOException {
        if (this.bos == null) {
            return null;
        }
        return this.bos.getNextBuffer(size2);
    }
}

