/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.util;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JStringLiteral;
import com.sun.xml.bind.WhiteSpaceProcessor;

public abstract class WhitespaceNormalizer {
    public static final WhitespaceNormalizer PRESERVE = new WhitespaceNormalizer(){

        @Override
        public JExpression generate(JCodeModel codeModel, JExpression literal) {
            return literal;
        }
    };
    public static final WhitespaceNormalizer REPLACE = new WhitespaceNormalizer(){

        @Override
        public JExpression generate(JCodeModel codeModel, JExpression literal) {
            if (literal instanceof JStringLiteral) {
                return JExpr.lit(WhiteSpaceProcessor.replace((String)((JStringLiteral)literal).str));
            }
            return codeModel.ref(WhiteSpaceProcessor.class).staticInvoke("replace").arg(literal);
        }
    };
    public static final WhitespaceNormalizer COLLAPSE = new WhitespaceNormalizer(){

        @Override
        public JExpression generate(JCodeModel codeModel, JExpression literal) {
            if (literal instanceof JStringLiteral) {
                return JExpr.lit(WhiteSpaceProcessor.collapse((String)((JStringLiteral)literal).str));
            }
            return codeModel.ref(WhiteSpaceProcessor.class).staticInvoke("collapse").arg(literal);
        }
    };

    public abstract JExpression generate(JCodeModel var1, JExpression var2);

    public static WhitespaceNormalizer parse(String method) {
        if (method.equals("preserve")) {
            return PRESERVE;
        }
        if (method.equals("replace")) {
            return REPLACE;
        }
        if (method.equals("collapse")) {
            return COLLAPSE;
        }
        throw new IllegalArgumentException(method);
    }
}

