/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.completer.DeactivateCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

@Command(scope="scr", name="deactivate", description="Deactivates a Component for the given name")
@Service
public class DeactivateAction
extends ScrActionSupport {
    @Argument(index=0, name="name", description="The name of the Component to deactivate ", required=true, multiValued=false)
    @Completion(value=DeactivateCompleter.class)
    String name;

    @Override
    protected Object doScrAction(ServiceComponentRuntime serviceComponentRuntime) throws Exception {
        this.logger.debug("Deactivate Action");
        this.logger.debug("  Deactivating the Component: " + this.name);
        for (ComponentDescriptionDTO component : serviceComponentRuntime.getComponentDescriptionDTOs(new Bundle[0])) {
            if (!this.name.equals(component.name)) continue;
            serviceComponentRuntime.disableComponent(component);
        }
        return null;
    }
}

