/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.karaf.http.core.ServletInfo;
import org.apache.karaf.http.core.ServletService;
import org.apache.karaf.http.core.internal.ServletEventHandler;
import org.ops4j.pax.web.service.spi.ServletEvent;

public class ServletServiceImpl
implements ServletService {
    private ServletEventHandler servletEventHandler;

    public ServletServiceImpl(ServletEventHandler servletEventHandler) {
        this.servletEventHandler = servletEventHandler;
    }

    @Override
    public List<ServletInfo> getServlets() {
        ArrayList<ServletInfo> servletInfos = new ArrayList<ServletInfo>();
        Collection<ServletEvent> events = this.servletEventHandler.getServletEvents();
        for (ServletEvent event : events) {
            String[] stringArray;
            String alias;
            String servletName;
            Servlet servlet = event.getServlet();
            String servletClassName = " ";
            if (servlet != null) {
                servletClassName = servlet.getClass().getName();
                servletClassName = servletClassName.substring(servletClassName.lastIndexOf(".") + 1, servletClassName.length());
            }
            String string = servletName = event.getServletName() != null ? event.getServletName() : " ";
            if (servletName.contains(".")) {
                servletName = servletName.substring(servletName.lastIndexOf(".") + 1, servletName.length());
            }
            String string2 = alias = event.getAlias() != null ? event.getAlias() : " ";
            if (event.getUrlParameter() != null) {
                stringArray = event.getUrlParameter();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            String[] urls = stringArray;
            ServletInfo info = new ServletInfo();
            info.setBundleId(event.getBundle().getBundleId());
            info.setName(servletName);
            info.setClassName(servletClassName);
            info.setState(event.getType());
            info.setAlias(alias);
            info.setUrls(urls);
            servletInfos.add(info);
        }
        return servletInfos;
    }
}

