/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.support.MultiException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundlesCommand
implements Action {
    @Option(name="--context", aliases={"-c"}, description="Use the given bundle context")
    String context = "0";
    @Argument(index=0, name="ids", description="The list of bundle (identified by IDs or name or name/version) separated by whitespaces", required=false, multiValued=true)
    List<String> ids;
    @Reference
    BundleContext bundleContext;
    @Reference
    BundleService bundleService;
    protected boolean defaultAllBundles = true;
    protected String errorMessage = "Unable to execute command on bundle ";

    public Object execute() throws Exception {
        List<Bundle> bundles = this.bundleService.selectBundles(this.context, this.ids, this.defaultAllBundles);
        return this.doExecute(bundles);
    }

    protected Object doExecute(List<Bundle> bundles) throws Exception {
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("No matching bundles");
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Bundle bundle : bundles) {
            try {
                this.executeOnBundle(bundle);
            }
            catch (Exception e) {
                exceptions.add(new Exception(this.errorMessage + bundle.getBundleId() + ": " + e.getMessage(), e));
            }
        }
        MultiException.throwIf((String)"Error executing command on bundles", exceptions);
        return null;
    }

    protected abstract void executeOnBundle(Bundle var1) throws Exception;

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

