/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;

public class ValidatorListCommand
extends AbstractCamelCommand {
    private static final String CONTEXT_NAME_COLUMN_LABEL = "Context";
    private static final String TYPE_COLUMN_LABEL = "Type";
    private static final String STATE_COLUMN_LABEL = "State";
    private static final String DESCRIPTION_COLUMN_LABEL = "Description";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    boolean decode = true;
    boolean verbose;
    boolean explain;
    private final String context;

    public ValidatorListCommand(String context, boolean decode, boolean verbose, boolean explain) {
        this.decode = decode;
        this.verbose = verbose;
        this.explain = explain;
        this.context = context;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> camelContextInfos = camelController.getCamelContexts(this.context);
        HashMap<String, List<Map<String, String>>> contextsToValidators = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> camelContextInfo : camelContextInfos) {
            String camelContextName = camelContextInfo.get("name");
            List<Map<String, String>> validators = camelController.getValidators(camelContextName);
            if (validators.isEmpty()) continue;
            contextsToValidators.put(camelContextName, validators);
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(contextsToValidators);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        for (Map.Entry stringListEntry : contextsToValidators.entrySet()) {
            String camelContextName = (String)stringListEntry.getKey();
            List validators = (List)stringListEntry.getValue();
            if (this.verbose) {
                out.println(String.format(headerFormat, CONTEXT_NAME_COLUMN_LABEL, TYPE_COLUMN_LABEL, STATE_COLUMN_LABEL, DESCRIPTION_COLUMN_LABEL));
                out.println(String.format(headerFormat, "-------", "----", "-----", "-----------"));
            } else {
                out.println(String.format(headerFormat, CONTEXT_NAME_COLUMN_LABEL, TYPE_COLUMN_LABEL, STATE_COLUMN_LABEL));
                out.println(String.format(headerFormat, "-------", "----", "-----"));
            }
            for (Map row : validators) {
                String type = (String)row.get("type");
                String state = (String)row.get("state");
                if (this.verbose) {
                    String desc = (String)row.get("description");
                    out.println(String.format(rowFormat, camelContextName, type, state, desc));
                    continue;
                }
                out.println(String.format(rowFormat, camelContextName, type, state));
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Map<String, List<Map<String, String>>> contextsToValidators) throws Exception {
        int maxCamelContextLen = 0;
        int maxTypeLen = 0;
        int maxStatusLen = 0;
        int maxDescLen = 0;
        for (Map.Entry<String, List<Map<String, String>>> stringListEntry : contextsToValidators.entrySet()) {
            String camelContextName = stringListEntry.getKey();
            maxCamelContextLen = Math.max(maxCamelContextLen, camelContextName.length());
            List<Map<String, String>> validators = stringListEntry.getValue();
            for (Map<String, String> row : validators) {
                String type = row.get("type");
                maxTypeLen = Math.max(maxTypeLen, type == null ? 0 : type.length());
                String status = row.get("state");
                maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
                if (!this.verbose) continue;
                String desc = row.get("description");
                maxDescLen = Math.max(maxDescLen, desc == null ? 0 : desc.length());
            }
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(CONTEXT_NAME_COLUMN_LABEL, maxCamelContextLen);
        retval.put(TYPE_COLUMN_LABEL, maxTypeLen);
        retval.put(STATE_COLUMN_LABEL, maxStatusLen);
        if (this.verbose) {
            retval.put(DESCRIPTION_COLUMN_LABEL, maxDescLen);
        }
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int ctxLen = Math.min(columnWidths.get(CONTEXT_NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        ctxLen = Math.max(12, ctxLen);
        int typeLen = Math.min(columnWidths.get(TYPE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        typeLen = Math.max(12, typeLen);
        int stateLen = -1;
        if (this.verbose) {
            stateLen = Math.min(columnWidths.get(STATE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            stateLen = Math.max(12, stateLen);
        }
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(ctxLen).append('.').append(ctxLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(typeLen).append('.').append(typeLen).append('s').append(fieldPostamble).append(' ');
        if (this.verbose) {
            retval.append(fieldPreamble).append("%-").append(stateLen).append('.').append(stateLen).append('s').append(fieldPostamble).append(' ');
        }
        retval.append(fieldPreamble).append("%s").append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

