/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.commands.AbstractCamelController;
import org.apache.camel.commands.LocalCamelController;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.Validator;
import org.apache.camel.util.JsonSchemaHelper;

public abstract class AbstractLocalCamelController
extends AbstractCamelController
implements LocalCamelController {
    @Override
    public CamelContext getLocalCamelContext(String name) throws Exception {
        for (CamelContext camelContext : this.getLocalCamelContexts()) {
            if (!camelContext.getName().equals(name)) continue;
            return camelContext;
        }
        return null;
    }

    @Override
    public Map<String, Object> getCamelContextInformation(String name) throws Exception {
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
        CamelContext context = this.getLocalCamelContext(name);
        if (context != null) {
            answer.put("name", context.getName());
            answer.put("managementName", context.getManagementName());
            answer.put("version", context.getVersion());
            answer.put("status", context.getStatus().name());
            answer.put("uptime", context.getUptime());
            answer.put("suspended", context.getStatus().isSuspended());
            if (context.getManagementStrategy().getManagementAgent() != null) {
                String level = context.getManagementStrategy().getManagementAgent().getStatisticsLevel().name();
                answer.put("managementStatisticsLevel", level);
            }
            answer.put("allowUseOriginalMessage", context.isAllowUseOriginalMessage());
            answer.put("messageHistory", context.isMessageHistory());
            answer.put("tracing", context.isTracing());
            answer.put("logMask", context.isLogMask());
            answer.put("shutdownTimeout", context.getShutdownStrategy().getTimeUnit().toSeconds(context.getShutdownStrategy().getTimeout()));
            answer.put("classResolver", context.getClassResolver().toString());
            answer.put("packageScanClassResolver", context.getPackageScanClassResolver().toString());
            answer.put("applicationContextClassLoader", context.getApplicationContextClassLoader().toString());
            answer.put("headersMapFactory", context.getHeadersMapFactory().toString());
            for (Map.Entry entry : context.getProperties().entrySet()) {
                answer.put("property." + (String)entry.getKey(), entry.getValue());
            }
            long activeRoutes = 0L;
            long inactiveRoutes = 0L;
            List routeList = context.getRoutes();
            for (Route route : routeList) {
                if (context.getRouteStatus(route.getId()).isStarted()) {
                    ++activeRoutes;
                    continue;
                }
                ++inactiveRoutes;
            }
            answer.put("startedRoutes", activeRoutes);
            answer.put("totalRoutes", activeRoutes + inactiveRoutes);
            answer.put("typeConverter.numberOfTypeConverters", context.getTypeConverterRegistry().size());
            answer.put("typeConverter.statisticsEnabled", context.getTypeConverterRegistry().getStatistics().isStatisticsEnabled());
            answer.put("typeConverter.noopCounter", context.getTypeConverterRegistry().getStatistics().getNoopCounter());
            answer.put("typeConverter.attemptCounter", context.getTypeConverterRegistry().getStatistics().getAttemptCounter());
            answer.put("typeConverter.hitCounter", context.getTypeConverterRegistry().getStatistics().getHitCounter());
            answer.put("typeConverter.missCounter", context.getTypeConverterRegistry().getStatistics().getMissCounter());
            answer.put("typeConverter.failedCounter", context.getTypeConverterRegistry().getStatistics().getFailedCounter());
            answer.put("asyncProcessorAwaitManager.size", context.getAsyncProcessorAwaitManager().size());
            answer.put("asyncProcessorAwaitManager.statisticsEnabled", context.getAsyncProcessorAwaitManager().getStatistics().isStatisticsEnabled());
            answer.put("asyncProcessorAwaitManager.threadsBlocked", context.getAsyncProcessorAwaitManager().getStatistics().getThreadsBlocked());
            answer.put("asyncProcessorAwaitManager.threadsInterrupted", context.getAsyncProcessorAwaitManager().getStatistics().getThreadsInterrupted());
            answer.put("asyncProcessorAwaitManager.totalDuration", context.getAsyncProcessorAwaitManager().getStatistics().getTotalDuration());
            answer.put("asyncProcessorAwaitManager.minDuration", context.getAsyncProcessorAwaitManager().getStatistics().getMinDuration());
            answer.put("asyncProcessorAwaitManager.maxDuration", context.getAsyncProcessorAwaitManager().getStatistics().getMaxDuration());
            answer.put("asyncProcessorAwaitManager.meanDuration", context.getAsyncProcessorAwaitManager().getStatistics().getMeanDuration());
            if (context.getStreamCachingStrategy().isEnabled()) {
                answer.put("streamCachingEnabled", true);
                answer.put("streamCaching.spoolDirectory", context.getStreamCachingStrategy().getSpoolDirectory());
                answer.put("streamCaching.spoolChiper", context.getStreamCachingStrategy().getSpoolChiper());
                answer.put("streamCaching.spoolThreshold", context.getStreamCachingStrategy().getSpoolThreshold());
                answer.put("streamCaching.spoolUsedHeapMemoryThreshold", context.getStreamCachingStrategy().getSpoolUsedHeapMemoryThreshold());
                answer.put("streamCaching.spoolUsedHeapMemoryLimit", context.getStreamCachingStrategy().getSpoolUsedHeapMemoryLimit());
                answer.put("streamCaching.anySpoolRules", context.getStreamCachingStrategy().isAnySpoolRules());
                answer.put("streamCaching.bufferSize", context.getStreamCachingStrategy().getBufferSize());
                answer.put("streamCaching.removeSpoolDirectoryWhenStopping", context.getStreamCachingStrategy().isRemoveSpoolDirectoryWhenStopping());
                answer.put("streamCaching.statisticsEnabled", context.getStreamCachingStrategy().getStatistics().isStatisticsEnabled());
                if (context.getStreamCachingStrategy().getStatistics().isStatisticsEnabled()) {
                    answer.put("streamCaching.cacheMemoryCounter", context.getStreamCachingStrategy().getStatistics().getCacheMemoryCounter());
                    answer.put("streamCaching.cacheMemorySize", context.getStreamCachingStrategy().getStatistics().getCacheMemorySize());
                    answer.put("streamCaching.cacheMemoryAverageSize", context.getStreamCachingStrategy().getStatistics().getCacheMemoryAverageSize());
                    answer.put("streamCaching.cacheSpoolCounter", context.getStreamCachingStrategy().getStatistics().getCacheSpoolCounter());
                    answer.put("streamCaching.cacheSpoolSize", context.getStreamCachingStrategy().getStatistics().getCacheSpoolSize());
                    answer.put("streamCaching.cacheSpoolAverageSize", context.getStreamCachingStrategy().getStatistics().getCacheSpoolAverageSize());
                }
            } else {
                answer.put("streamCachingEnabled", false);
            }
        }
        return answer;
    }

    @Override
    public String getCamelContextStatsAsXml(String camelContextName, boolean fullStats, boolean includeProcessors) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        ManagementAgent agent = context.getManagementStrategy().getManagementAgent();
        if (agent != null) {
            MBeanServer mBeanServer = agent.getMBeanServer();
            ObjectName query = ObjectName.getInstance(agent.getMBeanObjectDomainName() + ":type=context,*");
            Set<ObjectName> set = mBeanServer.queryNames(query, null);
            for (ObjectName contextMBean : set) {
                String camelId = (String)mBeanServer.getAttribute(contextMBean, "CamelId");
                if (camelId == null || !camelId.equals(context.getName())) continue;
                String xml = (String)mBeanServer.invoke(contextMBean, "dumpRoutesStatsAsXml", new Object[]{fullStats, includeProcessors}, new String[]{"boolean", "boolean"});
                return xml;
            }
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> browseInflightExchanges(String camelContextName, String route, int limit, boolean sortByLongestDuration) throws Exception {
        ObjectName on;
        MBeanServer mBeanServer;
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        ManagementAgent agent = context.getManagementStrategy().getManagementAgent();
        if (agent != null && (mBeanServer = agent.getMBeanServer()).isRegistered(on = new ObjectName(agent.getMBeanObjectDomainName() + ":type=services,name=DefaultInflightRepository,context=" + context.getManagementName()))) {
            TabularData list = (TabularData)mBeanServer.invoke(on, "browse", new Object[]{route, limit, sortByLongestDuration}, new String[]{"java.lang.String", "int", "boolean"});
            Collection<?> values = list.values();
            for (CompositeData data : values) {
                Object duration;
                Object elapsed;
                Object nodeId;
                Object routeId;
                Object fromRouteId;
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                Object exchangeId = data.get("exchangeId");
                if (exchangeId != null) {
                    row.put("exchangeId", exchangeId);
                }
                if ((fromRouteId = data.get("fromRouteId")) != null) {
                    row.put("fromRouteId", fromRouteId);
                }
                if ((routeId = data.get("routeId")) != null) {
                    row.put("routeId", routeId);
                }
                if ((nodeId = data.get("nodeId")) != null) {
                    row.put("nodeId", nodeId);
                }
                if ((elapsed = data.get("elapsed")) != null) {
                    row.put("elapsed", elapsed);
                }
                if ((duration = data.get("duration")) != null) {
                    row.put("duration", duration);
                }
                answer.add(row);
            }
        }
        return answer;
    }

    @Override
    public void startContext(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.start();
        }
    }

    @Override
    public void stopContext(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.stop();
        }
    }

    @Override
    public void suspendContext(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.suspend();
        }
    }

    @Override
    public void resumeContext(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.resume();
        }
    }

    @Override
    public List<Map<String, String>> getRoutes(String camelContextName) throws Exception {
        return this.getRoutes(camelContextName, null);
    }

    @Override
    public List<Map<String, String>> getRoutes(String camelContextName, String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (camelContextName != null) {
            CamelContext context = this.getLocalCamelContext(camelContextName);
            if (context != null) {
                for (Route route : context.getRoutes()) {
                    if (filter != null && !route.getId().matches(filter)) continue;
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("camelContextName", context.getName());
                    row.put("routeId", route.getId());
                    row.put("state", AbstractLocalCamelController.getRouteState(route));
                    row.put("uptime", route.getUptime());
                    ManagedRouteMBean mr = context.getManagedRoute(route.getId(), ManagedRouteMBean.class);
                    if (mr != null) {
                        row.put("exchangesTotal", "" + mr.getExchangesTotal());
                        row.put("exchangesInflight", "" + mr.getExchangesInflight());
                        row.put("exchangesFailed", "" + mr.getExchangesFailed());
                    } else {
                        row.put("exchangesTotal", "0");
                        row.put("exchangesInflight", "0");
                        row.put("exchangesFailed", "0");
                    }
                    answer.add(row);
                }
            }
        } else {
            List<Map<String, String>> camelContexts = this.getCamelContexts();
            for (Map<String, String> row : camelContexts) {
                List<Map<String, String>> routes = this.getRoutes(row.get("name"), filter);
                answer.addAll(routes);
            }
        }
        Collections.sort(answer, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String c2;
                String c1 = o1.get("camelContextName");
                int answer = c1.compareTo(c2 = o2.get("camelContextName"));
                if (answer == 0) {
                    answer = o1.get("routeId").compareTo(o2.get("routeId"));
                }
                return answer;
            }
        });
        return answer;
    }

    @Override
    public void resetRouteStats(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return;
        }
        ManagementAgent agent = context.getManagementStrategy().getManagementAgent();
        if (agent != null) {
            MBeanServer mBeanServer = agent.getMBeanServer();
            ObjectName query = ObjectName.getInstance(agent.getMBeanObjectDomainName() + ":type=routes,*");
            Set<ObjectName> set = mBeanServer.queryNames(query, null);
            for (ObjectName routeMBean : set) {
                String camelId = (String)mBeanServer.getAttribute(routeMBean, "CamelId");
                if (camelId == null || !camelId.equals(context.getName())) continue;
                mBeanServer.invoke(routeMBean, "reset", new Object[]{true}, new String[]{"boolean"});
            }
        }
    }

    @Override
    public void startRoute(String camelContextName, String routeId) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.startRoute(routeId);
        }
    }

    @Override
    public void stopRoute(String camelContextName, String routeId) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.stopRoute(routeId);
        }
    }

    @Override
    public void suspendRoute(String camelContextName, String routeId) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.suspendRoute(routeId);
        }
    }

    @Override
    public void resumeRoute(String camelContextName, String routeId) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            context.resumeRoute(routeId);
        }
    }

    @Override
    public String getRouteModelAsXml(String routeId, String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        RouteDefinition route = context.getRouteDefinition(routeId);
        if (route == null) {
            return null;
        }
        return ModelHelper.dumpModelAsXml(null, (NamedNode)route);
    }

    @Override
    public String getRouteStatsAsXml(String routeId, String camelContextName, boolean fullStats, boolean includeProcessors) throws Exception {
        ObjectName routeMBean;
        String camelId;
        MBeanServer mBeanServer;
        Set<ObjectName> set;
        Iterator<ObjectName> iterator;
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        ManagementAgent agent = context.getManagementStrategy().getManagementAgent();
        if (agent != null && (iterator = (set = (mBeanServer = agent.getMBeanServer()).queryNames(new ObjectName(agent.getMBeanObjectDomainName() + ":type=routes,name=\"" + routeId + "\",*"), null)).iterator()).hasNext() && (camelId = (String)mBeanServer.getAttribute(routeMBean = iterator.next(), "CamelId")) != null && camelId.equals(camelContextName)) {
            String xml = (String)mBeanServer.invoke(routeMBean, "dumpRouteStatsAsXml", new Object[]{fullStats, includeProcessors}, new String[]{"boolean", "boolean"});
            return xml;
        }
        return null;
    }

    @Override
    public String getRestModelAsXml(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        List rests = context.getRestDefinitions();
        if (rests == null || rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        return ModelHelper.dumpModelAsXml(null, (NamedNode)def);
    }

    @Override
    public String getRestApiDocAsJson(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        return context.getRestRegistry().apiDocAsJson();
    }

    @Override
    public List<Map<String, String>> getEndpoints(String camelContextName) throws Exception {
        CamelContext context;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (camelContextName != null && (context = this.getLocalCamelContext(camelContextName)) != null) {
            ArrayList endpoints = new ArrayList(context.getEndpoints());
            Collections.sort(endpoints, new Comparator<Endpoint>(){

                @Override
                public int compare(Endpoint o1, Endpoint o2) {
                    return o1.getEndpointKey().compareTo(o2.getEndpointKey());
                }
            });
            for (Endpoint endpoint : endpoints) {
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("camelContextName", context.getName());
                row.put("uri", endpoint.getEndpointUri());
                row.put("state", AbstractLocalCamelController.getEndpointState(endpoint));
                answer.add(row);
            }
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> getEndpointRuntimeStatistics(String camelContextName) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (camelContextName != null) {
            CamelContext context = this.getLocalCamelContext(camelContextName);
            if (context != null && context.getRuntimeEndpointRegistry() != null) {
                EndpointRegistry staticRegistry = context.getEndpointRegistry();
                for (RuntimeEndpointRegistry.Statistic stat : context.getRuntimeEndpointRegistry().getEndpointStatistics()) {
                    String url = stat.getUri();
                    String routeId = stat.getRouteId();
                    String direction = stat.getDirection();
                    Boolean isStatic = staticRegistry.isStatic(url);
                    Boolean isDynamic = staticRegistry.isDynamic(url);
                    long hits = stat.getHits();
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("camelContextName", context.getName());
                    row.put("uri", url);
                    row.put("routeId", routeId);
                    row.put("direction", direction);
                    row.put("static", isStatic.toString());
                    row.put("dynamic", isDynamic.toString());
                    row.put("hits", "" + hits);
                    answer.add(row);
                }
            }
            Collections.sort(answer, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> endpoint1, Map<String, String> endpoint2) {
                    String route2;
                    String route1 = endpoint1.get("routeId");
                    int num = route1.compareTo(route2 = endpoint2.get("routeId"));
                    if (num == 0) {
                        String dir1 = endpoint1.get("direction");
                        String dir2 = endpoint2.get("direction");
                        num = dir1.compareTo(dir2);
                    }
                    return num;
                }
            });
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> getRestServices(String camelContextName) throws Exception {
        CamelContext context;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (camelContextName != null && (context = this.getLocalCamelContext(camelContextName)) != null) {
            ArrayList services = new ArrayList(context.getRestRegistry().listAllRestServices());
            Collections.sort(services, new Comparator<RestRegistry.RestService>(){

                @Override
                public int compare(RestRegistry.RestService o1, RestRegistry.RestService o2) {
                    return o1.getUrl().compareTo(o2.getUrl());
                }
            });
            for (RestRegistry.RestService service : services) {
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("basePath", service.getBasePath());
                row.put("baseUrl", service.getBaseUrl());
                row.put("consumes", service.getConsumes());
                row.put("description", service.getDescription());
                row.put("inType", service.getInType());
                row.put("method", service.getMethod());
                row.put("outType", service.getOutType());
                row.put("produces", service.getProduces());
                row.put("routeId", service.getRouteId());
                row.put("state", service.getState());
                row.put("uriTemplate", service.getUriTemplate());
                row.put("url", service.getUrl());
                answer.add(row);
            }
        }
        return answer;
    }

    @Override
    public String explainEndpointAsJSon(String camelContextName, String uri, boolean allOptions) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        return context.explainEndpointJson(uri, allOptions);
    }

    @Override
    public String explainEipAsJSon(String camelContextName, String nameOrId, boolean allOptions) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        return context.explainEipJson(nameOrId, allOptions);
    }

    @Override
    public List<Map<String, String>> listComponents(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        Map components = context.findComponents();
        for (Map.Entry entry : components.entrySet()) {
            String name = (String)entry.getKey();
            String description = null;
            String label = null;
            String status = context.hasComponent(name) != null ? "in use" : "on classpath";
            String type = null;
            String groupId = null;
            String artifactId = null;
            String version = null;
            String json = context.getComponentParameterJsonSchema(name);
            List rows = JsonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
            for (Map row : rows) {
                if (row.containsKey("description")) {
                    description = (String)row.get("description");
                    continue;
                }
                if (row.containsKey("label")) {
                    label = (String)row.get("label");
                    continue;
                }
                if (row.containsKey("javaType")) {
                    type = (String)row.get("javaType");
                    continue;
                }
                if (row.containsKey("groupId")) {
                    groupId = (String)row.get("groupId");
                    continue;
                }
                if (row.containsKey("artifactId")) {
                    artifactId = (String)row.get("artifactId");
                    continue;
                }
                if (!row.containsKey("version")) continue;
                version = (String)row.get("version");
            }
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", name);
            row.put("status", status);
            if (description != null) {
                row.put("description", description);
            }
            if (label != null) {
                row.put("label", label);
            }
            if (type != null) {
                row.put("type", type);
            }
            if (groupId != null) {
                row.put("groupId", groupId);
            }
            if (artifactId != null) {
                row.put("artifactId", artifactId);
            }
            if (version != null) {
                row.put("version", version);
            }
            answer.add(row);
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> getTransformers(String camelContextName) throws Exception {
        CamelContext context;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (camelContextName != null && (context = this.getLocalCamelContext(camelContextName)) != null) {
            ArrayList transformers = new ArrayList(context.getTransformerRegistry().values());
            for (Transformer transformer : transformers) {
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("camelContextName", context.getName());
                row.put("scheme", transformer.getModel());
                row.put("from", transformer.getFrom().toString());
                row.put("to", transformer.getTo().toString());
                row.put("state", transformer.getStatus().toString());
                row.put("description", transformer.toString());
                answer.add(row);
            }
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> getValidators(String camelContextName) throws Exception {
        CamelContext context;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (camelContextName != null && (context = this.getLocalCamelContext(camelContextName)) != null) {
            ArrayList validators = new ArrayList(context.getValidatorRegistry().values());
            for (Validator validator : validators) {
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("camelContextName", context.getName());
                row.put("type", validator.getType().toString());
                row.put("state", validator.getStatus().toString());
                row.put("description", validator.toString());
                answer.add(row);
            }
        }
        return answer;
    }

    private static String getEndpointState(Endpoint endpoint) {
        if (endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)endpoint).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    private static String getRouteState(Route route) {
        ServiceStatus status = route.getRouteContext().getCamelContext().getRouteStatus(route.getId());
        if (status != null) {
            return status.name();
        }
        return ServiceStatus.Started.name();
    }
}

