/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import io.hydrolix.connectors.expr.BooleanLiteral;
import io.hydrolix.connectors.expr.BooleanLiteral$;
import io.hydrolix.connectors.expr.Float32Literal;
import io.hydrolix.connectors.expr.Float64Literal;
import io.hydrolix.connectors.expr.GetField;
import io.hydrolix.connectors.expr.Int16Literal;
import io.hydrolix.connectors.expr.Int32Literal;
import io.hydrolix.connectors.expr.Int64Literal;
import io.hydrolix.connectors.expr.Int8Literal;
import io.hydrolix.connectors.expr.StringLiteral;
import io.hydrolix.connectors.expr.TimestampLiteral;
import io.hydrolix.connectors.expr.UInt16Literal;
import io.hydrolix.connectors.expr.UInt32Literal;
import io.hydrolix.connectors.expr.UInt64Literal;
import io.hydrolix.connectors.expr.UInt8Literal;
import io.hydrolix.connectors.expr.package;
import io.hydrolix.connectors.types.AnyType$;
import io.hydrolix.connectors.types.BooleanType$;
import io.hydrolix.connectors.types.StructType;
import io.hydrolix.connectors.types.ValueType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import org.apache.spark.sql.SparkPredicates$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class SparkExpressions$ {
    public static final SparkExpressions$ MODULE$ = new SparkExpressions$();

    public Expression coreToSpark(package.Expr<Object> expr) {
        package.Expr<Object> expr2 = expr;
        ValueType valueType = expr2.type();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        if (!(valueType != null ? !valueType.equals(booleanType$) : booleanType$ != null)) {
            return SparkPredicates$.MODULE$.coreToSpark(expr2);
        }
        if (expr2 instanceof GetField) {
            GetField getField = (GetField)expr2;
            String name = getField.name();
            return FieldReference$.MODULE$.apply(name);
        }
        if (expr2 instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expr2;
            boolean value = booleanLiteral.value();
            return new LiteralValue((Object)BoxesRunTime.boxToBoolean((boolean)value), DataTypes.BooleanType);
        }
        if (expr2 instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expr2;
            String value = stringLiteral.value();
            return new LiteralValue((Object)UTF8String.fromString((String)value), DataTypes.StringType);
        }
        if (expr2 instanceof Int8Literal) {
            Int8Literal int8Literal = (Int8Literal)expr2;
            byte value = int8Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToByte((byte)value), DataTypes.ByteType);
        }
        if (expr2 instanceof UInt8Literal) {
            UInt8Literal uInt8Literal = (UInt8Literal)expr2;
            short value = uInt8Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToShort((short)value), DataTypes.ShortType);
        }
        if (expr2 instanceof Int16Literal) {
            Int16Literal int16Literal = (Int16Literal)expr2;
            short value = int16Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToShort((short)value), DataTypes.ShortType);
        }
        if (expr2 instanceof UInt16Literal) {
            UInt16Literal uInt16Literal = (UInt16Literal)expr2;
            int value = uInt16Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToInteger((int)value), DataTypes.IntegerType);
        }
        if (expr2 instanceof Int32Literal) {
            Int32Literal int32Literal = (Int32Literal)expr2;
            int value = int32Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToInteger((int)value), DataTypes.IntegerType);
        }
        if (expr2 instanceof UInt32Literal) {
            UInt32Literal uInt32Literal = (UInt32Literal)expr2;
            long value = uInt32Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToLong((long)value), DataTypes.LongType);
        }
        if (expr2 instanceof Int64Literal) {
            Int64Literal int64Literal = (Int64Literal)expr2;
            long value = int64Literal.value();
            return new LiteralValue((Object)BoxesRunTime.boxToLong((long)value), DataTypes.LongType);
        }
        if (expr2 instanceof UInt64Literal) {
            UInt64Literal uInt64Literal = (UInt64Literal)expr2;
            BigDecimal value = uInt64Literal.value();
            return new LiteralValue((Object)value, (DataType)DataTypes.createDecimalType((int)20, (int)0));
        }
        if (expr2 instanceof TimestampLiteral) {
            TimestampLiteral timestampLiteral = (TimestampLiteral)expr2;
            Instant value = timestampLiteral.value();
            return new LiteralValue((Object)BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(value)), DataTypes.TimestampType);
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(45).append("Can't convert expression from core to spark: ").append(expr2).toString());
    }

    public package.Expr<Object> sparkToCore(Expression expr, StructType schema) {
        boolean bl = false;
        LiteralValue literalValue = null;
        Expression expression = expr;
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            Seq parts = fieldReference.parts();
            String name = ((IterableOnceOps)parts.map((Function1 & Serializable)part -> package$.MODULE$.quoteIfNeeded(part))).mkString(".");
            return new GetField(name, (ValueType)schema.byName().get((Object)name).map((Function1 & Serializable)x$1 -> x$1.type()).getOrElse((Function0 & Serializable)() -> AnyType$.MODULE$));
        }
        if (expression instanceof Predicate) {
            Predicate predicate = (Predicate)expression;
            return SparkPredicates$.MODULE$.sparkToCore(predicate, schema);
        }
        if (expression instanceof LiteralValue) {
            bl = true;
            literalValue = (LiteralValue)expression;
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Boolean) {
                boolean bl2 = BoxesRunTime.unboxToBoolean((Object)value);
                DataType dataType2 = DataTypes.BooleanType;
                DataType dataType3 = dataType;
                if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                    return BooleanLiteral$.MODULE$.apply(bl2);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof String) {
                String string = (String)value;
                DataType dataType4 = DataTypes.StringType;
                DataType dataType5 = dataType;
                if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                    return new StringLiteral(string);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)value;
                DataType dataType6 = DataTypes.StringType;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    return new StringLiteral(uTF8String.toString());
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)value);
                DataType dataType8 = DataTypes.ByteType;
                DataType dataType9 = dataType;
                if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                    return new Int8Literal(by);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)value);
                DataType dataType10 = DataTypes.ShortType;
                DataType dataType11 = dataType;
                if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                    return new Int16Literal(s);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                DataType dataType12 = DataTypes.IntegerType;
                DataType dataType13 = dataType;
                if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                    return new Int32Literal(n);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                DataType dataType14 = DataTypes.LongType;
                DataType dataType15 = dataType;
                if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                    return new Int64Literal(l);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)value);
                DataType dataType16 = DataTypes.FloatType;
                DataType dataType17 = dataType;
                if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                    return new Float32Literal(f);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)value);
                DataType dataType18 = DataTypes.DoubleType;
                DataType dataType19 = dataType;
                if (!(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null)) {
                    return new Float64Literal(d);
                }
            }
        }
        if (bl) {
            Object value = literalValue.value();
            DataType dataType = literalValue.dataType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                DataType dataType20 = DataTypes.TimestampType;
                DataType dataType21 = dataType;
                if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null)) {
                    return new TimestampLiteral(DateTimeUtils$.MODULE$.microsToInstant(l));
                }
            }
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(45).append("Can't convert expression from spark to core: ").append(expression).toString());
    }

    private SparkExpressions$() {
    }
}

