/*
 * Decompiled with CFR 0.152.
 */
package io.hydrolix.connectors.spark.partitionreader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.hydrolix.connectors.JSON$;
import io.hydrolix.connectors.spark.SparkTypes$;
import io.hydrolix.connectors.types.ValueType;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public final class HdxReaderColumnarJson$
implements Logging {
    public static final HdxReaderColumnarJson$ MODULE$ = new HdxReaderColumnarJson$();
    private static final Set<DataType> scalarTypes;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        scalarTypes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{DataTypes.StringType, DataTypes.BooleanType, DataTypes.ByteType, DataTypes.ShortType, DataTypes.IntegerType, DataTypes.LongType, DataTypes.FloatType, DataTypes.DoubleType, DataTypes.DateType, DataTypes.TimestampType}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Set<DataType> scalarTypes() {
        return scalarTypes;
    }

    public void apply(io.hydrolix.connectors.types.StructType coreSchema, InputStream stream, Function1<ColumnarBatch, BoxedUnit> onBatch, Function0<BoxedUnit> onDone) {
        JsonParser parser = JSON$.MODULE$.objectMapper().createParser(stream);
        StructType sparkSchema = (StructType)SparkTypes$.MODULE$.coreToSpark((ValueType)coreSchema);
        parser.nextToken();
        OnHeapColumnVector[] cols = OnHeapColumnVector.allocateColumns((int)8192, (StructType)sparkSchema);
        Map colsByName = ((IterableOnceOps)((IterableOps)sparkSchema.zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])cols))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                OnHeapColumnVector col = (OnHeapColumnVector)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)new Tuple2((Object)field, (Object)col));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        while (true) {
            if (parser.currentToken() == null) {
                onDone.apply$mcV$sp();
                return;
            }
            int rows = this.block(parser, (Map<String, Tuple2<StructField, WritableColumnVector>>)colsByName);
            onBatch.apply((Object)new ColumnarBatch((ColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])cols), ClassTag$.MODULE$.apply(ColumnVector.class)), rows));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])cols), (Function1 & Serializable)x$1 -> {
                x$1.reset();
                return BoxedUnit.UNIT;
            });
        }
    }

    private int block(JsonParser parser, Map<String, Tuple2<StructField, WritableColumnVector>> colsByName) {
        int rows;
        block7: {
            String name;
            WritableColumnVector col;
            StructField field;
            int written;
            if (!parser.isExpectedStartObjectToken()) {
                throw package$.MODULE$.error(new StringBuilder(27).append("Expected object start, got ").append(parser.currentToken()).toString());
            }
            String string = parser.nextFieldName();
            String string2 = "rows";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw package$.MODULE$.error("Expected `rows` field");
            }
            rows = parser.nextIntValue(-1);
            if (rows == -1) {
                throw package$.MODULE$.error("`rows` was not an Int value");
            }
            String string3 = parser.nextFieldName();
            String string4 = "cols";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw package$.MODULE$.error("Expected `cols` field");
            }
            JsonToken jsonToken = parser.nextToken();
            JsonToken jsonToken2 = JsonToken.START_OBJECT;
            if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
                throw package$.MODULE$.error("Expected object start for `cols`");
            }
            do {
                JsonToken jsonToken3 = parser.nextToken();
                JsonToken jsonToken4 = JsonToken.END_OBJECT;
                if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break block7;
                name = parser.currentName();
                Tuple2 tuple2 = (Tuple2)colsByName.getOrElse((Object)name, (Function0 & Serializable)() -> package$.MODULE$.error(new StringBuilder(30).append("Couldn't find field ").append(name).append(" in schema").toString()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField field2 = (StructField)tuple2._1();
                WritableColumnVector col2 = (WritableColumnVector)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)field2, (Object)col2);
                field = (StructField)tuple22._1();
                col = (WritableColumnVector)tuple22._2();
                JsonToken jsonToken5 = parser.nextToken();
                JsonToken jsonToken6 = JsonToken.START_ARRAY;
                if (!(jsonToken5 == null ? jsonToken6 != null : !jsonToken5.equals(jsonToken6))) continue;
                throw package$.MODULE$.error(new StringBuilder(38).append("Expected array start for column ").append(name).append(", got ").append(parser.currentToken()).toString());
            } while ((written = this.readArray(parser, field.name(), field.dataType(), col, 0)) == rows);
            throw package$.MODULE$.error(new StringBuilder(25).append(name).append(" had ").append(written).append(" value(s); expected ").append(rows).toString());
        }
        parser.nextToken();
        parser.nextToken();
        return rows;
    }

    private boolean scalarType(DataType typ) {
        return this.scalarTypes().contains((Object)typ) || typ instanceof DecimalType;
    }

    private int readValue(JsonParser parser, String name, DataType valueType, WritableColumnVector col, int rowId, int offset) {
        int n;
        block9: {
            try {
                JsonToken jsonToken = parser.currentToken();
                JsonToken jsonToken2 = JsonToken.VALUE_NULL;
                if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                    col.putNull(offset);
                    return 1;
                }
                DataType dataType = valueType;
                if (this.scalarType(dataType)) {
                    this.readScalar(parser, valueType, name, col, offset);
                    n = 1;
                    break block9;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    if (!parser.isExpectedStartArrayToken()) {
                        throw package$.MODULE$.error("Expected array start");
                    }
                    n = this.readArray(parser, new StringBuilder(2).append(name).append("[]").toString(), elementType, col, offset);
                    break block9;
                }
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType dataType2 = mapType.keyType();
                    DataType valueType2 = mapType.valueType();
                    DataType dataType3 = DataTypes.StringType;
                    DataType dataType4 = dataType2;
                    if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                        if (!parser.isExpectedStartObjectToken()) {
                            throw package$.MODULE$.error("Expected object start");
                        }
                        n = this.readMap(parser, new StringBuilder(2).append(name).append("{}").toString(), valueType2, col, rowId, offset);
                        break block9;
                    }
                }
                throw new MatchError((Object)dataType);
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(24).append("Couldn't read a value ").append(name).append(": ").append(valueType).toString(), e);
            }
        }
        return n;
    }

    private int readArray(JsonParser parser, String name, DataType elementType, WritableColumnVector col, int offset) {
        int pos;
        block5: {
            DataType dataType;
            Predef$.MODULE$.require(parser.isExpectedStartArrayToken(), (Function0 & Serializable)() -> new StringBuilder(43).append("Expected START_ARRAY at beginning of ").append(name).append("; got ").append(parser.currentToken()).toString());
            pos = -1;
            int valuesWritten = 0;
            while (true) {
                JsonToken jsonToken = parser.nextToken();
                JsonToken jsonToken2 = JsonToken.END_ARRAY;
                if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break block5;
                ++pos;
                dataType = elementType;
                if (this.scalarType(dataType)) {
                    DataType dataType2 = col.dataType();
                    DataType dataType3 = dataType;
                    if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                        this.readScalar(parser, elementType, name, col, offset + pos);
                        continue;
                    }
                }
                if (this.scalarType(dataType)) {
                    this.readScalar(parser, elementType, name, col.getChild(0), offset + pos);
                    continue;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    WritableColumnVector elements = col.getChild(0);
                    int len = this.readValue(parser, new StringBuilder(2).append(name).append("[").append(pos).append("]").toString(), (DataType)arrayType, elements, pos, offset + valuesWritten);
                    col.putArray(pos, offset + valuesWritten, len);
                    valuesWritten += len;
                    continue;
                }
                if (!(dataType instanceof MapType)) break;
                MapType mapType = (MapType)dataType;
                DataType dataType4 = mapType.keyType();
                DataType valueType = mapType.valueType();
                DataType dataType5 = DataTypes.StringType;
                DataType dataType6 = dataType4;
                if (dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null) break;
                int len = this.readMap(parser, new StringBuilder(4).append(name).append("[").append(pos).append("]{}").toString(), valueType, col, pos, offset + valuesWritten);
                valuesWritten += len;
            }
            throw package$.MODULE$.error(new StringBuilder(24).append("readArray can't read ").append(name).append(": ").append(dataType).append("!").toString());
        }
        return pos + 1;
    }

    private int readMap(JsonParser parser, String name, DataType valueType, WritableColumnVector col, int rowId, int offset) {
        WritableColumnVector keys = col.getChild(0);
        WritableColumnVector values = col.getChild(1);
        int pos = -1;
        int valuesWritten = 0;
        while (true) {
            JsonToken jsonToken = parser.nextToken();
            JsonToken jsonToken2 = JsonToken.END_OBJECT;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            String key = parser.currentName();
            keys.reserve(offset + ++pos + 1);
            keys.putByteArray(offset + pos, key.getBytes("UTF-8"));
            parser.nextToken();
            int len = this.readValue(parser, new StringBuilder(1).append(name).append(".").append(key).toString(), valueType, values, rowId, offset + pos);
            valuesWritten += len;
        }
        col.putArray(rowId, offset, valuesWritten);
        return valuesWritten;
    }

    private void readScalar(JsonParser parser, DataType dataType, String name, WritableColumnVector col, int pos) {
        JsonToken tok = parser.currentToken();
        col.reserve(pos + 1);
        JsonToken jsonToken = tok;
        JsonToken jsonToken2 = JsonToken.VALUE_NULL;
        if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
            col.putNull(pos);
            return;
        }
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType2 = dataType;
        DataType dataType3 = DataTypes.StringType;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            JsonToken jsonToken3 = tok;
            JsonToken jsonToken4 = JsonToken.VALUE_STRING;
            if (!(jsonToken3 != null ? !jsonToken3.equals(jsonToken4) : jsonToken4 != null)) {
                String s = parser.getText();
                byte[] bytes = s.getBytes("UTF-8");
                col.putByteArray(pos, bytes);
                return;
            }
        }
        DataType dataType5 = DataTypes.BooleanType;
        DataType dataType6 = dataType2;
        if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null) && tok.isBoolean()) {
            JsonToken jsonToken5 = tok;
            JsonToken jsonToken6 = JsonToken.VALUE_TRUE;
            col.putBoolean(pos, !(jsonToken5 != null ? !jsonToken5.equals(jsonToken6) : jsonToken6 != null));
            return;
        }
        DataType dataType7 = DataTypes.ByteType;
        DataType dataType8 = dataType2;
        if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
            JsonToken jsonToken7 = tok;
            JsonToken jsonToken8 = JsonToken.VALUE_NUMBER_INT;
            if (!(jsonToken7 != null ? !jsonToken7.equals(jsonToken8) : jsonToken8 != null)) {
                col.putByte(pos, parser.getByteValue());
                return;
            }
        }
        DataType dataType9 = DataTypes.ShortType;
        DataType dataType10 = dataType2;
        if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
            JsonToken jsonToken9 = tok;
            JsonToken jsonToken10 = JsonToken.VALUE_NUMBER_INT;
            if (!(jsonToken9 != null ? !jsonToken9.equals(jsonToken10) : jsonToken10 != null)) {
                col.putShort(pos, parser.getShortValue());
                return;
            }
        }
        DataType dataType11 = DataTypes.IntegerType;
        DataType dataType12 = dataType2;
        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
            JsonToken jsonToken11 = tok;
            JsonToken jsonToken12 = JsonToken.VALUE_NUMBER_INT;
            if (!(jsonToken11 != null ? !jsonToken11.equals(jsonToken12) : jsonToken12 != null)) {
                col.putInt(pos, parser.getIntValue());
                return;
            }
        }
        DataType dataType13 = DataTypes.LongType;
        DataType dataType14 = dataType2;
        if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
            JsonToken jsonToken13 = tok;
            JsonToken jsonToken14 = JsonToken.VALUE_NUMBER_INT;
            if (!(jsonToken13 != null ? !jsonToken13.equals(jsonToken14) : jsonToken14 != null)) {
                col.putLong(pos, parser.getLongValue());
                return;
            }
        }
        if (dataType2 instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType2;
            if (decimalType.scale() == 0) {
                JsonToken jsonToken15 = tok;
                JsonToken jsonToken16 = JsonToken.VALUE_NUMBER_INT;
                if (!(jsonToken15 != null ? !jsonToken15.equals(jsonToken16) : jsonToken16 != null)) {
                    BigDecimal bd = parser.getDecimalValue();
                    col.putDecimal(pos, Decimal$.MODULE$.apply(bd), bd.precision());
                    return;
                }
            }
        }
        DataType dataType15 = DataTypes.FloatType;
        DataType dataType16 = dataType2;
        if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null) && tok.isNumeric()) {
            col.putFloat(pos, parser.getFloatValue());
            return;
        }
        DataType dataType17 = DataTypes.DoubleType;
        DataType dataType18 = dataType2;
        if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null) && tok.isNumeric()) {
            col.putDouble(pos, parser.getDoubleValue());
            return;
        }
        if (bl && tok.isNumeric()) {
            BigDecimal bd = parser.getDecimalValue();
            col.putDecimal(pos, Decimal$.MODULE$.apply(bd), bd.precision());
            return;
        }
        DataType dataType19 = DataTypes.TimestampType;
        DataType dataType20 = dataType2;
        if (!(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null)) {
            OffsetDateTime time = OffsetDateTime.parse(parser.getText());
            col.putLong(pos, DateTimeUtils$.MODULE$.instantToMicros(time.toInstant()));
            return;
        }
        DataType dataType21 = DataTypes.DateType;
        DataType dataType22 = dataType2;
        if (!(dataType21 != null ? !dataType21.equals(dataType22) : dataType22 != null)) {
            LocalDate date = LocalDate.parse(parser.getText());
            col.putInt(pos, DateTimeUtils$.MODULE$.localDateToDays(date));
            return;
        }
        throw package$.MODULE$.error(new StringBuilder(46).append("Can't get a value for ").append(name).append(" of type ").append(dataType2).append(" from a ").append(tok).append(" token!").toString());
    }

    private HdxReaderColumnarJson$() {
    }
}

