/*
 * Decompiled with CFR 0.152.
 */
package io.hydrolix.connectors.spark.partitionreader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.hydrolix.connectors.package$;
import io.hydrolix.connectors.partitionreader.RowAdapter;
import io.hydrolix.connectors.spark.partitionreader.SparkRowAdapter;
import io.hydrolix.connectors.types.ArrayType;
import io.hydrolix.connectors.types.BooleanType$;
import io.hydrolix.connectors.types.DecimalType;
import io.hydrolix.connectors.types.Float32Type$;
import io.hydrolix.connectors.types.Float64Type$;
import io.hydrolix.connectors.types.Int16Type$;
import io.hydrolix.connectors.types.Int32Type$;
import io.hydrolix.connectors.types.Int64Type$;
import io.hydrolix.connectors.types.MapType;
import io.hydrolix.connectors.types.StringType$;
import io.hydrolix.connectors.types.StructField;
import io.hydrolix.connectors.types.StructType;
import io.hydrolix.connectors.types.TimestampType;
import io.hydrolix.connectors.types.ValueType;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkRowAdapter$
extends RowAdapter<InternalRow, GenericArrayData, ArrayBasedMapData> {
    public static final SparkRowAdapter$ MODULE$ = new SparkRowAdapter$();

    public SparkRowAdapter.SparkRowBuilder newRowBuilder(StructType type) {
        return new SparkRowAdapter.SparkRowBuilder(type);
    }

    public SparkRowAdapter.SparkArrayBuilder newArrayBuilder(ArrayType type) {
        return new SparkRowAdapter.SparkArrayBuilder(type);
    }

    public SparkRowAdapter.SparkMapBuilder newMapBuilder(MapType type) {
        return new SparkRowAdapter.SparkMapBuilder(type);
    }

    public Object string(String value) {
        return UTF8String.fromString((String)value);
    }

    public Object jsonString(TextNode s, ValueType dt) {
        ValueType valueType = dt;
        if (StringType$.MODULE$.equals(valueType)) {
            return UTF8String.fromString((String)s.textValue());
        }
        if (valueType instanceof TimestampType) {
            Instant inst = Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(s.textValue()));
            return BoxesRunTime.boxToLong((long)package$.MODULE$.instantToMicros(inst));
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(33).append("TODO make a ").append(valueType).append(" from string value '").append(s).append("'").toString());
    }

    public Object jsonNumber(NumericNode n, ValueType dt) {
        ValueType valueType = dt;
        if (valueType instanceof DecimalType) {
            return Decimal$.MODULE$.apply(n.decimalValue());
        }
        if (Int64Type$.MODULE$.equals(valueType)) {
            return BoxesRunTime.boxToLong((long)n.longValue());
        }
        if (Float64Type$.MODULE$.equals(valueType)) {
            return BoxesRunTime.boxToDouble((double)n.doubleValue());
        }
        if (Float32Type$.MODULE$.equals(valueType)) {
            return BoxesRunTime.boxToFloat((float)n.floatValue());
        }
        if (Int32Type$.MODULE$.equals(valueType)) {
            return BoxesRunTime.boxToInteger((int)n.intValue());
        }
        if (Int16Type$.MODULE$.equals(valueType)) {
            return BoxesRunTime.boxToShort((short)n.shortValue());
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(31).append("TODO make a ").append(valueType).append(" from JSON value '").append(n).append("'").toString());
    }

    public Object jsonBoolean(BooleanNode n, ValueType dt) {
        ValueType valueType = dt;
        if (BooleanType$.MODULE$.equals(valueType)) {
            return BoxesRunTime.boxToBoolean((boolean)n.booleanValue());
        }
        if (Int32Type$.MODULE$.equals(valueType)) {
            if (n.booleanValue()) {
                return BoxesRunTime.boxToInteger((int)1);
            }
            return BoxesRunTime.boxToInteger((int)0);
        }
        if (Int64Type$.MODULE$.equals(valueType)) {
            if (n.booleanValue()) {
                return BoxesRunTime.boxToLong((long)1L);
            }
            return BoxesRunTime.boxToLong((long)0L);
        }
        if (Float64Type$.MODULE$.equals(valueType)) {
            if (n.booleanValue()) {
                return BoxesRunTime.boxToDouble((double)1.0);
            }
            return BoxesRunTime.boxToDouble((double)0.0);
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(31).append("TODO make a ").append(valueType).append(" from JSON value '").append(n).append("'").toString());
    }

    public InternalRow row(StructType type, ObjectNode obj) {
        SparkRowAdapter.SparkRowBuilder rb = this.newRowBuilder(type);
        type.fields().foreach((Function1 & Serializable)sf -> {
            SparkRowAdapter$.$anonfun$row$1(obj, rb, sf);
            return BoxedUnit.UNIT;
        });
        return rb.build();
    }

    public static final /* synthetic */ void $anonfun$row$1(ObjectNode obj$1, SparkRowAdapter.SparkRowBuilder rb$1, StructField sf) {
        JsonNode node = obj$1.get(sf.name());
        Object value = MODULE$.node2Any(node, sf.type());
        if (value == null) {
            rb$1.setNull(sf.name());
            return;
        }
        rb$1.setField(sf.name(), value);
    }

    private SparkRowAdapter$() {
    }
}

