/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * Descriptor that unambiguously describes how the bits of a pixel are<br>
 * stored in the up to 4 data planes of an image. It also stores the<br>
 * subsampling factors and number of components.<br>
 * <br>
 * Note: This is separate of the colorspace (RGB, YCbCr, YPbPr, JPEG-style YUV<br>
 *       and all the YUV variants) AVPixFmtDescriptor just stores how values<br>
 *       are stored not what these values represent.
 */
public class PixelFormatDescriptor extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected PixelFormatDescriptor(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.PixelFormatDescriptor_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected PixelFormatDescriptor(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.PixelFormatDescriptor_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(PixelFormatDescriptor obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new PixelFormatDescriptor object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public PixelFormatDescriptor copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new PixelFormatDescriptor(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof PixelFormatDescriptor)
      equal = (((PixelFormatDescriptor)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
/**
 * Get the name of this pixel descriptor 
 */
  public String getName() {
    return VideoJNI.PixelFormatDescriptor_getName(swigCPtr, this);
  }

/**
 * The number of components each pixel has, (1-4) 
 */
  public short getNumComponents() {
    return VideoJNI.PixelFormatDescriptor_getNumComponents(swigCPtr, this);
  }

/**
 * Amount to shift the luma width right to find the chroma width.<br>
 * For YV12 this is 1 for example.<br>
 * chroma_width = -((-luma_width) &gt;&gt; log2_chroma_w)<br>
 * The note above is needed to ensure rounding up.<br>
 * This value only refers to the chroma components.
 */
  public short getLog2ChromaWidth() {
    return VideoJNI.PixelFormatDescriptor_getLog2ChromaWidth(swigCPtr, this);
  }

/**
 * Amount to shift the luma height right to find the chroma height.<br>
 * For YV12 this is 1 for example.<br>
 * chroma_height= -((-luma_height) &gt;&gt; log2_chroma_h)<br>
 * The note above is needed to ensure rounding up.<br>
 * This value only refers to the chroma components.
 */
  public short getLog2ChromaHeight() {
    return VideoJNI.PixelFormatDescriptor_getLog2ChromaHeight(swigCPtr, this);
  }

/**
 * Get the flags for this Pixel Format. This is a bitmask of the PixelFormatDescriptor.Flag enum values.
 */
  public short getFlags() {
    return VideoJNI.PixelFormatDescriptor_getFlags(swigCPtr, this);
  }

/**
 * Is the given flag set on this format?
 */
  public boolean getFlag(PixelFormatDescriptor.Flag flag) {
    return VideoJNI.PixelFormatDescriptor_getFlag(swigCPtr, this, flag.swigValue());
  }

/**
 * Return the number of bits per pixel used by the pixel format<br>
 * described by pixdesc. Note that this is not the same as the number<br>
 * of bits per sample.<br>
 * <br>
 * The returned number of bits refers to the number of bits actually<br>
 * used for storing the pixel information, that is padding bits are<br>
 * not counted.
 */
  public int getBitsPerPixel() {
    return VideoJNI.PixelFormatDescriptor_getBitsPerPixel(swigCPtr, this);
  }

/**
 * Return the number of bits per pixel for the pixel format<br>
 * described by pixdesc, including any padding or unused bits.
 */
  public int getPaddedBitsPerPixel() {
    return VideoJNI.PixelFormatDescriptor_getPaddedBitsPerPixel(swigCPtr, this);
  }

/**
 * Parameters that describe how pixels are packed.<br>
 * If the format has 2 or 4 components, then alpha is last.<br>
 * If the format has 1 or 2 components, then luma is 0.<br>
 * If the format has 3 or 4 components,<br>
 * if the RGB flag is set then 0 is red, 1 is green and 2 is blue;<br>
 * otherwise 0 is luma, 1 is chroma-U and 2 is chroma-V.
 */
  public PixelComponentDescriptor getComponentDescriptor(int component) {
    long cPtr = VideoJNI.PixelFormatDescriptor_getComponentDescriptor(swigCPtr, this, component);
    return (cPtr == 0) ? null : new PixelComponentDescriptor(cPtr, false);
  }

/**
 * @return an PixelFormat id described by desc, or PixelFormat.Type.PIX_FMT_NONE if desc<br>
 * is not a valid pointer to a pixel format descriptor.
 */
  public PixelFormat.Type getFormat() {
    return PixelFormat.Type.swigToEnum(VideoJNI.PixelFormatDescriptor_getFormat(swigCPtr, this));
  }

  public enum Flag {
  /**
   * Pixel format is big-endian.
   */
    PIX_FMT_FLAG_BE(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_BE_get()),
  /**
   * Pixel format has a palette in data[1], values are indexes in this palette.
   */
    PIX_FMT_FLAG_PAL(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_PAL_get()),
  /**
   * All values of a component are bit-wise packed end to end.
   */
    PIX_FMT_FLAG_BITSTREAM(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_BITSTREAM_get()),
  /**
   * Pixel format is an HW accelerated format.
   */
    PIX_FMT_FLAG_HWACCEL(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_HWACCEL_get()),
  /**
   * At least one pixel component is not in the first data plane.
   */
    PIX_FMT_FLAG_PLANAR(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_PLANAR_get()),
  /**
   * The pixel format contains RGB-like data (as opposed to YUV/grayscale).
   */
    PIX_FMT_FLAG_RGB(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_RGB_get()),
  /**
   * The pixel format is "pseudo-paletted". This means that FFmpeg treats it as<br>
   * paletted internally, but the palette is generated by the decoder and is not<br>
   * stored in the file.
   */
    PIX_FMT_FLAG_PSEUDOPAL(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_PSEUDOPAL_get()),
  /**
   * The pixel format has an alpha channel.
   */
    PIX_FMT_FLAG_ALPHA(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_ALPHA_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Flag swigToEnum(int swigValue) {
      Flag[] swigValues = Flag.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Flag swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Flag() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Flag(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Flag(Flag swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
