/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * Converts MediaPicture objects of a given width, height and format to a new<br>
 * width, height or format.
 */
public class MediaPictureResampler extends MediaResampler {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected MediaPictureResampler(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.MediaPictureResampler_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected MediaPictureResampler(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.MediaPictureResampler_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(MediaPictureResampler obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new MediaPictureResampler object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public MediaPictureResampler copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new MediaPictureResampler(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof MediaPictureResampler)
      equal = (((MediaPictureResampler)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
  @Override
  public String toString()
  {
    StringBuilder result = new StringBuilder();
    
    result.append(this.getClass().getName()+"@"+hashCode()+"[");
    result.append("input width:"+getInputWidth()+";");
    result.append("input height:"+getInputHeight()+";");
    result.append("input format:"+getInputFormat()+";");
    result.append("output width:"+getOutputWidth()+";");
    result.append("output height:"+getOutputHeight()+";");
    result.append("output format:"+getOutputFormat()+";");
    result.append("]");
    return result.toString();
  }


/**
 * Get the width in pixels we expect on the input frame to the resampler.<br>
 * @return The width we expect on the input frame to the resampler.
 */
  public int getInputWidth() {
    return VideoJNI.MediaPictureResampler_getInputWidth(swigCPtr, this);
  }

/**
 * Get the height in pixels we expect on the input frame to the resampler.<br>
 * @return The height we expect on the input frame to the resampler.
 */
  public int getInputHeight() {
    return VideoJNI.MediaPictureResampler_getInputHeight(swigCPtr, this);
  }

/**
 * Get the input pixel format.<br>
 * @return The pixel format we expect on the input frame to the resampler.
 */
  public PixelFormat.Type getInputFormat() {
    return PixelFormat.Type.swigToEnum(VideoJNI.MediaPictureResampler_getInputFormat(swigCPtr, this));
  }

/**
 * Get the output width, in pixels.<br>
 * @return The width we will resample the output frame to
 */
  public int getOutputWidth() {
    return VideoJNI.MediaPictureResampler_getOutputWidth(swigCPtr, this);
  }

/**
 * Get the output height, in pixels.<br>
 * @return The height we will resample the output frame to
 */
  public int getOutputHeight() {
    return VideoJNI.MediaPictureResampler_getOutputHeight(swigCPtr, this);
  }

/**
 * Get the output pixel format.<br>
 * @return The pixel format we will resample the output frame to
 */
  public PixelFormat.Type getOutputFormat() {
    return PixelFormat.Type.swigToEnum(VideoJNI.MediaPictureResampler_getOutputFormat(swigCPtr, this));
  }

/**
 * Opens the resampler so it can be ready for resampling.<br>
 * You should NOT set options after you open this object.
 */
  public void open() {
    VideoJNI.MediaPictureResampler_open(swigCPtr, this);
  }

/**
 * Resample in to out based on the resampler parameters.<br>
 * <br>
 * Resamples the in picture based on the parameters set when<br>
 * this resampler was constructed.<br>
 * <br>
 * @param out The picture we'll resample to.  Check<br>
 *     MediaPicture#isComplete() after the call.<br>
 * @param in The picture we'll resample from.<br>
 * <br>
 * @throws InvalidArgument if in our out does not match the parameters this<br>
 *         resampler was set with.
 */
  public int resample(MediaSampled out, MediaSampled in) {
    return VideoJNI.MediaPictureResampler_resample(swigCPtr, this, MediaSampled.getCPtr(out), out, MediaSampled.getCPtr(in), in);
  }

/**
 * A more precisely typed way to call #resample
 */
  public int resamplePicture(MediaPicture out, MediaPicture in) {
    return VideoJNI.MediaPictureResampler_resamplePicture(swigCPtr, this, MediaPicture.getCPtr(out), out, MediaPicture.getCPtr(in), in);
  }

/**
 * Get a new picture resampler.<br>
 * <br>
 * @param outputWidth The width in pixels you want to output frame to have.<br>
 * @param outputHeight The height in pixels you want to output frame to have.<br>
 * @param outputFmt The pixel format of the output frame.<br>
 * @param inputWidth The width in pixels the input frame will be in.<br>
 * @param inputHeight The height in pixels the input frame will be in.<br>
 * @param inputFmt The pixel format of the input frame.<br>
 * @return a new object, or null if we cannot allocate one.
 */
  public static MediaPictureResampler make(int outputWidth, int outputHeight, PixelFormat.Type outputFmt, int inputWidth, int inputHeight, PixelFormat.Type inputFmt, int flags) {
    long cPtr = VideoJNI.MediaPictureResampler_make(outputWidth, outputHeight, outputFmt.swigValue(), inputWidth, inputHeight, inputFmt.swigValue(), flags);
    return (cPtr == 0) ? null : new MediaPictureResampler(cPtr, false);
  }

  public enum Flag {
    FLAG_FAST_BILINEAR(VideoJNI.MediaPictureResampler_FLAG_FAST_BILINEAR_get()),
    FLAG_BILINEAR(VideoJNI.MediaPictureResampler_FLAG_BILINEAR_get()),
    FLAG_BICUBIC(VideoJNI.MediaPictureResampler_FLAG_BICUBIC_get()),
    FLAG_X(VideoJNI.MediaPictureResampler_FLAG_X_get()),
    FLAG_POINT(VideoJNI.MediaPictureResampler_FLAG_POINT_get()),
    FLAG_AREA(VideoJNI.MediaPictureResampler_FLAG_AREA_get()),
    FLAG_BICUBLIN(VideoJNI.MediaPictureResampler_FLAG_BICUBLIN_get()),
    FLAG_GAUSS(VideoJNI.MediaPictureResampler_FLAG_GAUSS_get()),
    FLAG_SINC(VideoJNI.MediaPictureResampler_FLAG_SINC_get()),
    FLAG_LANCZOS(VideoJNI.MediaPictureResampler_FLAG_LANCZOS_get()),
    FLAG_SPLINE(VideoJNI.MediaPictureResampler_FLAG_SPLINE_get()),
    FLAG_SRC_V_CHR_DROP_MASK(VideoJNI.MediaPictureResampler_FLAG_SRC_V_CHR_DROP_MASK_get()),
    FLAG_SRC_V_CHR_DROP_SHIFT(VideoJNI.MediaPictureResampler_FLAG_SRC_V_CHR_DROP_SHIFT_get()),
    FLAG_PARAM_DEFAULT(VideoJNI.MediaPictureResampler_FLAG_PARAM_DEFAULT_get()),
    FLAG_FULL_CHR_H_INT(VideoJNI.MediaPictureResampler_FLAG_FULL_CHR_H_INT_get()),
    FLAG_FULL_CHR_H_INP(VideoJNI.MediaPictureResampler_FLAG_FULL_CHR_H_INP_get()),
    FLAG_DIRECT_BGR(VideoJNI.MediaPictureResampler_FLAG_DIRECT_BGR_get()),
    FLAG_ACCURATE_RND(VideoJNI.MediaPictureResampler_FLAG_ACCURATE_RND_get()),
    FLAG_BITEXACT(VideoJNI.MediaPictureResampler_FLAG_BITEXACT_get()),
    FLAG_ERROR_DIFFUSION(VideoJNI.MediaPictureResampler_FLAG_ERROR_DIFFUSION_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Flag swigToEnum(int swigValue) {
      Flag[] swigValues = Flag.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Flag swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Flag() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Flag(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Flag(Flag swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
