/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * KeyValueBag is a bag of key/value pairs that can be embedded<br>
 * in some Container or some Stream<br>
 * in an Container, and are then written to<br>
 * or read from a media file.  Keys must be unique, and<br>
 * any attempt to set a key value replaces any previous values.<br>
 * </p><br>
 * <p><br>
 * An example is the "title" meta-data item in an MP3 file.<br>
 * </p><br>
 * <p><br>
 * Support for KeyValueBag differs depending upon the <br>
 * Container format you're using and the implementation<br>
 * in <a href="http://www.ffmpeg.org/">FFmpeg</a>.  For example,<br>
 * MP3 meta-data reading and writing is supported, but<br>
 * (as of the writing of this comment) FLV meta-data writing<br>
 * is not supported.<br>
 * </p>
 */
public class KeyValueBag extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected KeyValueBag(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.KeyValueBag_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected KeyValueBag(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.KeyValueBag_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(KeyValueBag obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new KeyValueBag object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public KeyValueBag copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new KeyValueBag(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof KeyValueBag)
      equal = (((KeyValueBag)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
  /**
   * Return the meta-data, with all values expanded.
   */
  @Override
  public String toString()
  {
    StringBuilder result = new StringBuilder();
    result.append(this.getClass().getName()).append("@").append(hashCode());
    result.append("[");
    java.util.Collection<String> keys = getKeys();
    for(String key: keys)
    {
      String value = getValue(key, KeyValueBag.Flags.KVB_NONE);
      result.append(key).append("=").append(value).append(";");
    }
    result.append("]");
    return result.toString();
  }
  
  /**
   * Get the set of keys currently in this {@link KeyValueBag} object
   * as an unordered collection.
   * @return the keys.
   */
  public java.util.Collection<String> getKeys()
  {
    int numKeys = getNumKeys();
    
    java.util.List<String> retval = new java.util.ArrayList<String>(numKeys);
    for(int i = 0; i < getNumKeys(); i++)
    {
      String key = getKey(i);
      if (key != null && key.length() > 0)
        retval.add(key);
    }
    return retval;
  }
 
  /**
   * Return the value for this key, comparing case insensitively.
   * @param key the key
   * @return the value.
   */
  public String getValue(String key)
  {
    return getValue(key, KeyValueBag.Flags.KVB_NONE);
  }

/**
 * Get the total number of keys currently in this<br>
 * KeyValueBag object.<br>
 * <br>
 * @return the number of keys.
 */
  public int getNumKeys() {
    return VideoJNI.KeyValueBag_getNumKeys(swigCPtr, this);
  }

/**
 * Get the key at the given position, or null if no such<br>
 * key at that position.<br>
 * <br>
 * <p><br>
 * Note: positions of keys may change between<br>
 * calls to #setValue(String, String) and <br>
 * should be requiried.<br>
 * </p><br>
 * <br>
 * @param position The position.  Must be &gt;=0 and &lt; <br>
 * #getNumKeys().<br>
 * <br>
 * @return the key, or null if not found.
 */
  private String getKey(int position) {
    return VideoJNI.KeyValueBag_getKey(swigCPtr, this, position);
  }

/**
 * Get the value for the given key.<br>
 * <br>
 * @param key The key<br>
 * @param flag A flag for how to search<br>
 * <br>
 * @return The value, or null if none.
 */
  public String getValue(String key, KeyValueBag.Flags flag) {
    return VideoJNI.KeyValueBag_getValue(swigCPtr, this, key, flag.swigValue());
  }

/**
 * Sets the value for the given key to value.  This overrides<br>
 * any prior setting for key, or adds key to the meta-data<br>
 * if appropriate.<br>
 * <br>
 * @param key The key to set.<br>
 * @param value The value to set.
 */
  public int setValue(String key, String value) {
    return VideoJNI.KeyValueBag_setValue__SWIG_0(swigCPtr, this, key, value);
  }

/**
 * Create a new KeyValueBag bag of properties with<br>
 * no values set.
 */
  public static KeyValueBag make() {
    long cPtr = VideoJNI.KeyValueBag_make();
    return (cPtr == 0) ? null : new KeyValueBag(cPtr, false);
  }

/**
 * Sets the value for the given key to value.  This overrides<br>
 * any prior setting for key, or adds key to the meta-data<br>
 * if appropriate.<br>
 * <br>
 * @param key The key to set.<br>
 * @param value The value to set.<br>
 * @param flag A flag on how this should be set.<br>
 * <br>
 * @since 5.0
 */
  public int setValue(String key, String value, KeyValueBag.Flags flag) {
    return VideoJNI.KeyValueBag_setValue__SWIG_1(swigCPtr, this, key, value, flag.swigValue());
  }

  /**
   * Different types of flags that can be passed to KeyValueBag#getValue
   */
  public enum Flags {
  /**
   * For #getValue(String) case-insensitive match of key.
   */
    KVB_NONE(VideoJNI.KeyValueBag_KVB_NONE_get()),
  /**
   * For #getValue(String) case-sensitive match of key.
   */
    KVB_MATCH_CASE(VideoJNI.KeyValueBag_KVB_MATCH_CASE_get()),
  /**
   * For #setValue(String,String,Flags) do not overwrite existing value -- append another key/value pair.
   */
    KVB_DONT_OVERWRITE(VideoJNI.KeyValueBag_KVB_DONT_OVERWRITE_get()),
  /**
   * For #setValue(String,String,Flags) append to the existing value in a key (string append).
   */
    KVB_APPEND(VideoJNI.KeyValueBag_KVB_APPEND_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Flags swigToEnum(int swigValue) {
      Flags[] swigValues = Flags.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Flags swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Flags() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Flags(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Flags(Flags swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
