/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * A type of filter that can be created.
 */
public class FilterType extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected FilterType(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.FilterType_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected FilterType(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.FilterType_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(FilterType obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new FilterType object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public FilterType copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new FilterType(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof FilterType)
      equal = (((FilterType)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  

/**
 * @return name of this filter type.
 */
  public String getName() {
    return VideoJNI.FilterType_getName(swigCPtr, this);
  }

/**
 * @return description of this filter type.
 */
  public String getDescription() {
    return VideoJNI.FilterType_getDescription(swigCPtr, this);
  }

/**
 * @return bitmask of Flags set on this FilterType.
 */
  public int getFlags() {
    return VideoJNI.FilterType_getFlags(swigCPtr, this);
  }

/**
 * @param flag flag to check setting of.<br>
 * @return is this flag set on the given FilterType
 */
  public boolean getFlag(FilterType.Flag flag) {
    return VideoJNI.FilterType_getFlag(swigCPtr, this, flag.swigValue());
  }

/**
 * @return number of inputs this FilterType expects.
 */
  public int getNumInputs() {
    return VideoJNI.FilterType_getNumInputs(swigCPtr, this);
  }

/**
 * @param index which input to get name of<br>
 * @return the input name<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumInputs().
 */
  public String getInputName(int index) {
    return VideoJNI.FilterType_getInputName(swigCPtr, this, index);
  }

/**
 * @param index which input to get type of<br>
 * @return the input media type<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumInputs().
 */
  public MediaDescriptor.Type getInputType(int index) {
    return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterType_getInputType(swigCPtr, this, index));
  }

/**
 * @return number of outputs this FilterType expects.
 */
  public int getNumOutputs() {
    return VideoJNI.FilterType_getNumOutputs(swigCPtr, this);
  }

/**
 * @param index which output to get name of<br>
 * @return the output name<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumOutputs().
 */
  public String getOutputName(int index) {
    return VideoJNI.FilterType_getOutputName(swigCPtr, this, index);
  }

/**
 * @param index which output to get type of<br>
 * @return the output media type<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumOutputs().
 */
  public MediaDescriptor.Type getOutputType(int index) {
    return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterType_getOutputType(swigCPtr, this, index));
  }

/**
 * Find a given filter by name.<br>
 * <br>
 * @param name name of filter.
 */
  public static FilterType findFilterType(String name) {
    long cPtr = VideoJNI.FilterType_findFilterType(name);
    return (cPtr == 0) ? null : new FilterType(cPtr, false);
  }

/**
 * @return the number of filters installed in this system.
 */
  public static int getNumFilterTypes() {
    return VideoJNI.FilterType_getNumFilterTypes();
  }

/**
 * @param index the position in the list of installed filters to get. Use<br>
 *   with #getNumFilters() to iterate over all the filters installed<br>
 *   in the system.<br>
 * @return get the filter at the <code>index</code> position in the installed filters.<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt;= #getNumFilterTypes().
 */
  public static FilterType getFilterType(int index) {
    long cPtr = VideoJNI.FilterType_getFilterType(index);
    return (cPtr == 0) ? null : new FilterType(cPtr, false);
  }

  /**
   * Flags that show features different FilterType object support.
   */
  public enum Flag {
  /**
   * Do not use.
   */
    FILTER_FLAG_UNKNOWN(VideoJNI.FilterType_FILTER_FLAG_UNKNOWN_get()),
  /**
   * The number of the filter inputs is not determined just by the number of inputs explicitly added.<br>
   * The filter might add additional inputs during initialization depending on the<br>
   * options supplied to it.
   */
    FILTER_FLAG_DYNAMIC_INPUTS(VideoJNI.FilterType_FILTER_FLAG_DYNAMIC_INPUTS_get()),
  /**
   * The number of the filter outputs is not determined just by AVFilter.outputs.<br>
   * The filter might add additional outputs during initialization depending on<br>
   * the options supplied to it.
   */
    FILTER_FLAG_DYNAMIC_OUTPUTS(VideoJNI.FilterType_FILTER_FLAG_DYNAMIC_OUTPUTS_get()),
  /**
   * The filter supports multithreading by splitting frames into multiple parts<br>
   * and processing them concurrently.
   */
    FILTER_FLAG_SLICE_THREADS(VideoJNI.FilterType_FILTER_FLAG_SLICE_THREADS_get()),
  /**
   * Some filters support a generic "enable" expression option that can be used<br>
   * to enable or disable a filter in the timeline. Filters supporting this<br>
   * option have this flag set. When the enable expression is false, the default<br>
   * no-op filter_frame() function is called in place of the filter_frame()<br>
   * callback defined on each input pad, thus the frame is passed unchanged to<br>
   * the next filters.
   */
    FILTER_FLAG_SUPPORT_TIMELINE_GENERIC(VideoJNI.FilterType_FILTER_FLAG_SUPPORT_TIMELINE_GENERIC_get()),
  /**
   * Same as AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC, except that the filter will<br>
   * have its filter_frame() callback(s) called as usual even when the enable<br>
   * expression is false. The filter will disable filtering within the<br>
   * filter_frame() callback(s) itself, for example executing code depending on<br>
   * the AVFilterContext-&gt;is_disabled value.
   */
    FILTER_FLAG_SUPPORT_TIMELINE_INTERNAL(VideoJNI.FilterType_FILTER_FLAG_SUPPORT_TIMELINE_INTERNAL_get()),
  /**
   * Handy mask to test whether the filter supports or no the timeline feature<br>
   * (internally or generically).
   */
    FILTER_FLAG_SUPPORT_TIMELINE(VideoJNI.FilterType_FILTER_FLAG_SUPPORT_TIMELINE_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Flag swigToEnum(int swigValue) {
      Flag[] swigValues = Flag.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Flag swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Flag() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Flag(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Flag(Flag swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
