/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * A Container for Media data. This is an abstract class and<br>
 * cannot be instantiated on its own.
 */
public class Container extends Configurable {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected Container(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.Container_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected Container(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.Container_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(Container obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new Container object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public Container copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new Container(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof Container)
      equal = (((Container)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
  @Override
  public String toString() {
    final StringBuilder b = new StringBuilder(super.toString());
    b.append("[")
    .append("]");
    return b.toString();
  }


/**
 * The number of streams in this container.<br>
 * <p>If this container is a Source this will query the stream and find out<br>
 * how many streams are in it.</p><p>If the current thread is interrupted while this blocking method<br>
 * is running the method will return with a negative value.<br>
 * To check if the method exited because of an interruption<br>
 * pass the return value to Error#make(int) and then<br>
 * check Error#getType() to see if it is<br>
 * Error.Type#ERROR_INTERRUPTED.<br>
 * </p><br>
 * <br>
 * @return The number of streams in this container.
 */
  public int getNumStreams() throws java.lang.InterruptedException, java.io.IOException {
    return VideoJNI.Container_getNumStreams(swigCPtr, this);
  }

  /**
   * Do not set these flags -- several are used by the internals of Humble Video.
   */
  public enum Flag {
  /**
   * Generate missing pts even if it requires parsing future frames. *
   */
    FLAG_GENPTS(VideoJNI.Container_FLAG_GENPTS_get()),
  /**
   * Ignore index. *
   */
    FLAG_IGNIDX(VideoJNI.Container_FLAG_IGNIDX_get()),
  /**
   * Do not block when reading packets from input. *
   */
    FLAG_NONBLOCK(VideoJNI.Container_FLAG_NONBLOCK_get()),
  /**
   * Ignore DTS on frames that contain both DTS &amp; PTS *
   */
    FLAG_IGNDTS(VideoJNI.Container_FLAG_IGNDTS_get()),
  /**
   * Do not infer any values from other values, just return what is stored in the container *
   */
    FLAG_NOFILLIN(VideoJNI.Container_FLAG_NOFILLIN_get()),
  /**
   * Do not use AVParsers, you also must set AVFMT_FLAG_NOFILLIN as the fillin code works on frames and no parsing -&gt; no frames. Also seeking to frames can not work if parsing to find frame boundaries has been disabled *
   */
    FLAG_NOPARSE(VideoJNI.Container_FLAG_NOPARSE_get()),
  /**
   * Do not buffer frames when possible *
   */
    FLAG_NOBUFFER(VideoJNI.Container_FLAG_NOBUFFER_get()),
  /**
   * The caller has supplied a custom AVIOContext, don't avio_close() it. *
   */
    FLAG_CUSTOM_IO(VideoJNI.Container_FLAG_CUSTOM_IO_get()),
  /**
   * Discard frames marked corrupted *
   */
    FLAG_DISCARD_CORRUPT(VideoJNI.Container_FLAG_DISCARD_CORRUPT_get()),
  /**
   * Enable RTP MP4A-LATM payload *
   */
    FLAG_MP4A_LATM(VideoJNI.Container_FLAG_MP4A_LATM_get()),
  /**
   * try to interleave outputted packets by dts (using this flag can slow demuxing down) *
   */
    FLAG_SORT_DTS(VideoJNI.Container_FLAG_SORT_DTS_get()),
  /**
   * Enable use of private options by delaying codec open (this could be made default once all code is converted) *
   */
    FLAG_PRIV_OPT(VideoJNI.Container_FLAG_PRIV_OPT_get()),
  /**
   * Don't merge side data but keep it separate. *
   */
    FLAG_KEEP_SIDE_DATA(VideoJNI.Container_FLAG_KEEP_SIDE_DATA_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Flag swigToEnum(int swigValue) {
      Flag[] swigValues = Flag.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Flag swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Flag() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Flag(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Flag(Flag swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
