/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.patricia.internal;

import io.hotmoka.crypto.api.Hasher;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.UnmarshallingContexts;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.patricia.FromBytes;
import io.hotmoka.patricia.ToBytes;
import io.hotmoka.patricia.api.KeyValueStore;
import io.hotmoka.patricia.api.KeyValueStoreException;
import io.hotmoka.patricia.api.PatriciaTrie;
import io.hotmoka.patricia.api.TrieException;
import io.hotmoka.patricia.api.UnknownKeyException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;

public abstract class AbstractPatriciaTrieImpl<Key, Value, T extends AbstractPatriciaTrieImpl<Key, Value, T>>
implements PatriciaTrie<Key, Value, T> {
    private final KeyValueStore store;
    private final Hasher<? super Key> hasherForKeys;
    private final Hasher<AbstractNode> hasherForNodes;
    private final ToBytes<? super Value> valueToBytes;
    private final FromBytes<? extends Value> bytesToValue;
    private final Empty EMPTY = new Empty();
    private final byte[] hashOfEmpty;
    private final byte[] root;

    public AbstractPatriciaTrieImpl(KeyValueStore store, byte[] root, Hasher<? super Key> hasherForKeys, HashingAlgorithm hashingForNodes, byte[] hashOfEmpty, ToBytes<? super Value> valueToBytes, FromBytes<? extends Value> bytesToValue) throws TrieException {
        this.store = store;
        this.hasherForKeys = hasherForKeys;
        final Hasher hasher = hashingForNodes.getHasher(AbstractNode::toByteArrayWithoutReferenceCounter);
        this.hashOfEmpty = (byte[])hashOfEmpty.clone();
        this.hasherForNodes = new Hasher<AbstractNode>(){

            public byte[] hash(AbstractNode what) {
                if (what instanceof Empty) {
                    return AbstractPatriciaTrieImpl.this.hashOfEmpty;
                }
                return hasher.hash((Object)what);
            }

            public byte[] hash(AbstractNode what, int start, int length) {
                if (what instanceof Empty) {
                    return AbstractPatriciaTrieImpl.this.hashOfEmpty;
                }
                return hasher.hash((Object)what, start, length);
            }

            public int length() {
                return hasher.length();
            }
        };
        this.bytesToValue = bytesToValue;
        this.valueToBytes = valueToBytes;
        this.root = (byte[])root.clone();
    }

    protected AbstractPatriciaTrieImpl(AbstractPatriciaTrieImpl<Key, Value, T> cloned, byte[] root) throws TrieException {
        this.store = cloned.store;
        this.hasherForKeys = cloned.hasherForKeys;
        this.hasherForNodes = cloned.hasherForNodes;
        this.bytesToValue = cloned.bytesToValue;
        this.valueToBytes = cloned.valueToBytes;
        this.hashOfEmpty = cloned.hashOfEmpty;
        this.root = (byte[])root.clone();
    }

    public Optional<Value> get(Key key) throws TrieException {
        try {
            byte[] hashedKey = this.hasherForKeys.hash(key);
            byte[] nibblesOfHashedKey = AbstractPatriciaTrieImpl.toNibbles(hashedKey);
            AbstractNode rootNode = this.getNodeFromHash(this.root, 0);
            return Optional.of(rootNode.get(nibblesOfHashedKey, 0));
        }
        catch (UnknownKeyException e) {
            return Optional.empty();
        }
    }

    public T put(Key key, Value value) throws TrieException {
        byte[] hashedKey = this.hasherForKeys.hash(key);
        byte[] nibblesOfHashedKey = AbstractPatriciaTrieImpl.toNibbles(hashedKey);
        AbstractNode oldRoot = this.getNodeFromHash(this.root, 0);
        AbstractNode newRoot = oldRoot.put(nibblesOfHashedKey, 0, value);
        return (T)((AbstractPatriciaTrieImpl)this.checkoutAt(this.hasherForNodes.hash((Object)newRoot)));
    }

    public final byte[] getRoot() {
        return (byte[])this.root.clone();
    }

    public final void malloc() throws TrieException {
        this.incrementReferenceCountOfNode(this.root, 0);
    }

    public final void free() throws TrieException {
        this.getNodeFromHash(this.root, 0).free(this.root, 0);
    }

    protected final KeyValueStore getStore() {
        return this.store;
    }

    private AbstractNode from(UnmarshallingContext context, int cursor) throws IOException {
        int counter = context.readCompactInt();
        byte kind = context.readByte();
        if (kind == 0 || (kind & 0xF0) == 16) {
            int nodeHashSize = this.hasherForNodes.length();
            int sharedBytesLength = context.available() - nodeHashSize + 1;
            byte[] sharedBytes = new byte[sharedBytesLength];
            sharedBytes[0] = kind;
            if (sharedBytesLength - 1 != context.readNBytes(sharedBytes, 1, sharedBytesLength - 1)) {
                throw new IOException("Nibbles length mismatch in an extension node of a Patricia trie");
            }
            byte[] sharedNibbles = AbstractPatriciaTrieImpl.expandBytesIntoNibbles(sharedBytes, (byte)0);
            byte[] next = context.readAllBytes();
            return new Extension(sharedNibbles, next, counter);
        }
        if (kind == 4) {
            short selector = context.readShort();
            int nodeHashSize = this.hasherForNodes.length();
            byte[][] children = new byte[16][];
            int pos = 0;
            int bit = 32768;
            while (pos < 16) {
                if ((selector & bit) != 0) {
                    children[pos] = new byte[nodeHashSize];
                    if (nodeHashSize != context.readNBytes(children[pos], 0, nodeHashSize)) {
                        throw new IOException("Hash length mismatch in Patricia node");
                    }
                }
                ++pos;
                bit >>= 1;
            }
            return new Branch(children, counter);
        }
        if (kind == 2 || (kind & 0xF0) == 48) {
            int expected = cursor % 2 == 0 ? this.hasherForKeys.length() - cursor / 2 + 1 : this.hasherForKeys.length() - cursor / 2;
            byte[] bytes = new byte[expected];
            bytes[0] = kind;
            if (expected - 1 != context.readNBytes(bytes, 1, expected - 1)) {
                throw new IOException("keyEnd length mismatch in a leaf node of a Patricia trie");
            }
            byte[] keyEnd = AbstractPatriciaTrieImpl.expandBytesIntoNibbles(bytes, (byte)2);
            byte[] value = context.readAllBytes();
            return new Leaf(keyEnd, value, counter);
        }
        if (kind == 5) {
            return this.EMPTY;
        }
        throw new IOException("Unexpected Patricia node kind: " + kind);
    }

    private AbstractNode getNodeFromHash(byte[] hash, int cursor) throws TrieException {
        try {
            return this.getNodeFromHashIfPresent(hash, cursor);
        }
        catch (UnknownKeyException e) {
            throw new TrieException("This trie refers to a node that cannot be found in the trie itself", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private AbstractNode getNodeFromHashIfPresent(byte[] hash, int cursor) throws TrieException, UnknownKeyException {
        if (Arrays.equals(hash, this.hashOfEmpty)) {
            return this.EMPTY;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.store.get(hash));){
            AbstractNode abstractNode;
            block14: {
                UnmarshallingContext context = UnmarshallingContexts.of((InputStream)bais);
                try {
                    abstractNode = this.from(context, cursor);
                    if (context == null) break block14;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return abstractNode;
        }
        catch (KeyValueStoreException | IOException e) {
            throw new TrieException(e);
        }
    }

    private void incrementReferenceCountOfNode(byte[] hash, int cursor) throws TrieException {
        AbstractNode node = this.getNodeFromHash(hash, cursor);
        node = node.withIncrementedReferenceCount();
        try {
            this.store.put(hash, node.toByteArray());
        }
        catch (KeyValueStoreException e) {
            throw new TrieException((Throwable)e);
        }
    }

    private static byte[] toNibbles(byte[] original) {
        int length = original.length;
        byte[] split = new byte[length * 2];
        int pos = 0;
        for (byte b : original) {
            split[pos++] = (byte)((b & 0xF0) >> 4);
            split[pos++] = (byte)(b & 0xF);
        }
        return split;
    }

    private static byte[] compactNibblesIntoBytes(byte[] nibbles, byte evenSelector, byte oddSelector) {
        int length = nibbles.length;
        byte[] result = new byte[1 + length / 2];
        if (length % 2 == 0) {
            result[0] = evenSelector;
            for (int pos = 0; pos < length; pos += 2) {
                result[1 + pos / 2] = (byte)(nibbles[pos] << 4 | nibbles[pos + 1]);
            }
        } else {
            result[0] = (byte)(oddSelector << 4 | nibbles[0]);
            for (int pos = 1; pos < length; pos += 2) {
                result[1 + pos / 2] = (byte)(nibbles[pos] << 4 | nibbles[pos + 1]);
            }
        }
        return result;
    }

    private static byte[] expandBytesIntoNibbles(byte[] bytes, byte evenSelector) {
        byte[] nibbles;
        if (bytes[0] == evenSelector) {
            nibbles = new byte[(bytes.length - 1) * 2];
            for (int pos = 1; pos < bytes.length; ++pos) {
                nibbles[(pos - 1) * 2] = (byte)((bytes[pos] & 0xF0) >> 4);
                nibbles[pos * 2 - 1] = (byte)(bytes[pos] & 0xF);
            }
        } else {
            nibbles = new byte[bytes.length * 2 - 1];
            nibbles[0] = (byte)(bytes[0] & 0xF);
            for (int pos = 1; pos < bytes.length; ++pos) {
                nibbles[pos * 2 - 1] = (byte)((bytes[pos] & 0xF0) >> 4);
                nibbles[pos * 2] = (byte)(bytes[pos] & 0xF);
            }
        }
        return nibbles;
    }

    private class Empty
    extends AbstractNode {
        private Empty() {
            super(0);
        }

        @Override
        protected void intoWithoutReferenceCounter(MarshallingContext context) throws IOException {
            context.writeByte(5);
        }

        @Override
        protected void incrementReferenceCountOfDescedants(int cursor) {
        }

        @Override
        protected void free(byte[] hash, int cursor) {
        }

        @Override
        protected void freeDescendants(int cursor) {
        }

        @Override
        protected AbstractNode withIncrementedReferenceCount() {
            return this;
        }

        @Override
        protected AbstractNode withDecrementedReferenceCount() {
            return this;
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws UnknownKeyException {
            throw new UnknownKeyException("Key not found in Patricia trie");
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws TrieException {
            byte[] nibblesEnd = new byte[nibblesOfHashedKey.length - cursor];
            System.arraycopy(nibblesOfHashedKey, cursor, nibblesEnd, 0, nibblesEnd.length);
            try {
                return new Leaf(nibblesEnd, AbstractPatriciaTrieImpl.this.valueToBytes.get(value), 0).putInStore(cursor);
            }
            catch (IOException e) {
                throw new TrieException((Throwable)e);
            }
        }
    }

    private abstract class AbstractNode
    extends AbstractMarshallable {
        protected final int count;

        protected AbstractNode(int count) {
            this.count = count;
        }

        public final void into(MarshallingContext context) throws IOException {
            context.writeCompactInt(this.count);
            this.intoWithoutReferenceCounter(context);
        }

        protected final AbstractNode putInStore(int cursor) throws TrieException {
            byte[] hash = AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)this);
            try {
                return AbstractPatriciaTrieImpl.this.getNodeFromHashIfPresent(hash, cursor);
            }
            catch (UnknownKeyException e) {
                try {
                    AbstractPatriciaTrieImpl.this.store.put(hash, this.toByteArray());
                    this.incrementReferenceCountOfDescedants(cursor);
                    return this;
                }
                catch (KeyValueStoreException ee) {
                    throw new TrieException((Throwable)ee);
                }
            }
        }

        protected void free(byte[] hash, int cursor) throws TrieException {
            AbstractNode replacement = this.withDecrementedReferenceCount();
            try {
                if (replacement.count > 0) {
                    AbstractPatriciaTrieImpl.this.store.put(hash, replacement.toByteArray());
                } else {
                    AbstractPatriciaTrieImpl.this.store.remove(hash);
                    this.freeDescendants(cursor);
                }
            }
            catch (KeyValueStoreException | UnknownKeyException e) {
                throw new TrieException(e);
            }
        }

        protected abstract void freeDescendants(int var1) throws TrieException;

        protected abstract void incrementReferenceCountOfDescedants(int var1) throws TrieException;

        protected abstract AbstractNode withIncrementedReferenceCount();

        protected abstract AbstractNode withDecrementedReferenceCount();

        protected abstract Value get(byte[] var1, int var2) throws UnknownKeyException, TrieException;

        protected abstract AbstractNode put(byte[] var1, int var2, Value var3) throws TrieException;

        protected abstract void intoWithoutReferenceCounter(MarshallingContext var1) throws IOException;

        /*
         * Enabled aggressive exception aggregation
         */
        private byte[] toByteArrayWithoutReferenceCounter() {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                block13: {
                    MarshallingContext context = this.createMarshallingContext(baos);
                    try {
                        this.intoWithoutReferenceCounter(context);
                        context.flush();
                        byArray = baos.toByteArray();
                        if (context == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
    }

    private class Extension
    extends AbstractNode {
        private final byte[] sharedNibbles;
        private final byte[] next;

        private Extension(byte[] sharedNibbles, byte[] next, int count) {
            super(count);
            this.sharedNibbles = sharedNibbles;
            this.next = next;
        }

        @Override
        protected void intoWithoutReferenceCounter(MarshallingContext context) throws IOException {
            context.writeBytes(AbstractPatriciaTrieImpl.compactNibblesIntoBytes(this.sharedNibbles, (byte)0, (byte)1));
            context.writeBytes(this.next);
        }

        @Override
        protected void incrementReferenceCountOfDescedants(int cursor) throws TrieException {
            AbstractPatriciaTrieImpl.this.incrementReferenceCountOfNode(this.next, cursor + this.sharedNibbles.length);
        }

        @Override
        protected AbstractNode withIncrementedReferenceCount() {
            return new Extension(this.sharedNibbles, this.next, this.count + 1);
        }

        @Override
        protected AbstractNode withDecrementedReferenceCount() {
            return new Extension(this.sharedNibbles, this.next, this.count - 1);
        }

        @Override
        protected void freeDescendants(int cursor) throws TrieException {
            int cursorOfNext = cursor + this.sharedNibbles.length;
            AbstractPatriciaTrieImpl.this.getNodeFromHash(this.next, cursorOfNext).free(this.next, cursorOfNext);
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws UnknownKeyException, TrieException {
            int cursor1;
            for (cursor1 = 0; cursor < nibblesOfHashedKey.length && cursor1 < this.sharedNibbles.length; ++cursor1, ++cursor) {
                if (this.sharedNibbles[cursor1] == nibblesOfHashedKey[cursor]) continue;
                throw new UnknownKeyException("Key not found in Patricia trie");
            }
            if (cursor1 != this.sharedNibbles.length || cursor >= nibblesOfHashedKey.length) {
                throw new TrieException("Inconsistent key length in Patricia trie");
            }
            return AbstractPatriciaTrieImpl.this.getNodeFromHash(this.next, cursor).get(nibblesOfHashedKey, cursor);
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws TrieException {
            AbstractNode child2;
            int lengthOfSharedPortion;
            for (lengthOfSharedPortion = 0; lengthOfSharedPortion < this.sharedNibbles.length && nibblesOfHashedKey[lengthOfSharedPortion + cursor] == this.sharedNibbles[lengthOfSharedPortion]; ++lengthOfSharedPortion) {
            }
            int lengthOfDistinctPortion = this.sharedNibbles.length - lengthOfSharedPortion;
            if (lengthOfDistinctPortion == 0) {
                AbstractNode oldNext = AbstractPatriciaTrieImpl.this.getNodeFromHash(this.next, this.sharedNibbles.length + cursor);
                AbstractNode newNext = oldNext.put(nibblesOfHashedKey, this.sharedNibbles.length + cursor, value);
                return new Extension(this.sharedNibbles, AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)newNext), 0).putInStore(cursor);
            }
            byte[] sharedNibbles1 = new byte[lengthOfDistinctPortion - 1];
            System.arraycopy(this.sharedNibbles, lengthOfSharedPortion + 1, sharedNibbles1, 0, sharedNibbles1.length);
            byte[] keyEnd2 = new byte[nibblesOfHashedKey.length - cursor - lengthOfSharedPortion - 1];
            System.arraycopy(nibblesOfHashedKey, lengthOfSharedPortion + cursor + 1, keyEnd2, 0, keyEnd2.length);
            byte selection1 = this.sharedNibbles[lengthOfSharedPortion];
            byte selection2 = nibblesOfHashedKey[lengthOfSharedPortion + cursor];
            byte[][] children = new byte[16][];
            byte[] hashOfChild1 = sharedNibbles1.length == 0 ? this.next : AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)new Extension(sharedNibbles1, this.next, 0).putInStore(cursor + lengthOfSharedPortion + 1));
            try {
                child2 = new Leaf(keyEnd2, AbstractPatriciaTrieImpl.this.valueToBytes.get(value), 0).putInStore(cursor + lengthOfSharedPortion + 1);
            }
            catch (IOException e) {
                throw new TrieException((Throwable)e);
            }
            children[selection1] = hashOfChild1;
            children[selection2] = AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)child2);
            AbstractNode branch = new Branch(children, 0).putInStore(cursor + lengthOfSharedPortion);
            if (lengthOfSharedPortion > 0) {
                byte[] sharedNibbles = new byte[lengthOfSharedPortion];
                System.arraycopy(this.sharedNibbles, 0, sharedNibbles, 0, lengthOfSharedPortion);
                return new Extension(sharedNibbles, AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)branch), 0).putInStore(cursor);
            }
            return branch;
        }
    }

    private class Branch
    extends AbstractNode {
        private final byte[][] children;

        private Branch(byte[][] children, int count) {
            super(count);
            this.children = children;
            for (int pos = 0; pos < children.length; ++pos) {
                if (children[pos] != null) continue;
                this.children[pos] = AbstractPatriciaTrieImpl.this.hashOfEmpty;
            }
        }

        private short selector() {
            short result = 0;
            int pos = 0;
            int bit = 32768;
            while (pos < 16) {
                if (!Arrays.equals(this.children[pos], AbstractPatriciaTrieImpl.this.hashOfEmpty)) {
                    result = (short)(result | bit);
                }
                ++pos;
                bit >>= 1;
            }
            return result;
        }

        @Override
        protected void intoWithoutReferenceCounter(MarshallingContext context) throws IOException {
            context.writeByte(4);
            context.writeShort((int)this.selector());
            for (byte[] child : this.children) {
                if (Arrays.equals(child, AbstractPatriciaTrieImpl.this.hashOfEmpty)) continue;
                context.writeBytes(child);
            }
        }

        @Override
        protected void incrementReferenceCountOfDescedants(int cursor) throws TrieException {
            int cursorOfChildren = cursor + 1;
            for (byte[] child : this.children) {
                if (Arrays.equals(child, AbstractPatriciaTrieImpl.this.hashOfEmpty)) continue;
                AbstractPatriciaTrieImpl.this.incrementReferenceCountOfNode(child, cursorOfChildren);
            }
        }

        @Override
        protected AbstractNode withIncrementedReferenceCount() {
            return new Branch(this.children, this.count + 1);
        }

        @Override
        protected AbstractNode withDecrementedReferenceCount() {
            return new Branch(this.children, this.count - 1);
        }

        @Override
        protected void freeDescendants(int cursor) throws TrieException {
            int cursorOfChildren = cursor + 1;
            for (byte[] child : this.children) {
                if (Arrays.equals(child, AbstractPatriciaTrieImpl.this.hashOfEmpty)) continue;
                AbstractPatriciaTrieImpl.this.getNodeFromHash(child, cursorOfChildren).free(child, cursorOfChildren);
            }
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws UnknownKeyException, TrieException {
            if (cursor >= nibblesOfHashedKey.length) {
                throw new TrieException("Inconsistent key length in Patricia trie nibblesOfHashedKey.length = " + nibblesOfHashedKey.length + ", cursor = " + cursor);
            }
            byte selection = nibblesOfHashedKey[cursor];
            byte[] child = this.children[selection];
            if (Arrays.equals(child, AbstractPatriciaTrieImpl.this.hashOfEmpty)) {
                throw new UnknownKeyException("Key not found in Patricia trie");
            }
            return AbstractPatriciaTrieImpl.this.getNodeFromHash(child, cursor + 1).get(nibblesOfHashedKey, cursor + 1);
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws TrieException {
            if (cursor >= nibblesOfHashedKey.length) {
                throw new TrieException("Inconsistent key length in Patricia trie");
            }
            byte selection = nibblesOfHashedKey[cursor];
            AbstractNode oldChild = AbstractPatriciaTrieImpl.this.getNodeFromHash(this.children[selection], cursor + 1);
            AbstractNode newChild = oldChild.put(nibblesOfHashedKey, cursor + 1, value);
            byte[][] childrenCopy = (byte[][])this.children.clone();
            childrenCopy[selection] = AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)newChild);
            return new Branch(childrenCopy, 0).putInStore(cursor);
        }
    }

    private class Leaf
    extends AbstractNode {
        private final byte[] keyEnd;
        private final byte[] value;

        private Leaf(byte[] keyEnd, byte[] value, int count) {
            super(count);
            this.keyEnd = keyEnd;
            this.value = value;
        }

        @Override
        protected void intoWithoutReferenceCounter(MarshallingContext context) throws IOException {
            context.writeBytes(AbstractPatriciaTrieImpl.compactNibblesIntoBytes(this.keyEnd, (byte)2, (byte)3));
            context.writeBytes(this.value);
        }

        @Override
        protected void incrementReferenceCountOfDescedants(int cursor) {
        }

        @Override
        protected AbstractNode withIncrementedReferenceCount() {
            return new Leaf(this.keyEnd, this.value, this.count + 1);
        }

        @Override
        protected AbstractNode withDecrementedReferenceCount() {
            return new Leaf(this.keyEnd, this.value, this.count - 1);
        }

        @Override
        protected void freeDescendants(int cursor) {
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws UnknownKeyException, TrieException {
            int cursor1;
            for (cursor1 = 0; cursor < nibblesOfHashedKey.length && cursor1 < this.keyEnd.length; ++cursor1, ++cursor) {
                if (this.keyEnd[cursor1] == nibblesOfHashedKey[cursor]) continue;
                throw new UnknownKeyException("Key not found in Patricia trie");
            }
            if (cursor1 != this.keyEnd.length || cursor != nibblesOfHashedKey.length) {
                throw new TrieException("Inconsistent key length in Patricia trie: " + (cursor1 != this.keyEnd.length) + ", " + (cursor != nibblesOfHashedKey.length));
            }
            try {
                return AbstractPatriciaTrieImpl.this.bytesToValue.get(this.value);
            }
            catch (IOException e) {
                throw new TrieException((Throwable)e);
            }
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws TrieException {
            int lengthOfSharedPortion;
            for (lengthOfSharedPortion = 0; lengthOfSharedPortion < this.keyEnd.length && nibblesOfHashedKey[lengthOfSharedPortion + cursor] == this.keyEnd[lengthOfSharedPortion]; ++lengthOfSharedPortion) {
            }
            int lengthOfDistinctPortion = this.keyEnd.length - lengthOfSharedPortion;
            try {
                if (lengthOfDistinctPortion == 0) {
                    return new Leaf(this.keyEnd, AbstractPatriciaTrieImpl.this.valueToBytes.get(value), 0).putInStore(cursor);
                }
                byte[] keyEnd1 = new byte[this.keyEnd.length - lengthOfSharedPortion - 1];
                System.arraycopy(this.keyEnd, lengthOfSharedPortion + 1, keyEnd1, 0, keyEnd1.length);
                byte[] keyEnd2 = new byte[keyEnd1.length];
                System.arraycopy(nibblesOfHashedKey, lengthOfSharedPortion + cursor + 1, keyEnd2, 0, keyEnd2.length);
                byte selection1 = this.keyEnd[lengthOfSharedPortion];
                byte selection2 = nibblesOfHashedKey[lengthOfSharedPortion + cursor];
                byte[][] children = new byte[16][];
                AbstractNode leaf1 = new Leaf(keyEnd1, this.value, 0).putInStore(cursor + lengthOfSharedPortion + 1);
                AbstractNode leaf2 = new Leaf(keyEnd2, AbstractPatriciaTrieImpl.this.valueToBytes.get(value), 0).putInStore(cursor + lengthOfSharedPortion + 1);
                children[selection1] = AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)leaf1);
                children[selection2] = AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)leaf2);
                AbstractNode branch = new Branch(children, 0).putInStore(cursor + lengthOfSharedPortion);
                if (lengthOfSharedPortion > 0) {
                    byte[] sharedNibbles = new byte[lengthOfSharedPortion];
                    System.arraycopy(this.keyEnd, 0, sharedNibbles, 0, lengthOfSharedPortion);
                    return new Extension(sharedNibbles, AbstractPatriciaTrieImpl.this.hasherForNodes.hash((Object)branch), 0).putInStore(cursor);
                }
                return branch;
            }
            catch (IOException e) {
                throw new TrieException((Throwable)e);
            }
        }
    }
}

