/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.patricia.internal;

import io.hotmoka.crypto.api.Hasher;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.Marshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.Unmarshaller;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.patricia.PatriciaTries;
import io.hotmoka.patricia.api.KeyValueStore;
import io.hotmoka.patricia.api.PatriciaTrie;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatriciaTrieImpl<Key, Value extends Marshallable>
implements PatriciaTrie<Key, Value> {
    private final KeyValueStore store;
    private final Hasher<? super Key> hasherForKeys;
    private final Hasher<AbstractNode> hasherForNodes;
    private final Unmarshaller<? extends Value> valueUnmarshaller;
    private final PatriciaTries.UnmarshallingContextSupplier unmarshallingContextSupplier;
    private final long numberOfCommits;
    private static final Logger logger = Logger.getLogger(PatriciaTrieImpl.class.getName());

    public PatriciaTrieImpl(KeyValueStore store, Hasher<? super Key> hasherForKeys, HashingAlgorithm hashingForNodes, Unmarshaller<? extends Value> valueUnmarshaller, PatriciaTries.UnmarshallingContextSupplier unmarshallingContextSupplier, long numberOfCommits) {
        this.store = store;
        this.hasherForKeys = hasherForKeys;
        this.hasherForNodes = hashingForNodes.getHasher(rec$ -> ((AbstractNode)((Object)((Object)rec$))).toByteArray());
        this.valueUnmarshaller = valueUnmarshaller;
        this.unmarshallingContextSupplier = unmarshallingContextSupplier;
        this.numberOfCommits = numberOfCommits;
    }

    public Optional<Value> get(Key key) throws NoSuchElementException {
        byte[] hashOfRoot = this.store.getRoot();
        if (hashOfRoot == null) {
            return Optional.empty();
        }
        try {
            byte[] hashedKey = this.hasherForKeys.hash(key);
            byte[] nibblesOfHashedKey = PatriciaTrieImpl.toNibbles(hashedKey);
            return Optional.of(this.getNodeFromHash(hashOfRoot, 0).get(nibblesOfHashedKey, 0));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "unexpected error while getting key from Patricia trie", e);
            throw new RuntimeException("Unexpected error while getting key from Patricia trie", e);
        }
    }

    public void put(Key key, Value value) {
        try {
            AbstractNode newRoot;
            byte[] hashedKey = this.hasherForKeys.hash(key);
            byte[] nibblesOfHashedKey = PatriciaTrieImpl.toNibbles(hashedKey);
            byte[] hashOfRoot = this.store.getRoot();
            if (hashOfRoot == null) {
                newRoot = new Leaf(nibblesOfHashedKey, value.toByteArray()).putInStore();
            } else {
                newRoot = this.getNodeFromHash(hashOfRoot, 0).put(nibblesOfHashedKey, 0, value);
                this.addGarbageKey(hashOfRoot);
            }
            this.store.setRoot(this.hasherForNodes.hash((Object)newRoot));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "unexpected error while putting key into Patricia trie", e);
            throw new RuntimeException("Unexpected error while putting key into Patricia trie", e);
        }
    }

    public byte[] getRoot() {
        return this.store.getRoot();
    }

    public void garbageCollect(long commitNumber) {
        long numberOfGarbageKeys = this.getNumberOfGarbageKeys(commitNumber);
        if (numberOfGarbageKeys > 0L) {
            for (long num = 0L; num < numberOfGarbageKeys; ++num) {
                this.store.remove(this.getGarbageKey(commitNumber, num));
            }
            this.removeGarbageCollectionData(commitNumber, numberOfGarbageKeys);
        }
    }

    private AbstractNode from(ObjectInputStream ois, int cursor) throws IOException {
        byte kind = ois.readByte();
        if (kind == 0 || (kind & 0xF0) == 16) {
            int nodeHashSize = this.hasherForNodes.length();
            int sharedBytesLength = ois.available() - nodeHashSize + 1;
            byte[] sharedBytes = new byte[sharedBytesLength];
            sharedBytes[0] = kind;
            if (sharedBytesLength - 1 != ois.readNBytes(sharedBytes, 1, sharedBytesLength - 1)) {
                throw new IOException("nibbles length mismatch in an extension node of a Patricia trie");
            }
            byte[] sharedNibbles = PatriciaTrieImpl.expandBytesIntoNibbles(sharedBytes, (byte)0);
            byte[] next = ois.readAllBytes();
            return new Extension(sharedNibbles, next);
        }
        if (kind == 4) {
            short selector = ois.readShort();
            int nodeHashSize = this.hasherForNodes.length();
            byte[][] children = new byte[16][];
            int pos = 0;
            int bit = 32768;
            while (pos < 16) {
                if ((selector & bit) != 0) {
                    children[pos] = new byte[nodeHashSize];
                    if (nodeHashSize != ois.readNBytes(children[pos], 0, nodeHashSize)) {
                        throw new IOException("hash length mismatch in Patricia node");
                    }
                }
                ++pos;
                bit >>= 1;
            }
            return new Branch(children);
        }
        if (kind == 2 || (kind & 0xF0) == 48) {
            int expected = cursor % 2 == 0 ? this.hasherForKeys.length() - cursor / 2 + 1 : this.hasherForKeys.length() - cursor / 2;
            byte[] nibbles = new byte[expected];
            nibbles[0] = kind;
            if (expected - 1 != ois.readNBytes(nibbles, 1, expected - 1)) {
                throw new IOException("keyEnd length mismatch in a leaf node of a Patricia trie");
            }
            byte[] keyEnd = PatriciaTrieImpl.expandBytesIntoNibbles(nibbles, (byte)2);
            byte[] value = ois.readAllBytes();
            return new Leaf(keyEnd, value);
        }
        throw new IOException("unexpected Patricia node kind: " + kind);
    }

    private AbstractNode getNodeFromHash(byte[] hash, int cursor) throws NoSuchElementException, IOException {
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(this.store.get(hash))));){
            AbstractNode abstractNode = this.from(ois, cursor);
            return abstractNode;
        }
    }

    private static byte[] toNibbles(byte[] original) {
        int length = original.length;
        byte[] split = new byte[length * 2];
        int pos = 0;
        for (byte b : original) {
            split[pos++] = (byte)((b & 0xF0) >> 4);
            split[pos++] = (byte)(b & 0xF);
        }
        return split;
    }

    private static byte[] compactNibblesIntoBytes(byte[] nibbles, byte evenSelector, byte oddSelector) {
        int length = nibbles.length;
        byte[] result = new byte[1 + length / 2];
        if (length % 2 == 0) {
            result[0] = evenSelector;
            for (int pos = 0; pos < length; pos += 2) {
                result[1 + pos / 2] = (byte)(nibbles[pos] << 4 | nibbles[pos + 1]);
            }
        } else {
            result[0] = (byte)(oddSelector << 4 | nibbles[0]);
            for (int pos = 1; pos < length; pos += 2) {
                result[1 + pos / 2] = (byte)(nibbles[pos] << 4 | nibbles[pos + 1]);
            }
        }
        return result;
    }

    private static byte[] expandBytesIntoNibbles(byte[] bytes, byte evenSelector) {
        byte[] nibbles;
        if (bytes[0] == evenSelector) {
            nibbles = new byte[(bytes.length - 1) * 2];
            for (int pos = 1; pos < bytes.length; ++pos) {
                nibbles[(pos - 1) * 2] = (byte)((bytes[pos] & 0xF0) >> 4);
                nibbles[pos * 2 - 1] = (byte)(bytes[pos] & 0xF);
            }
        } else {
            nibbles = new byte[bytes.length * 2 - 1];
            nibbles[0] = (byte)(bytes[0] & 0xF);
            for (int pos = 1; pos < bytes.length; ++pos) {
                nibbles[pos * 2 - 1] = (byte)((bytes[pos] & 0xF0) >> 4);
                nibbles[pos * 2] = (byte)(bytes[pos] & 0xF);
            }
        }
        return nibbles;
    }

    private long getNumberOfGarbageKeys(long commitNumber) {
        try {
            return PatriciaTrieImpl.bytesToLong(this.store.get(PatriciaTrieImpl.twoLongsToBytes(commitNumber, 0L)));
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    private void setNumberOfGarbageKeys(long commitNumber, long newNumberOfGarbageKeys) {
        this.store.put(PatriciaTrieImpl.twoLongsToBytes(this.numberOfCommits, 0L), PatriciaTrieImpl.longToBytes(newNumberOfGarbageKeys));
    }

    private byte[] getGarbageKey(long commitNumber, long keyNumber) throws NoSuchElementException {
        return this.store.get(PatriciaTrieImpl.twoLongsToBytes(commitNumber, keyNumber + 1L));
    }

    private void setGarbageKey(long commitNumber, long keyNumber, byte[] key) {
        this.store.put(PatriciaTrieImpl.twoLongsToBytes(commitNumber, keyNumber + 1L), key);
    }

    private void addGarbageKey(byte[] key) {
        long numberOfGarbageKeys = this.getNumberOfGarbageKeys(this.numberOfCommits);
        this.setGarbageKey(this.numberOfCommits, numberOfGarbageKeys, key);
        this.setNumberOfGarbageKeys(this.numberOfCommits, numberOfGarbageKeys + 1L);
    }

    private static byte[] longToBytes(long l) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        buffer.putLong(l);
        return buffer.array();
    }

    private static byte[] twoLongsToBytes(long l1, long l2) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(l1);
        buffer.putLong(l2);
        return buffer.array();
    }

    private void removeGarbageCollectionData(long commitNumber, long numberOfGarbageKeys) {
        for (long num = 0L; num <= numberOfGarbageKeys; ++num) {
            this.store.remove(PatriciaTrieImpl.twoLongsToBytes(commitNumber, num));
        }
    }

    private static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    private abstract class AbstractNode
    extends AbstractMarshallable {
        private AbstractNode() {
        }

        protected abstract Value get(byte[] var1, int var2) throws NoSuchElementException, IOException;

        protected abstract AbstractNode put(byte[] var1, int var2, Value var3) throws IOException;

        protected final AbstractNode putInStore() {
            PatriciaTrieImpl.this.store.put(PatriciaTrieImpl.this.hasherForNodes.hash((Object)this), this.toByteArray());
            return this;
        }
    }

    private class Leaf
    extends AbstractNode {
        private final byte[] keyEnd;
        private final byte[] value;

        private Leaf(byte[] keyEnd, byte[] value) {
            this.keyEnd = keyEnd;
            this.value = value;
        }

        public void into(MarshallingContext context) throws IOException {
            context.write(PatriciaTrieImpl.compactNibblesIntoBytes(this.keyEnd, (byte)2, (byte)3));
            context.write(this.value);
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws NoSuchElementException, IOException {
            int cursor1;
            for (cursor1 = 0; cursor < nibblesOfHashedKey.length && cursor1 < this.keyEnd.length; ++cursor1, ++cursor) {
                if (this.keyEnd[cursor1] == nibblesOfHashedKey[cursor]) continue;
                throw new NoSuchElementException("key not found in Patricia trie");
            }
            if (cursor1 != this.keyEnd.length || cursor != nibblesOfHashedKey.length) {
                throw new RuntimeException("Inconsistent key length in Patricia trie: " + (cursor1 != this.keyEnd.length) + ", " + (cursor != nibblesOfHashedKey.length));
            }
            try (UnmarshallingContext context = PatriciaTrieImpl.this.unmarshallingContextSupplier.get(new ByteArrayInputStream(this.value));){
                Marshallable marshallable = PatriciaTrieImpl.this.valueUnmarshaller.from(context);
                return marshallable;
            }
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws IOException {
            int lengthOfSharedPortion;
            for (lengthOfSharedPortion = 0; lengthOfSharedPortion < this.keyEnd.length && nibblesOfHashedKey[lengthOfSharedPortion + cursor] == this.keyEnd[lengthOfSharedPortion]; ++lengthOfSharedPortion) {
            }
            int lengthOfDistinctPortion = this.keyEnd.length - lengthOfSharedPortion;
            if (lengthOfDistinctPortion == 0) {
                return new Leaf(this.keyEnd, value.toByteArray()).putInStore();
            }
            byte[] keyEnd1 = new byte[this.keyEnd.length - lengthOfSharedPortion - 1];
            System.arraycopy(this.keyEnd, lengthOfSharedPortion + 1, keyEnd1, 0, keyEnd1.length);
            byte[] keyEnd2 = new byte[keyEnd1.length];
            System.arraycopy(nibblesOfHashedKey, lengthOfSharedPortion + cursor + 1, keyEnd2, 0, keyEnd2.length);
            byte selection1 = this.keyEnd[lengthOfSharedPortion];
            byte selection2 = nibblesOfHashedKey[lengthOfSharedPortion + cursor];
            byte[][] children = new byte[16][];
            AbstractNode leaf1 = new Leaf(keyEnd1, this.value).putInStore();
            AbstractNode leaf2 = new Leaf(keyEnd2, value.toByteArray()).putInStore();
            children[selection1] = PatriciaTrieImpl.this.hasherForNodes.hash((Object)leaf1);
            children[selection2] = PatriciaTrieImpl.this.hasherForNodes.hash((Object)leaf2);
            AbstractNode branch = new Branch(children).putInStore();
            if (lengthOfSharedPortion > 0) {
                byte[] sharedNibbles = new byte[lengthOfSharedPortion];
                System.arraycopy(this.keyEnd, 0, sharedNibbles, 0, lengthOfSharedPortion);
                return new Extension(sharedNibbles, PatriciaTrieImpl.this.hasherForNodes.hash((Object)branch)).putInStore();
            }
            return branch;
        }
    }

    private class Extension
    extends AbstractNode {
        private final byte[] sharedNibbles;
        private final byte[] next;

        private Extension(byte[] sharedNibbles, byte[] next) {
            this.sharedNibbles = sharedNibbles;
            this.next = next;
        }

        public void into(MarshallingContext context) throws IOException {
            context.write(PatriciaTrieImpl.compactNibblesIntoBytes(this.sharedNibbles, (byte)0, (byte)1));
            context.write(this.next);
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws NoSuchElementException, IOException {
            int cursor1;
            for (cursor1 = 0; cursor < nibblesOfHashedKey.length && cursor1 < this.sharedNibbles.length; ++cursor1, ++cursor) {
                if (this.sharedNibbles[cursor1] == nibblesOfHashedKey[cursor]) continue;
                throw new NoSuchElementException("key not found in Patricia trie");
            }
            if (cursor1 != this.sharedNibbles.length || cursor >= nibblesOfHashedKey.length) {
                throw new RuntimeException("inconsistent key length in Patricia trie");
            }
            return PatriciaTrieImpl.this.getNodeFromHash(this.next, cursor).get(nibblesOfHashedKey, cursor);
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws IOException {
            int lengthOfSharedPortion;
            for (lengthOfSharedPortion = 0; lengthOfSharedPortion < this.sharedNibbles.length && nibblesOfHashedKey[lengthOfSharedPortion + cursor] == this.sharedNibbles[lengthOfSharedPortion]; ++lengthOfSharedPortion) {
            }
            int lengthOfDistinctPortion = this.sharedNibbles.length - lengthOfSharedPortion;
            if (lengthOfDistinctPortion == 0) {
                AbstractNode newNext = PatriciaTrieImpl.this.getNodeFromHash(this.next, this.sharedNibbles.length + cursor).put(nibblesOfHashedKey, this.sharedNibbles.length + cursor, value);
                PatriciaTrieImpl.this.addGarbageKey(this.next);
                return new Extension(this.sharedNibbles, PatriciaTrieImpl.this.hasherForNodes.hash((Object)newNext)).putInStore();
            }
            byte[] sharedNibbles1 = new byte[this.sharedNibbles.length - lengthOfSharedPortion - 1];
            System.arraycopy(this.sharedNibbles, lengthOfSharedPortion + 1, sharedNibbles1, 0, sharedNibbles1.length);
            byte[] keyEnd2 = new byte[nibblesOfHashedKey.length - cursor - lengthOfSharedPortion - 1];
            System.arraycopy(nibblesOfHashedKey, lengthOfSharedPortion + cursor + 1, keyEnd2, 0, keyEnd2.length);
            byte selection1 = this.sharedNibbles[lengthOfSharedPortion];
            byte selection2 = nibblesOfHashedKey[lengthOfSharedPortion + cursor];
            byte[][] children = new byte[16][];
            byte[] hashOfChild1 = sharedNibbles1.length == 0 ? this.next : PatriciaTrieImpl.this.hasherForNodes.hash((Object)new Extension(sharedNibbles1, this.next).putInStore());
            AbstractNode child2 = new Leaf(keyEnd2, value.toByteArray()).putInStore();
            children[selection1] = hashOfChild1;
            children[selection2] = PatriciaTrieImpl.this.hasherForNodes.hash((Object)child2);
            AbstractNode branch = new Branch(children).putInStore();
            if (lengthOfSharedPortion > 0) {
                byte[] sharedNibbles = new byte[lengthOfSharedPortion];
                System.arraycopy(this.sharedNibbles, 0, sharedNibbles, 0, lengthOfSharedPortion);
                return new Extension(sharedNibbles, PatriciaTrieImpl.this.hasherForNodes.hash((Object)branch)).putInStore();
            }
            return branch;
        }
    }

    private class Branch
    extends AbstractNode {
        private final byte[][] children;

        private Branch(byte[][] children) {
            this.children = children;
        }

        private short selector() {
            short result = 0;
            int pos = 0;
            int bit = 32768;
            while (pos < 16) {
                if (this.children[pos] != null) {
                    result = (short)(result | bit);
                }
                ++pos;
                bit >>= 1;
            }
            return result;
        }

        public void into(MarshallingContext context) throws IOException {
            context.writeByte(4);
            context.writeShort((int)this.selector());
            for (byte[] child : this.children) {
                if (child == null) continue;
                context.write(child);
            }
        }

        @Override
        protected Value get(byte[] nibblesOfHashedKey, int cursor) throws NoSuchElementException, IOException {
            if (cursor >= nibblesOfHashedKey.length) {
                throw new RuntimeException("Inconsistent key length in Patricia trie nibblesOfHashedKey.length = " + nibblesOfHashedKey.length + ", cursor = " + cursor);
            }
            byte selection = nibblesOfHashedKey[cursor];
            if (this.children[selection] == null) {
                throw new NoSuchElementException("Key not found in Patricia trie");
            }
            return PatriciaTrieImpl.this.getNodeFromHash(this.children[selection], cursor + 1).get(nibblesOfHashedKey, cursor + 1);
        }

        @Override
        protected AbstractNode put(byte[] nibblesOfHashedKey, int cursor, Value value) throws IOException {
            AbstractNode child;
            if (cursor >= nibblesOfHashedKey.length) {
                throw new RuntimeException("Inconsistent key length in Patricia trie");
            }
            byte selection = nibblesOfHashedKey[cursor];
            if (this.children[selection] == null) {
                byte[] nibblesButFirst = new byte[nibblesOfHashedKey.length - cursor - 1];
                System.arraycopy(nibblesOfHashedKey, cursor + 1, nibblesButFirst, 0, nibblesButFirst.length);
                child = new Leaf(nibblesButFirst, value.toByteArray()).putInStore();
            } else {
                child = PatriciaTrieImpl.this.getNodeFromHash(this.children[selection], cursor + 1).put(nibblesOfHashedKey, cursor + 1, value);
                PatriciaTrieImpl.this.addGarbageKey(this.children[selection]);
            }
            byte[][] childrenCopy = (byte[][])this.children.clone();
            childrenCopy[selection] = PatriciaTrieImpl.this.hasherForNodes.hash((Object)child);
            return new Branch(childrenCopy).putInStore();
        }
    }
}

