/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.MethodSignatures;
import io.hotmoka.beans.StorageTypes;
import io.hotmoka.beans.TransactionResponses;
import io.hotmoka.beans.api.requests.AbstractInstanceMethodCallTransactionRequest;
import io.hotmoka.beans.api.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.api.signatures.MethodSignature;
import io.hotmoka.beans.api.signatures.NonVoidMethodSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.values.BigIntegerValue;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.beans.api.values.StorageValue;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.MethodCallResponseBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class InstanceMethodCallResponseBuilder
extends MethodCallResponseBuilder<AbstractInstanceMethodCallTransactionRequest> {
    private static final Logger LOGGER = Logger.getLogger(InstanceMethodCallResponseBuilder.class.getName());

    public InstanceMethodCallResponseBuilder(TransactionReference reference, AbstractInstanceMethodCallTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
        try {
            if (this.transactionIsSigned()) {
                this.receiverIsExported();
            }
        }
        catch (Throwable t) {
            throw InstanceMethodCallResponseBuilder.wrapAsTransactionRejectedException(t);
        }
    }

    private void receiverIsExported() throws TransactionRejectedException, ClassNotFoundException {
        this.enforceExported(((AbstractInstanceMethodCallTransactionRequest)this.request).getReceiver());
    }

    public MethodCallTransactionResponse getResponse() throws TransactionRejectedException {
        return (MethodCallTransactionResponse)new ResponseCreator().create();
    }

    @Override
    protected StorageReference getPayerFromRequest() {
        return this.isSelfCharged() ? ((AbstractInstanceMethodCallTransactionRequest)this.request).getReceiver() : ((AbstractInstanceMethodCallTransactionRequest)this.request).getCaller();
    }

    @Override
    protected boolean transactionIsSigned() {
        return super.transactionIsSigned() && !this.isCallToFaucet();
    }

    private boolean callerIsGameteOfTheNode() {
        return this.node.getCaches().getGamete().filter(arg_0 -> ((StorageReference)((AbstractInstanceMethodCallTransactionRequest)this.request).getCaller()).equals(arg_0)).isPresent();
    }

    private boolean isCallToFaucet() {
        return this.consensus.allowsUnsignedFaucet() && ((AbstractInstanceMethodCallTransactionRequest)this.request).getStaticTarget().getMethodName().startsWith("faucet") && ((AbstractInstanceMethodCallTransactionRequest)this.request).getStaticTarget().getDefiningClass().equals((Object)StorageTypes.GAMETE) && ((AbstractInstanceMethodCallTransactionRequest)this.request).getCaller().equals((Object)((AbstractInstanceMethodCallTransactionRequest)this.request).getReceiver()) && this.callerIsGameteOfTheNode();
    }

    private Method getFromContractMethod() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class<Void> clazz;
        MethodSignature method = ((AbstractInstanceMethodCallTransactionRequest)this.request).getStaticTarget();
        if (method instanceof NonVoidMethodSignature) {
            NonVoidMethodSignature nvms = (NonVoidMethodSignature)method;
            clazz = this.storageTypeToClass.toClass(nvms.getReturnType());
        } else {
            clazz = Void.TYPE;
        }
        Class<Void> returnType = clazz;
        Class[] argTypes = this.formalsAsClassForFromContract();
        return (Method)this.classLoader.resolveMethod(method.getDefiningClass().getName(), method.getMethodName(), argTypes, returnType).orElseThrow(() -> new NoSuchMethodException(method.toString()));
    }

    private boolean isSelfCharged() {
        if (this.consensus != null && this.consensus.allowsSelfCharged()) {
            try {
                try {
                    return InstanceMethodCallResponseBuilder.hasAnnotation(this.getMethod(), "io.takamaka.code.lang.SelfCharged");
                }
                catch (NoSuchMethodException e) {
                    return InstanceMethodCallResponseBuilder.hasAnnotation(this.getFromContractMethod(), "io.takamaka.code.lang.SelfCharged");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private class ResponseCreator
    extends MethodCallResponseBuilder.ResponseCreator {
        private Object deserializedReceiver;
        private Object[] deserializedActuals;

        private ResponseCreator() throws TransactionRejectedException {
            super(InstanceMethodCallResponseBuilder.this);
        }

        @Override
        protected Object deserializedPayer() {
            return InstanceMethodCallResponseBuilder.this.isSelfCharged() ? this.deserializer.deserialize((StorageValue)((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).getReceiver()) : this.getDeserializedCaller();
        }

        protected MethodCallTransactionResponse body() {
            try {
                Object result;
                Object[] deserializedActuals;
                Method methodJVM;
                this.init();
                this.deserializedReceiver = this.deserializer.deserialize((StorageValue)((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).getReceiver());
                this.deserializedActuals = ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).actuals().map(this.deserializer::deserialize).toArray(Object[]::new);
                try {
                    methodJVM = InstanceMethodCallResponseBuilder.this.getMethod();
                    deserializedActuals = this.deserializedActuals;
                }
                catch (NoSuchMethodException e) {
                    try {
                        methodJVM = InstanceMethodCallResponseBuilder.this.getFromContractMethod();
                        deserializedActuals = this.addExtraActualsForFromContract();
                    }
                    catch (NoSuchMethodException ee) {
                        throw e;
                    }
                }
                boolean isView = CodeCallResponseBuilder.hasAnnotation(methodJVM, "io.takamaka.code.lang.View");
                this.validateCallee(methodJVM, isView);
                this.ensureWhiteListingOf(methodJVM, deserializedActuals);
                this.mintCoinsForRewardToValidators();
                try {
                    result = methodJVM.invoke(this.deserializedReceiver, deserializedActuals);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.isCheckedForThrowsExceptions(cause, methodJVM)) {
                        this.viewMustBeSatisfied(isView, null);
                        this.chargeGasForStorageOf(TransactionResponses.methodCallException((String)cause.getClass().getName(), (String)cause.getMessage(), (String)InstanceMethodCallResponseBuilder.this.where(cause), (boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                        this.refundPayerForAllRemainingGas();
                        return TransactionResponses.methodCallException((String)cause.getClass().getName(), (String)cause.getMessage(), (String)InstanceMethodCallResponseBuilder.this.where(cause), (boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
                    }
                    throw cause;
                }
                this.viewMustBeSatisfied(isView, result);
                if (methodJVM.getReturnType() == Void.TYPE) {
                    this.chargeGasForStorageOf(TransactionResponses.voidMethodCallSuccessful((boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                    this.refundPayerForAllRemainingGas();
                    return TransactionResponses.voidMethodCallSuccessful((boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
                }
                this.chargeGasForStorageOf(TransactionResponses.methodCallSuccessful((StorageValue)this.serializer.serialize(result), (boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(result), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return TransactionResponses.methodCallSuccessful((StorageValue)this.serializer.serialize(result), (boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updates(result), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "transaction failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return TransactionResponses.methodCallFailed((String)t.getClass().getName(), (String)t.getMessage(), (String)InstanceMethodCallResponseBuilder.this.where(t), (boolean)InstanceMethodCallResponseBuilder.this.isSelfCharged(), this.updatesToBalanceOrNonceOfCaller(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage(), (BigInteger)this.gasConsumedForPenalty());
            }
        }

        private void validateCallee(Method methodJVM, boolean isView) throws NoSuchMethodException {
            if (Modifier.isStatic(methodJVM.getModifiers())) {
                throw new NoSuchMethodException("cannot call a static method");
            }
            if (!isView && InstanceMethodCallResponseBuilder.this.isView()) {
                throw new NoSuchMethodException("cannot call a method not annotated as @View");
            }
        }

        @Override
        protected final Stream<Object> getDeserializedActuals() {
            return Stream.of(this.deserializedActuals);
        }

        @Override
        protected void scanPotentiallyAffectedObjects(Consumer<Object> consumer) {
            super.scanPotentiallyAffectedObjects(consumer);
            consumer.accept(this.deserializedReceiver);
        }

        @Override
        protected void ensureWhiteListingOf(Method executable, Object[] actuals) throws ClassNotFoundException {
            super.ensureWhiteListingOf(executable, actuals);
            Optional model = InstanceMethodCallResponseBuilder.this.classLoader.getWhiteListingWizard().whiteListingModelOf(executable);
            if (model.isPresent() && !Modifier.isStatic(executable.getModifiers())) {
                this.checkWhiteListingProofObligations(((Method)model.get()).getName(), this.deserializedReceiver, ((Method)model.get()).getAnnotations());
            }
        }

        private void mintCoinsForRewardToValidators() {
            StorageValue value;
            Optional firstArg;
            Optional manifest = InstanceMethodCallResponseBuilder.this.node.getStoreUtilities().getManifestUncommitted();
            if (this.isSystemCall() && ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).getStaticTarget().equals((Object)MethodSignatures.VALIDATORS_REWARD) && manifest.isPresent() && ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).getCaller().equals(manifest.get()) && (firstArg = ((AbstractInstanceMethodCallTransactionRequest)InstanceMethodCallResponseBuilder.this.request).actuals().findFirst()).isPresent() && (value = (StorageValue)firstArg.get()) instanceof BigIntegerValue) {
                BigIntegerValue biv = (BigIntegerValue)value;
                Object caller = this.getDeserializedCaller();
                InstanceMethodCallResponseBuilder.this.classLoader.setBalanceOf(caller, InstanceMethodCallResponseBuilder.this.classLoader.getBalanceOf(caller).add(biv.getValue()));
            }
        }

        private Object[] addExtraActualsForFromContract() {
            int al = this.deserializedActuals.length;
            Object[] result = new Object[al + 2];
            System.arraycopy(this.deserializedActuals, 0, result, 0, al);
            result[al] = this.getDeserializedCaller();
            result[al + 1] = null;
            return result;
        }
    }
}

