/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionResponses;
import io.hotmoka.beans.api.requests.ConstructorCallTransactionRequest;
import io.hotmoka.beans.api.responses.ConstructorCallTransactionResponse;
import io.hotmoka.beans.api.signatures.ConstructorSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.node.NonWhiteListedCallException;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ConstructorCallResponseBuilder
extends CodeCallResponseBuilder<ConstructorCallTransactionRequest, ConstructorCallTransactionResponse> {
    private static final Logger LOGGER = Logger.getLogger(ConstructorCallResponseBuilder.class.getName());

    public ConstructorCallResponseBuilder(TransactionReference reference, ConstructorCallTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected final int gasForStoringFailedResponse() {
        BigInteger gas = ((ConstructorCallTransactionRequest)this.request).getGasLimit();
        return TransactionResponses.constructorCallFailed((String)"placeholder for the name of the exception", (String)"placeholder for the message of the exception", (String)"placeholder for where", Stream.empty(), (BigInteger)gas, (BigInteger)gas, (BigInteger)gas, (BigInteger)gas).size();
    }

    public ConstructorCallTransactionResponse getResponse() throws TransactionRejectedException {
        return (ConstructorCallTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends CodeCallResponseBuilder.ResponseCreator {
        private Object[] deserializedActuals;

        private ResponseCreator() throws TransactionRejectedException {
        }

        protected ConstructorCallTransactionResponse body() {
            try {
                Object result;
                Object[] deserializedActuals;
                Constructor<?> constructorJVM;
                this.init();
                this.deserializedActuals = ((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).actuals().map(this.deserializer::deserialize).toArray(Object[]::new);
                try {
                    constructorJVM = this.getConstructor();
                    deserializedActuals = this.deserializedActuals;
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructorJVM = this.getEntryConstructor();
                        deserializedActuals = this.addExtraActualsForFromContract();
                    }
                    catch (NoSuchMethodException ee) {
                        throw e;
                    }
                }
                this.ensureWhiteListingOf(constructorJVM, deserializedActuals);
                try {
                    result = constructorJVM.newInstance(deserializedActuals);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.isCheckedForThrowsExceptions(cause, constructorJVM)) {
                        this.chargeGasForStorageOf(TransactionResponses.constructorCallException((String)cause.getClass().getName(), (String)cause.getMessage(), (String)ConstructorCallResponseBuilder.this.where(cause), this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                        this.refundPayerForAllRemainingGas();
                        return TransactionResponses.constructorCallException((String)cause.getClass().getName(), (String)cause.getMessage(), (String)ConstructorCallResponseBuilder.this.where(cause), this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
                    }
                    throw cause;
                }
                this.chargeGasForStorageOf(TransactionResponses.constructorCallSuccessful((StorageReference)((StorageReference)this.serializer.serialize(result)), this.updates(result), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return TransactionResponses.constructorCallSuccessful((StorageReference)((StorageReference)this.serializer.serialize(result)), this.updates(result), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "constructor call failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return TransactionResponses.constructorCallFailed((String)t.getClass().getName(), (String)t.getMessage(), (String)ConstructorCallResponseBuilder.this.where(t), this.updatesToBalanceOrNonceOfCaller(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage(), (BigInteger)this.gasConsumedForPenalty());
            }
        }

        private Constructor<?> getConstructor() throws ClassNotFoundException, NoSuchMethodException {
            Class[] argTypes = ConstructorCallResponseBuilder.this.formalsAsClass();
            ConstructorSignature constructor = ((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).getStaticTarget();
            return (Constructor)ConstructorCallResponseBuilder.this.classLoader.resolveConstructor(constructor.getDefiningClass().getName(), argTypes).orElseThrow(() -> new NoSuchMethodException(constructor.toString()));
        }

        private Constructor<?> getEntryConstructor() throws ClassNotFoundException, NoSuchMethodException {
            Class[] argTypes = ConstructorCallResponseBuilder.this.formalsAsClassForFromContract();
            ConstructorSignature constructor = ((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).getStaticTarget();
            return (Constructor)ConstructorCallResponseBuilder.this.classLoader.resolveConstructor(constructor.getDefiningClass().getName(), argTypes).orElseThrow(() -> new NoSuchMethodException(constructor.toString()));
        }

        private Object[] addExtraActualsForFromContract() {
            int al = this.deserializedActuals.length;
            Object[] result = new Object[al + 2];
            System.arraycopy(this.deserializedActuals, 0, result, 0, al);
            result[al] = this.getDeserializedCaller();
            result[al + 1] = null;
            return result;
        }

        private void ensureWhiteListingOf(Constructor<?> executable, Object[] actuals) {
            Optional model = ConstructorCallResponseBuilder.this.classLoader.getWhiteListingWizard().whiteListingModelOf(executable);
            if (model.isEmpty()) {
                throw new NonWhiteListedCallException("illegal call to non-white-listed constructor of " + String.valueOf(((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).getStaticTarget().getDefiningClass()));
            }
            Annotation[][] anns = ((Constructor)model.get()).getParameterAnnotations();
            for (int pos = 0; pos < anns.length; ++pos) {
                this.checkWhiteListingProofObligations(((Constructor)model.get()).getName(), actuals[pos], anns[pos]);
            }
        }

        @Override
        protected final Stream<Object> getDeserializedActuals() {
            return Stream.of(this.deserializedActuals);
        }
    }
}

