/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.TransactionResponses;
import io.hotmoka.beans.api.requests.GenericJarStoreTransactionRequest;
import io.hotmoka.beans.api.requests.InitialTransactionRequest;
import io.hotmoka.beans.api.responses.GenericJarStoreTransactionResponse;
import io.hotmoka.beans.api.responses.JarStoreInitialTransactionResponse;
import io.hotmoka.beans.api.responses.JarStoreTransactionFailedResponse;
import io.hotmoka.beans.api.responses.JarStoreTransactionSuccessfulResponse;
import io.hotmoka.beans.api.responses.TransactionResponse;
import io.hotmoka.beans.api.responses.TransactionResponseWithInstrumentedJar;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.verification.TakamakaClassLoaders;
import io.hotmoka.verification.UnsupportedVerificationVersionException;
import io.hotmoka.verification.VerificationException;
import io.hotmoka.verification.VerifiedJars;
import io.hotmoka.verification.api.Error;
import io.hotmoka.verification.api.TakamakaClassLoader;
import io.hotmoka.verification.api.VerifiedJar;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class Reverification {
    protected static final Logger logger = Logger.getLogger(Reverification.class.getName());
    private final ConcurrentMap<TransactionReference, TransactionResponse> reverified = new ConcurrentHashMap<TransactionReference, TransactionResponse>();
    private final NodeInternal node;
    private final ConsensusConfig<?, ?> consensus;

    public Reverification(Stream<TransactionReference> transactions, NodeInternal node, ConsensusConfig<?, ?> consensus) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        this.node = node;
        this.consensus = consensus;
        AtomicInteger counter = new AtomicInteger();
        for (TransactionReference dependency : (TransactionReference[])transactions.toArray(TransactionReference[]::new)) {
            this.reverify(dependency, counter);
        }
    }

    public Optional<TransactionResponse> getReverifiedResponse(TransactionReference transaction) {
        return Optional.ofNullable((TransactionResponse)this.reverified.get(transaction));
    }

    public void replace() {
        this.reverified.forEach((reference, response) -> {
            this.node.getStore().replace(reference, this.node.getRequest((TransactionReference)reference), response);
            logger.info(String.valueOf(reference) + ": updated after reverification");
        });
        this.reverified.clear();
    }

    private List<GenericJarStoreTransactionResponse> reverify(TransactionReference transaction, AtomicInteger counter) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        if (this.consensus != null && (long)counter.incrementAndGet() > this.consensus.getMaxDependencies()) {
            throw new IllegalArgumentException("too many dependencies in classpath: max is " + this.consensus.getMaxDependencies());
        }
        TransactionResponseWithInstrumentedJar response = this.getResponseWithInstrumentedJarAtUncommitted(transaction);
        List<GenericJarStoreTransactionResponse> reverifiedDependencies = this.reverifiedDependenciesOf(response, counter);
        if (this.anyFailed(reverifiedDependencies)) {
            return List.of(this.transformIntoFailed(response, transaction, "the reverification of a dependency failed"));
        }
        if (!this.needsReverification(response)) {
            return this.union(reverifiedDependencies, (GenericJarStoreTransactionResponse)response);
        }
        VerifiedJar vj = this.recomputeVerifiedJarFor(transaction, reverifiedDependencies);
        if (vj.hasErrors()) {
            return List.of(this.transformIntoFailed(response, transaction, ((Error)vj.getFirstError().get()).getMessage()));
        }
        return this.union(reverifiedDependencies, this.updateVersion(response, transaction));
    }

    private VerifiedJar recomputeVerifiedJarFor(TransactionReference transaction, List<GenericJarStoreTransactionResponse> reverifiedDependencies) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        GenericJarStoreTransactionRequest jarStoreRequestOfTransaction = (GenericJarStoreTransactionRequest)this.node.getRequest(transaction);
        byte[] jar = jarStoreRequestOfTransaction.getJar();
        ArrayList<byte[]> jars = new ArrayList<byte[]>();
        jars.add(jar);
        reverifiedDependencies.stream().map(dependency -> (TransactionResponseWithInstrumentedJar)dependency).map(TransactionResponseWithInstrumentedJar::getInstrumentedJar).forEachOrdered(jars::add);
        if (this.consensus != null && jars.stream().mapToLong(bytes -> ((byte[])bytes).length).sum() > this.consensus.getMaxCumulativeSizeOfDependencies()) {
            throw new IllegalArgumentException("too large cumulative size of dependencies in classpath: max is " + this.consensus.getMaxCumulativeSizeOfDependencies() + " bytes");
        }
        TakamakaClassLoader tcl = TakamakaClassLoaders.of(jars.stream(), (long)(this.consensus != null ? this.consensus.getVerificationVersion() : 0L));
        try {
            return VerifiedJars.of((byte[])jar, (TakamakaClassLoader)tcl, (boolean)(jarStoreRequestOfTransaction instanceof InitialTransactionRequest), (this.consensus != null && this.consensus.allowsSelfCharged() ? 1 : 0) != 0, (this.consensus != null && this.consensus.skipsVerification() ? 1 : 0) != 0);
        }
        catch (UnsupportedVerificationVersionException e) {
            throw new io.hotmoka.node.local.api.UnsupportedVerificationVersionException(e.verificationVerification);
        }
    }

    private boolean needsReverification(TransactionResponseWithInstrumentedJar response) {
        return response.getVerificationVersion() != this.consensus.getVerificationVersion();
    }

    private List<GenericJarStoreTransactionResponse> reverifiedDependenciesOf(TransactionResponseWithInstrumentedJar response, AtomicInteger counter) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        ArrayList<GenericJarStoreTransactionResponse> reverifiedDependencies = new ArrayList<GenericJarStoreTransactionResponse>();
        for (TransactionReference dependency : (TransactionReference[])response.getDependencies().toArray(TransactionReference[]::new)) {
            reverifiedDependencies.addAll(this.reverify(dependency, counter));
        }
        return reverifiedDependencies;
    }

    private boolean anyFailed(List<GenericJarStoreTransactionResponse> responses) {
        return responses.stream().anyMatch(response -> response instanceof JarStoreTransactionFailedResponse);
    }

    private List<GenericJarStoreTransactionResponse> union(List<GenericJarStoreTransactionResponse> responses, GenericJarStoreTransactionResponse added) {
        responses.add(added);
        return responses;
    }

    private JarStoreTransactionFailedResponse transformIntoFailed(TransactionResponseWithInstrumentedJar response, TransactionReference transaction, String error) {
        if (response instanceof JarStoreInitialTransactionResponse) {
            throw new RuntimeException("The reverification of the initial jar store transaction " + String.valueOf(transaction) + " failed: its jar cannot be used");
        }
        JarStoreTransactionSuccessfulResponse currentResponseAsNonInitial = (JarStoreTransactionSuccessfulResponse)response;
        JarStoreTransactionFailedResponse replacement = TransactionResponses.jarStoreFailed((String)VerificationException.class.getName(), (String)error, (Stream)currentResponseAsNonInitial.getUpdates(), (BigInteger)currentResponseAsNonInitial.getGasConsumedForCPU(), (BigInteger)currentResponseAsNonInitial.getGasConsumedForRAM(), (BigInteger)currentResponseAsNonInitial.getGasConsumedForStorage(), (BigInteger)BigInteger.ZERO);
        this.reverified.put(transaction, (TransactionResponse)replacement);
        return replacement;
    }

    private GenericJarStoreTransactionResponse updateVersion(TransactionResponseWithInstrumentedJar response, TransactionReference transaction) {
        JarStoreInitialTransactionResponse replacement;
        if (response instanceof JarStoreInitialTransactionResponse) {
            replacement = TransactionResponses.jarStoreInitial((byte[])response.getInstrumentedJar(), (Stream)response.getDependencies(), (long)this.consensus.getVerificationVersion());
        } else {
            JarStoreTransactionSuccessfulResponse currentResponseAsNonInitial = (JarStoreTransactionSuccessfulResponse)response;
            replacement = TransactionResponses.jarStoreSuccessful((byte[])response.getInstrumentedJar(), (Stream)response.getDependencies(), (long)this.consensus.getVerificationVersion(), (Stream)currentResponseAsNonInitial.getUpdates(), (BigInteger)currentResponseAsNonInitial.getGasConsumedForCPU(), (BigInteger)currentResponseAsNonInitial.getGasConsumedForRAM(), (BigInteger)currentResponseAsNonInitial.getGasConsumedForStorage());
        }
        this.reverified.put(transaction, (TransactionResponse)replacement);
        return replacement;
    }

    private TransactionResponseWithInstrumentedJar getResponseWithInstrumentedJarAtUncommitted(TransactionReference reference) throws NoSuchElementException {
        TransactionResponse response = (TransactionResponse)this.node.getCaches().getResponseUncommitted(reference).orElseThrow(() -> new RuntimeException("Unknown transaction reference " + String.valueOf(reference)));
        if (response instanceof TransactionResponseWithInstrumentedJar) {
            TransactionResponseWithInstrumentedJar trwij = (TransactionResponseWithInstrumentedJar)response;
            return trwij;
        }
        throw new NoSuchElementException("The transaction " + String.valueOf(reference) + " did not install a jar in store");
    }
}

