/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.FieldSignatures;
import io.hotmoka.beans.api.requests.NonInitialTransactionRequest;
import io.hotmoka.beans.api.requests.SignedTransactionRequest;
import io.hotmoka.beans.api.responses.NonInitialTransactionResponse;
import io.hotmoka.beans.api.signatures.FieldSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.updates.ClassTag;
import io.hotmoka.beans.api.updates.Update;
import io.hotmoka.beans.api.updates.UpdateOfField;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.beans.api.values.StorageValue;
import io.hotmoka.crypto.SignatureAlgorithms;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.instrumentation.api.GasCostModel;
import io.hotmoka.node.OutOfGasError;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.UnsupportedVerificationVersionException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.AbstractResponseBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class NonInitialResponseBuilderImpl<Request extends NonInitialTransactionRequest<Response>, Response extends NonInitialTransactionResponse>
extends AbstractResponseBuilder<Request, Response> {
    private static final Logger LOGGER = Logger.getLogger(NonInitialResponseBuilderImpl.class.getName());
    protected final GasCostModel gasCostModel;

    protected NonInitialResponseBuilderImpl(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
        try {
            this.gasCostModel = node.getGasCostModel();
            this.callerMustBeExternallyOwnedAccount();
            this.payerMustBeContract();
            this.gasLimitIsInsideBounds();
            this.requestPromisesEnoughGas();
            this.gasPriceIsLargeEnough();
            this.requestMustHaveCorrectChainId();
            this.signatureMustBeValid();
            this.callerAndRequestMustAgreeOnNonce();
            this.payerCanPayForAllPromisedGas();
        }
        catch (Throwable t) {
            throw NonInitialResponseBuilderImpl.wrapAsTransactionRejectedException(t);
        }
    }

    protected boolean transactionIsSigned() {
        return !this.isView() && this.request instanceof SignedTransactionRequest;
    }

    @Override
    protected EngineClassLoader mkClassLoader() throws ClassNotFoundException, UnsupportedVerificationVersionException, IOException {
        return this.node.getCaches().getClassLoader(((NonInitialTransactionRequest)this.request).getClasspath());
    }

    protected BigInteger minimalGasRequiredForTransaction() {
        BigInteger result = this.gasCostModel.cpuBaseTransactionCost();
        result = result.add(BigInteger.valueOf(((NonInitialTransactionRequest)this.request).size()));
        result = result.add(BigInteger.valueOf(this.gasForStoringFailedResponse()));
        result = result.add(this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)this.gasCostModel).cpuCostForLoadingJar(arg_0)).reduce(BigInteger.ZERO, BigInteger::add));
        result = result.add(this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)this.gasCostModel).ramCostForLoadingJar(arg_0)).reduce(BigInteger.ZERO, BigInteger::add));
        return result;
    }

    protected boolean ignoreGasPrice() {
        return this.consensus.ignoresGasPrice();
    }

    protected StorageReference getPayerFromRequest() {
        return ((NonInitialTransactionRequest)this.request).getCaller();
    }

    protected abstract int gasForStoringFailedResponse();

    protected boolean isView() {
        return false;
    }

    private SignatureAlgorithm determineSignatureAlgorithm() throws NoSuchAlgorithmException, ClassNotFoundException {
        ClassTag classTag = this.node.getClassTag(((NonInitialTransactionRequest)this.request).getCaller());
        Class clazz = this.classLoader.loadClass(classTag.getClazz().getName());
        if (this.classLoader.getAccountED25519().isAssignableFrom(clazz)) {
            return SignatureAlgorithms.ed25519();
        }
        if (this.classLoader.getAccountSHA256DSA().isAssignableFrom(clazz)) {
            return SignatureAlgorithms.sha256dsa();
        }
        if (this.classLoader.getAccountQTESLA1().isAssignableFrom(clazz)) {
            return SignatureAlgorithms.qtesla1();
        }
        if (this.classLoader.getAccountQTESLA3().isAssignableFrom(clazz)) {
            return SignatureAlgorithms.qtesla3();
        }
        return this.consensus.getSignature();
    }

    private void callerMustBeExternallyOwnedAccount() throws TransactionRejectedException, ClassNotFoundException {
        ClassTag classTag = this.node.getClassTag(((NonInitialTransactionRequest)this.request).getCaller());
        Class clazz = this.classLoader.loadClass(classTag.getClazz().getName());
        if (!this.classLoader.getExternallyOwnedAccount().isAssignableFrom(clazz)) {
            throw new TransactionRejectedException("the caller of a request must be an externally owned account");
        }
    }

    private void payerMustBeContract() throws TransactionRejectedException, ClassNotFoundException {
        StorageReference payer = this.getPayerFromRequest();
        if (payer.equals((Object)((NonInitialTransactionRequest)this.request).getCaller())) {
            return;
        }
        ClassTag classTag = this.node.getClassTag(payer);
        Class clazz = this.classLoader.loadClass(classTag.getClazz().getName());
        if (!this.classLoader.getContract().isAssignableFrom(clazz)) {
            throw new TransactionRejectedException("the payer of a request must be a contract");
        }
    }

    private void signatureMustBeValid() throws Exception {
        if (this.transactionIsSigned() && this.node.getStoreUtilities().nodeIsInitializedUncommitted() && !this.node.getCaches().signatureIsValid((SignedTransactionRequest)this.request, this.determineSignatureAlgorithm())) {
            throw new TransactionRejectedException("invalid request signature");
        }
    }

    private void requestMustHaveCorrectChainId() throws TransactionRejectedException {
        String chainId;
        String chainIdOfNode;
        if (this.transactionIsSigned() && this.node.getStoreUtilities().nodeIsInitializedUncommitted() && !(chainIdOfNode = this.consensus.getChainId()).equals(chainId = ((SignedTransactionRequest)this.request).getChainId())) {
            throw new TransactionRejectedException("incorrect chain id: the request reports " + chainId + " but the node requires " + chainIdOfNode);
        }
    }

    private void callerAndRequestMustAgreeOnNonce() throws TransactionRejectedException {
        BigInteger expected;
        if (!this.isView() && !(expected = this.node.getStoreUtilities().getNonceUncommitted(((NonInitialTransactionRequest)this.request).getCaller())).equals(((NonInitialTransactionRequest)this.request).getNonce())) {
            throw new TransactionRejectedException("incorrect nonce: the request reports " + String.valueOf(((NonInitialTransactionRequest)this.request).getNonce()) + " but the account " + String.valueOf(((NonInitialTransactionRequest)this.request).getCaller()) + " contains " + String.valueOf(expected));
        }
    }

    private void requestPromisesEnoughGas() throws TransactionRejectedException {
        BigInteger minimum = this.minimalGasRequiredForTransaction();
        if (((NonInitialTransactionRequest)this.request).getGasLimit().compareTo(minimum) < 0) {
            throw new TransactionRejectedException("not enough gas to start the transaction, expected at least " + String.valueOf(minimum) + " units of gas");
        }
    }

    private void gasLimitIsInsideBounds() throws TransactionRejectedException {
        if (((NonInitialTransactionRequest)this.request).getGasLimit().compareTo(BigInteger.ZERO) < 0) {
            throw new TransactionRejectedException("the gas limit cannot be negative");
        }
        BigInteger maxGas = this.isView() ? this.node.getConfig().getMaxGasPerViewTransaction() : this.consensus.getMaxGasPerTransaction();
        if (((NonInitialTransactionRequest)this.request).getGasLimit().compareTo(maxGas) > 0) {
            throw new TransactionRejectedException("the gas limit of the request is larger than the maximum allowed (" + String.valueOf(((NonInitialTransactionRequest)this.request).getGasLimit()) + " > " + String.valueOf(maxGas) + ")");
        }
    }

    private void gasPriceIsLargeEnough() throws TransactionRejectedException {
        if (this.transactionIsSigned() && this.node.getStoreUtilities().nodeIsInitializedUncommitted() && !this.ignoreGasPrice()) {
            BigInteger currentGasPrice = (BigInteger)this.node.getCaches().getGasPrice().get();
            if (((NonInitialTransactionRequest)this.request).getGasPrice().compareTo(currentGasPrice) < 0) {
                throw new TransactionRejectedException("the gas price of the request is smaller than the current gas price (" + String.valueOf(((NonInitialTransactionRequest)this.request).getGasPrice()) + " < " + String.valueOf(currentGasPrice) + ")");
            }
        }
    }

    private void payerCanPayForAllPromisedGas() throws TransactionRejectedException {
        BigInteger cost = this.costOf(((NonInitialTransactionRequest)this.request).getGasLimit());
        BigInteger totalBalance = this.node.getStoreUtilities().getTotalBalanceUncommitted(this.getPayerFromRequest());
        if (totalBalance.subtract(cost).signum() < 0) {
            throw new TransactionRejectedException("the payer has not enough funds to buy " + String.valueOf(((NonInitialTransactionRequest)this.request).getGasLimit()) + " units of gas");
        }
    }

    private BigInteger costOf(BigInteger gas) {
        return gas.multiply(((NonInitialTransactionRequest)this.request).getGasPrice());
    }

    protected abstract class ResponseCreator
    extends AbstractResponseBuilder.ResponseCreator {
        private Object deserializedCaller;
        private Object deserializedPayer;
        private Optional<Object> deserializedValidators;
        private final LinkedList<BigInteger> oldGas;
        private BigInteger gas;
        private BigInteger gasConsumedForCPU;
        private BigInteger gasConsumedForRAM;
        private BigInteger gasConsumedForStorage;
        private BigInteger greenInitiallyPaidForGas;
        private BigInteger greenBalanceOfPayerInCaseOfTransactionException;
        private BigInteger redBalanceOfPayerInCaseOfTransactionException;

        protected ResponseCreator() throws TransactionRejectedException {
            super(NonInitialResponseBuilderImpl.this);
            this.oldGas = new LinkedList();
            this.gasConsumedForCPU = BigInteger.ZERO;
            this.gasConsumedForRAM = BigInteger.ZERO;
            this.gasConsumedForStorage = BigInteger.ZERO;
            try {
                this.gas = ((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).getGasLimit();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "response creation rejected", t);
                throw NonInitialResponseBuilderImpl.wrapAsTransactionRejectedException(t);
            }
        }

        protected final void init() {
            this.deserializedCaller = this.deserializer.deserialize((StorageValue)((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).getCaller());
            this.deserializedPayer = this.deserializedPayer();
            this.deserializedValidators = NonInitialResponseBuilderImpl.this.node.getCaches().getValidators().map(this.deserializer::deserialize);
            this.increaseNonceOfCaller();
            this.chargeGasForCPU(NonInitialResponseBuilderImpl.this.gasCostModel.cpuBaseTransactionCost());
            this.chargeGasForStorage(BigInteger.valueOf(((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).size()));
            this.chargeGasForClassLoader();
            this.greenInitiallyPaidForGas = this.chargePayerForAllGasPromised();
            this.greenBalanceOfPayerInCaseOfTransactionException = NonInitialResponseBuilderImpl.this.classLoader.getBalanceOf(this.deserializedPayer);
            this.redBalanceOfPayerInCaseOfTransactionException = NonInitialResponseBuilderImpl.this.classLoader.getRedBalanceOf(this.deserializedPayer);
        }

        protected Object deserializedPayer() {
            return this.deserializedCaller;
        }

        protected final Object getDeserializedCaller() {
            return this.deserializedCaller;
        }

        protected final Optional<Object> getDeserializedValidators() {
            return this.deserializedValidators;
        }

        protected final BigInteger gasConsumedForCPU() {
            return this.gasConsumedForCPU;
        }

        protected final BigInteger gasConsumedForRAM() {
            return this.gasConsumedForRAM;
        }

        protected final BigInteger gasConsumedForStorage() {
            return this.gasConsumedForStorage;
        }

        protected final BigInteger gasConsumedForPenalty() {
            return ((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).getGasLimit().subtract(this.gasConsumedForCPU).subtract(this.gasConsumedForRAM).subtract(this.gasConsumedForStorage);
        }

        private void charge(BigInteger amount, Consumer<BigInteger> forWhat) {
            if (amount.signum() < 0) {
                throw new IllegalArgumentException("gas cannot increase");
            }
            if (this.gas.signum() < 0) {
                return;
            }
            if (this.gas.compareTo(amount) < 0) {
                throw new OutOfGasError();
            }
            this.gas = this.gas.subtract(amount);
            forWhat.accept(amount);
        }

        private void chargeGasForStorage(BigInteger amount) {
            this.charge(amount, x -> {
                this.gasConsumedForStorage = this.gasConsumedForStorage.add((BigInteger)x);
            });
        }

        protected final void chargeGasForStorageOf(Response response) {
            this.chargeGasForStorage(BigInteger.valueOf(response.size()));
        }

        @Override
        public final void chargeGasForCPU(BigInteger amount) {
            this.charge(amount, x -> {
                this.gasConsumedForCPU = this.gasConsumedForCPU.add((BigInteger)x);
            });
        }

        @Override
        public final void chargeGasForRAM(BigInteger amount) {
            this.charge(amount, x -> {
                this.gasConsumedForRAM = this.gasConsumedForRAM.add((BigInteger)x);
            });
        }

        protected final void chargeGasForClassLoader() {
            NonInitialResponseBuilderImpl.this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)NonInitialResponseBuilderImpl.this.gasCostModel).cpuCostForLoadingJar(arg_0)).forEach(this::chargeGasForCPU);
            NonInitialResponseBuilderImpl.this.classLoader.getLengthsOfJars().mapToObj(arg_0 -> ((GasCostModel)NonInitialResponseBuilderImpl.this.gasCostModel).ramCostForLoadingJar(arg_0)).forEach(this::chargeGasForRAM);
        }

        protected final Stream<Update> updatesToBalanceOrNonceOfCaller() {
            return this.updatesExtractor.extractUpdatesFrom(Stream.of(this.deserializedCaller)).filter(this::isUpdateToBalanceOrNonceOfCaller);
        }

        protected final boolean isUpdateToBalanceOrNonceOfCaller(Update update) {
            if (update instanceof UpdateOfField) {
                UpdateOfField uof = (UpdateOfField)update;
                if (update.getObject().equals((Object)((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).getCaller())) {
                    FieldSignature field = uof.getField();
                    return FieldSignatures.BALANCE_FIELD.equals((Object)field) || FieldSignatures.RED_BALANCE_FIELD.equals((Object)field) || FieldSignatures.EOA_NONCE_FIELD.equals((Object)field);
                }
            }
            return false;
        }

        private BigInteger chargePayerForAllGasPromised() {
            BigInteger cost = NonInitialResponseBuilderImpl.this.costOf(((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).getGasLimit());
            BigInteger greenBalance = NonInitialResponseBuilderImpl.this.classLoader.getBalanceOf(this.deserializedPayer);
            BigInteger redBalance = NonInitialResponseBuilderImpl.this.classLoader.getRedBalanceOf(this.deserializedPayer);
            BigInteger newRedBalance = redBalance.subtract(cost);
            if (newRedBalance.signum() >= 0) {
                NonInitialResponseBuilderImpl.this.classLoader.setRedBalanceOf(this.deserializedPayer, newRedBalance);
                return BigInteger.ZERO;
            }
            NonInitialResponseBuilderImpl.this.classLoader.setRedBalanceOf(this.deserializedPayer, BigInteger.ZERO);
            NonInitialResponseBuilderImpl.this.classLoader.setBalanceOf(this.deserializedPayer, greenBalance.add(newRedBalance));
            return newRedBalance.negate();
        }

        protected final void refundPayerForAllRemainingGas() {
            BigInteger refund = NonInitialResponseBuilderImpl.this.costOf(this.gas);
            BigInteger greenBalance = NonInitialResponseBuilderImpl.this.classLoader.getBalanceOf(this.deserializedPayer);
            if (refund.subtract(this.greenInitiallyPaidForGas).signum() <= 0) {
                NonInitialResponseBuilderImpl.this.classLoader.setBalanceOf(this.deserializedPayer, greenBalance.add(refund));
            } else {
                BigInteger redBalance = NonInitialResponseBuilderImpl.this.classLoader.getRedBalanceOf(this.deserializedPayer);
                NonInitialResponseBuilderImpl.this.classLoader.setBalanceOf(this.deserializedPayer, greenBalance.add(this.greenInitiallyPaidForGas));
                NonInitialResponseBuilderImpl.this.classLoader.setRedBalanceOf(this.deserializedPayer, redBalance.add(refund.subtract(this.greenInitiallyPaidForGas)));
            }
        }

        protected final void resetBalanceOfPayerToInitialValueMinusAllPromisedGas() {
            NonInitialResponseBuilderImpl.this.classLoader.setBalanceOf(this.deserializedPayer, this.greenBalanceOfPayerInCaseOfTransactionException);
            NonInitialResponseBuilderImpl.this.classLoader.setRedBalanceOf(this.deserializedPayer, this.redBalanceOfPayerInCaseOfTransactionException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> T withGas(BigInteger amount, Callable<T> what) throws Exception {
            this.chargeGasForCPU(amount);
            this.oldGas.addFirst(this.gas);
            this.gas = amount;
            try {
                T t = what.call();
                return t;
            }
            finally {
                this.gas = this.gas.add(this.oldGas.removeFirst());
            }
        }

        private void increaseNonceOfCaller() {
            if (!NonInitialResponseBuilderImpl.this.isView()) {
                NonInitialResponseBuilderImpl.this.classLoader.setNonceOf(this.deserializedCaller, ((NonInitialTransactionRequest)NonInitialResponseBuilderImpl.this.request).getNonce().add(BigInteger.ONE));
            }
        }
    }
}

