/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionResponses;
import io.hotmoka.beans.api.requests.JarStoreTransactionRequest;
import io.hotmoka.beans.api.responses.JarStoreTransactionResponse;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.instrumentation.InstrumentedJars;
import io.hotmoka.instrumentation.api.GasCostModel;
import io.hotmoka.instrumentation.api.InstrumentedJar;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.AbstractNonInitialResponseBuilder;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.UnsupportedVerificationVersionException;
import io.hotmoka.node.local.internal.EngineClassLoaderImpl;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.verification.VerifiedJars;
import io.hotmoka.verification.api.TakamakaClassLoader;
import io.hotmoka.verification.api.VerifiedJar;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class JarStoreResponseBuilder
extends AbstractNonInitialResponseBuilder<JarStoreTransactionRequest, JarStoreTransactionResponse> {
    private static final Logger LOGGER = Logger.getLogger(JarStoreResponseBuilder.class.getName());

    public JarStoreResponseBuilder(TransactionReference reference, JarStoreTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected EngineClassLoader mkClassLoader() throws ClassNotFoundException, UnsupportedVerificationVersionException, IOException {
        return new EngineClassLoaderImpl(((JarStoreTransactionRequest)this.request).getJar(), ((JarStoreTransactionRequest)this.request).getDependencies(), this.node, true, this.consensus);
    }

    @Override
    protected BigInteger minimalGasRequiredForTransaction() {
        int jarLength = ((JarStoreTransactionRequest)this.request).getJarLength();
        BigInteger result = super.minimalGasRequiredForTransaction();
        result = result.add(this.gasCostModel.cpuCostForInstallingJar(jarLength));
        result = result.add(this.gasCostModel.ramCostForInstallingJar(jarLength));
        return result;
    }

    @Override
    protected final int gasForStoringFailedResponse() {
        BigInteger gas = ((JarStoreTransactionRequest)this.request).getGasLimit();
        return TransactionResponses.jarStoreFailed((String)"placeholder for the name of the exception", (String)"placeholder for the message of the exception", Stream.empty(), (BigInteger)gas, (BigInteger)gas, (BigInteger)gas, (BigInteger)gas).size();
    }

    public JarStoreTransactionResponse getResponse() throws TransactionRejectedException {
        return (JarStoreTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends AbstractNonInitialResponseBuilder.ResponseCreator {
        private ResponseCreator() throws TransactionRejectedException {
            super(JarStoreResponseBuilder.this);
        }

        protected JarStoreTransactionResponse body() {
            try {
                this.init();
                int jarLength = ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getJarLength();
                this.chargeGasForCPU(JarStoreResponseBuilder.this.gasCostModel.cpuCostForInstallingJar(jarLength));
                this.chargeGasForRAM(JarStoreResponseBuilder.this.gasCostModel.ramCostForInstallingJar(jarLength));
                VerifiedJar verifiedJar = VerifiedJars.of((byte[])((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getJar(), (TakamakaClassLoader)JarStoreResponseBuilder.this.classLoader, (boolean)false, (boolean)JarStoreResponseBuilder.this.consensus.allowsSelfCharged(), (boolean)JarStoreResponseBuilder.this.consensus.skipsVerification());
                InstrumentedJar instrumentedJar = InstrumentedJars.of((VerifiedJar)verifiedJar, (GasCostModel)JarStoreResponseBuilder.this.gasCostModel);
                byte[] instrumentedBytes = instrumentedJar.toBytes();
                this.chargeGasForStorageOf(TransactionResponses.jarStoreSuccessful((byte[])instrumentedBytes, (Stream)((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getDependencies(), (long)JarStoreResponseBuilder.this.consensus.getVerificationVersion(), this.updatesToBalanceOrNonceOfCaller(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return TransactionResponses.jarStoreSuccessful((byte[])instrumentedBytes, (Stream)((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getDependencies(), (long)JarStoreResponseBuilder.this.consensus.getVerificationVersion(), this.updatesToBalanceOrNonceOfCaller(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "jar store failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return TransactionResponses.jarStoreFailed((String)t.getClass().getName(), (String)t.getMessage(), this.updatesToBalanceOrNonceOfCaller(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage(), (BigInteger)this.gasConsumedForPenalty());
            }
        }

        @Override
        public void event(Object event) {
        }
    }
}

