/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.StorageTypes;
import io.hotmoka.beans.api.types.ClassType;
import io.hotmoka.beans.api.types.StorageType;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.internal.transactions.AbstractResponseBuilder;

public class StorageTypeToClass {
    private final EngineClassLoader classLoader;

    public StorageTypeToClass(AbstractResponseBuilder<?, ?> builder) {
        this.classLoader = builder.classLoader;
    }

    public StorageTypeToClass(EngineClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> toClass(StorageType type) throws ClassNotFoundException {
        if (type == StorageTypes.BOOLEAN) {
            return Boolean.TYPE;
        }
        if (type == StorageTypes.BYTE) {
            return Byte.TYPE;
        }
        if (type == StorageTypes.CHAR) {
            return Character.TYPE;
        }
        if (type == StorageTypes.SHORT) {
            return Short.TYPE;
        }
        if (type == StorageTypes.INT) {
            return Integer.TYPE;
        }
        if (type == StorageTypes.LONG) {
            return Long.TYPE;
        }
        if (type == StorageTypes.FLOAT) {
            return Float.TYPE;
        }
        if (type == StorageTypes.DOUBLE) {
            return Double.TYPE;
        }
        if (type instanceof ClassType) {
            ClassType ct = (ClassType)type;
            return this.classLoader.loadClass(ct.getName());
        }
        throw new IllegalArgumentException("Unexpected storage type");
    }
}

