/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.StorageValues;
import io.hotmoka.beans.api.values.StorageValue;
import io.hotmoka.node.local.internal.transactions.AbstractResponseBuilder;
import java.math.BigInteger;

public class Serializer {
    private final AbstractResponseBuilder<?, ?> builder;

    public Serializer(AbstractResponseBuilder<?, ?> builder) {
        this.builder = builder;
    }

    public StorageValue serialize(Object object) throws IllegalArgumentException {
        if (this.isStorage(object)) {
            return this.builder.classLoader.getStorageReferenceOf(object);
        }
        if (object instanceof BigInteger) {
            return StorageValues.bigIntegerOf((BigInteger)((BigInteger)object));
        }
        if (object instanceof Boolean) {
            return StorageValues.booleanOf((boolean)((Boolean)object));
        }
        if (object instanceof Byte) {
            return StorageValues.byteOf((byte)((Byte)object));
        }
        if (object instanceof Character) {
            return StorageValues.charOf((char)((Character)object).charValue());
        }
        if (object instanceof Double) {
            return StorageValues.doubleOf((double)((Double)object));
        }
        if (object instanceof Float) {
            return StorageValues.floatOf((float)((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return StorageValues.intOf((int)((Integer)object));
        }
        if (object instanceof Long) {
            return StorageValues.longOf((long)((Long)object));
        }
        if (object instanceof Short) {
            return StorageValues.shortOf((short)((Short)object));
        }
        if (object instanceof String) {
            return StorageValues.stringOf((String)((String)object));
        }
        if (object instanceof Enum) {
            return StorageValues.enumElementOf((String)object.getClass().getName(), (String)((Enum)object).name());
        }
        if (object == null) {
            return StorageValues.NULL;
        }
        throw new IllegalArgumentException("An object of class " + object.getClass().getName() + " cannot be kept in store since it does not implement io.takamaka.code.lang.Storage");
    }

    private boolean isStorage(Object object) {
        return object != null && this.builder.classLoader.getStorage().isAssignableFrom(object.getClass());
    }
}

