/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import com.moandjiezana.toml.Toml;
import io.hotmoka.node.local.api.LocalNodeConfig;
import io.hotmoka.node.local.api.LocalNodeConfigBuilder;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public abstract class LocalNodeConfigImpl<C extends LocalNodeConfig<C, B>, B extends LocalNodeConfigBuilder<C, B>>
implements LocalNodeConfig<C, B> {
    public final Path dir;
    public final long maxPollingAttempts;
    public final long pollingDelay;
    public final int requestCacheSize;
    public final int responseCacheSize;
    public final BigInteger maxGasPerViewTransaction;

    protected LocalNodeConfigImpl(LocalNodeConfigBuilderImpl<C, B> builder) {
        this.dir = builder.dir;
        this.maxPollingAttempts = builder.maxPollingAttempts;
        this.pollingDelay = builder.pollingDelay;
        this.requestCacheSize = builder.requestCacheSize;
        this.responseCacheSize = builder.responseCacheSize;
        this.maxGasPerViewTransaction = builder.maxGasPerViewTransaction;
    }

    public Path getDir() {
        return this.dir;
    }

    public long getMaxPollingAttempts() {
        return this.maxPollingAttempts;
    }

    public long getPollingDelay() {
        return this.pollingDelay;
    }

    public int getRequestCacheSize() {
        return this.requestCacheSize;
    }

    public int getResponseCacheSize() {
        return this.responseCacheSize;
    }

    public BigInteger getMaxGasPerViewTransaction() {
        return this.maxGasPerViewTransaction;
    }

    public String toToml() {
        StringBuilder sb = new StringBuilder();
        sb.append("# This is a TOML config file for a local Hotmoka node.\n");
        sb.append("# For more information about TOML, see https://github.com/toml-lang/toml\n");
        sb.append("# For more information about Hotmoka, see https://www.hotmoka.io\n");
        sb.append("\n");
        sb.append("# the directory where the node's data will be persisted\n");
        sb.append("dir = \"" + String.valueOf(this.dir) + "\"\n");
        sb.append("\n");
        sb.append("# the maximal number of polling attempts, while waiting for the result of a posted transaction\n");
        sb.append("max_polling_attempts = " + this.maxPollingAttempts + "\n");
        sb.append("\n");
        sb.append("# the delay of two subsequent polling attempts, in milliseconds,\n");
        sb.append("# while waiting for the result of a posted transaction;\n");
        sb.append("# this delay is then increased by 10% at each subsequent attempt\n");
        sb.append("polling_delay = " + this.pollingDelay + "\n");
        sb.append("\n");
        sb.append("# the size of the cache for getRequest() method of the node\n");
        sb.append("request_cache_size = " + this.requestCacheSize + "\n");
        sb.append("\n");
        sb.append("# the size of the cache for getResponse() method of the node\n");
        sb.append("response_cache_size = " + this.responseCacheSize + "\n");
        sb.append("\n");
        sb.append("# the maximal amount of gas that a view transaction can consume\n");
        sb.append("max_gas_per_view_transaction = \"" + String.valueOf(this.maxGasPerViewTransaction) + "\"\n");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof LocalNodeConfigImpl) {
            LocalNodeConfigImpl otherConfig = (LocalNodeConfigImpl)other;
            if (this.getClass() == other.getClass()) {
                return this.dir.equals(otherConfig.dir) && this.maxPollingAttempts == otherConfig.maxPollingAttempts && this.pollingDelay == otherConfig.pollingDelay && this.requestCacheSize == otherConfig.requestCacheSize && this.responseCacheSize == otherConfig.responseCacheSize && this.maxGasPerViewTransaction.equals(otherConfig.maxGasPerViewTransaction);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.dir.hashCode() ^ Long.hashCode(this.maxPollingAttempts) ^ this.maxGasPerViewTransaction.hashCode();
    }

    public String toString() {
        return this.toToml();
    }

    protected static abstract class LocalNodeConfigBuilderImpl<C extends LocalNodeConfig<C, B>, B extends LocalNodeConfigBuilder<C, B>>
    implements LocalNodeConfigBuilder<C, B> {
        private Path dir = Paths.get("chain", new String[0]);
        private long maxPollingAttempts = 60L;
        private long pollingDelay = 10L;
        private int requestCacheSize = 1000;
        private int responseCacheSize = 1000;
        private BigInteger maxGasPerViewTransaction = BigInteger.valueOf(100000000L);

        protected LocalNodeConfigBuilderImpl() {
        }

        protected LocalNodeConfigBuilderImpl(LocalNodeConfig<C, B> config) {
            this.setDir(config.getDir());
            this.setMaxPollingAttempts(config.getMaxPollingAttempts());
            this.setPollingDelay(config.getPollingDelay());
            this.setRequestCacheSize(config.getRequestCacheSize());
            this.setResponseCacheSize(config.getResponseCacheSize());
            this.setMaxGasPerViewTransaction(config.getMaxGasPerViewTransaction());
        }

        protected LocalNodeConfigBuilderImpl(Toml toml) {
            Long responseCacheSize;
            Long requestCacheSize;
            Long pollingDelay;
            Long maxPollingAttempts;
            String dir = toml.getString("dir");
            if (dir != null) {
                this.setDir(Paths.get(dir, new String[0]));
            }
            if ((maxPollingAttempts = toml.getLong("max_polling_attempts")) != null) {
                this.setMaxPollingAttempts(maxPollingAttempts);
            }
            if ((pollingDelay = toml.getLong("polling_delay")) != null) {
                this.setPollingDelay(pollingDelay);
            }
            if ((requestCacheSize = toml.getLong("request_cache_size")) != null) {
                if (requestCacheSize < 0L || requestCacheSize > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("requestCacheSize must be non-negative and no larger than 2147483647");
                }
                this.setRequestCacheSize((int)requestCacheSize.longValue());
            }
            if ((responseCacheSize = toml.getLong("response_cache_size")) < 0L || responseCacheSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("responseCacheSize must be non-negative and no larger than 2147483647");
            }
            this.setResponseCacheSize((int)responseCacheSize.longValue());
            String maxGasPerViewTransaction = toml.getString("max_gas_per_view_transaction");
            if (maxGasPerViewTransaction != null) {
                this.setMaxGasPerViewTransaction(new BigInteger(maxGasPerViewTransaction));
            }
        }

        public B setMaxGasPerViewTransaction(BigInteger maxGasPerViewTransaction) {
            Objects.requireNonNull(maxGasPerViewTransaction, "maxGasPerViewTransaction cannot be null");
            if (maxGasPerViewTransaction.signum() < 0) {
                throw new IllegalArgumentException("maxGasPerViewTransaction must be non-negative");
            }
            this.maxGasPerViewTransaction = maxGasPerViewTransaction;
            return this.getThis();
        }

        public B setDir(Path dir) {
            Objects.requireNonNull(dir, "dir cannot be null");
            this.dir = dir;
            return this.getThis();
        }

        public B setMaxPollingAttempts(long maxPollingAttempts) {
            if (maxPollingAttempts <= 0L) {
                throw new IllegalArgumentException("maxPollingAttempts must be positive");
            }
            this.maxPollingAttempts = maxPollingAttempts;
            return this.getThis();
        }

        public B setPollingDelay(long pollingDelay) {
            if (pollingDelay < 0L) {
                throw new IllegalArgumentException("pollingDelay must non-negative");
            }
            this.pollingDelay = pollingDelay;
            return this.getThis();
        }

        public B setRequestCacheSize(int requestCacheSize) {
            if (requestCacheSize < 0) {
                throw new IllegalArgumentException("requestCacheSize must non-negative");
            }
            this.requestCacheSize = requestCacheSize;
            return this.getThis();
        }

        public B setResponseCacheSize(int responseCacheSize) {
            if (responseCacheSize < 0) {
                throw new IllegalArgumentException("responseCacheSize must non-negative");
            }
            this.responseCacheSize = responseCacheSize;
            return this.getThis();
        }

        protected abstract B getThis();

        protected static Toml readToml(Path path) throws FileNotFoundException {
            try {
                return new Toml().read(path.toFile());
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    throw (FileNotFoundException)cause;
                }
                throw e;
            }
        }
    }
}

