/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.MethodSignatures;
import io.hotmoka.beans.StorageValues;
import io.hotmoka.beans.TransactionReferences;
import io.hotmoka.beans.TransactionRequests;
import io.hotmoka.beans.api.requests.AbstractInstanceMethodCallTransactionRequest;
import io.hotmoka.beans.api.requests.ConstructorCallTransactionRequest;
import io.hotmoka.beans.api.requests.GameteCreationTransactionRequest;
import io.hotmoka.beans.api.requests.InitializationTransactionRequest;
import io.hotmoka.beans.api.requests.InstanceMethodCallTransactionRequest;
import io.hotmoka.beans.api.requests.InstanceSystemMethodCallTransactionRequest;
import io.hotmoka.beans.api.requests.JarStoreInitialTransactionRequest;
import io.hotmoka.beans.api.requests.JarStoreTransactionRequest;
import io.hotmoka.beans.api.requests.NonInitialTransactionRequest;
import io.hotmoka.beans.api.requests.StaticMethodCallTransactionRequest;
import io.hotmoka.beans.api.requests.SystemTransactionRequest;
import io.hotmoka.beans.api.requests.TransactionRequest;
import io.hotmoka.beans.api.responses.FailedTransactionResponse;
import io.hotmoka.beans.api.responses.GameteCreationTransactionResponse;
import io.hotmoka.beans.api.responses.MethodCallTransactionFailedResponse;
import io.hotmoka.beans.api.responses.NonInitialTransactionResponse;
import io.hotmoka.beans.api.responses.TransactionResponse;
import io.hotmoka.beans.api.responses.TransactionResponseWithEvents;
import io.hotmoka.beans.api.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.api.signatures.MethodSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.updates.ClassTag;
import io.hotmoka.beans.api.updates.Update;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.beans.api.values.StorageValue;
import io.hotmoka.crypto.HashingAlgorithms;
import io.hotmoka.crypto.api.Hasher;
import io.hotmoka.instrumentation.GasCostModels;
import io.hotmoka.instrumentation.api.GasCostModel;
import io.hotmoka.marshalling.api.Marshallable;
import io.hotmoka.node.AbstractNode;
import io.hotmoka.node.api.CodeExecutionException;
import io.hotmoka.node.api.CodeSupplier;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.api.JarSupplier;
import io.hotmoka.node.api.TransactionException;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.LocalNodeConfig;
import io.hotmoka.node.local.api.NodeCache;
import io.hotmoka.node.local.api.ResponseBuilder;
import io.hotmoka.node.local.api.StoreUtility;
import io.hotmoka.node.local.internal.LRUCache;
import io.hotmoka.node.local.internal.NodeCachesImpl;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.StoreUtilityImpl;
import io.hotmoka.node.local.internal.transactions.ConstructorCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.GameteCreationResponseBuilder;
import io.hotmoka.node.local.internal.transactions.InitializationResponseBuilder;
import io.hotmoka.node.local.internal.transactions.InstanceMethodCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.InstanceViewMethodCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.JarStoreInitialResponseBuilder;
import io.hotmoka.node.local.internal.transactions.JarStoreResponseBuilder;
import io.hotmoka.node.local.internal.transactions.StaticMethodCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.StaticViewMethodCallResponseBuilder;
import io.hotmoka.stores.AbstractStore;
import io.hotmoka.stores.Store;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class AbstractLocalNodeImpl<C extends LocalNodeConfig<?, ?>, S extends AbstractStore>
extends AbstractNode {
    private static final Logger LOGGER = Logger.getLogger(AbstractLocalNodeImpl.class.getName());
    protected final C config;
    private final Hasher<TransactionRequest<?>> hasher;
    protected final StoreUtility storeUtilities;
    protected final NodeCache caches;
    protected final S store;
    private final GasCostModel gasCostModel = GasCostModels.standard();
    private final ConcurrentMap<TransactionReference, Semaphore> semaphores;
    private final ExecutorService executor;
    private final AtomicLong checkTime;
    private final AtomicLong deliverTime;
    private final LRUCache<TransactionReference, String> recentCheckTransactionErrors;
    private final AtomicBoolean closed;
    private volatile BigInteger gasConsumedSinceLastReward;
    private volatile BigInteger coinsSinceLastReward;
    private volatile BigInteger coinsSinceLastRewardWithoutInflation;
    private volatile BigInteger numberOfTransactionsSinceLastReward;
    final NodeInternal internal = new NodeInternalImpl();
    private static final BigInteger GAS_FOR_REWARD = BigInteger.valueOf(100000L);
    private static final BigInteger _100_000_000 = BigInteger.valueOf(100000000L);
    private final Object deliverTransactionLock = new Object();

    protected AbstractLocalNodeImpl(C config, ConsensusConfig<?, ?> consensus) {
        this(config, consensus, true);
    }

    protected AbstractLocalNodeImpl(C config) {
        this(config, null, false);
    }

    private AbstractLocalNodeImpl(C config, ConsensusConfig<?, ?> consensus, boolean deleteDir) {
        this.config = config;
        try {
            this.hasher = HashingAlgorithms.sha256().getHasher(Marshallable::toByteArray);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        this.storeUtilities = new StoreUtilityImpl(this.internal);
        this.caches = new NodeCachesImpl(this.internal, consensus);
        this.recentCheckTransactionErrors = new LRUCache(100, 1000);
        this.gasConsumedSinceLastReward = BigInteger.ZERO;
        this.coinsSinceLastReward = BigInteger.ZERO;
        this.coinsSinceLastRewardWithoutInflation = BigInteger.ZERO;
        this.numberOfTransactionsSinceLastReward = BigInteger.ZERO;
        this.executor = Executors.newCachedThreadPool();
        this.semaphores = new ConcurrentHashMap<TransactionReference, Semaphore>();
        this.checkTime = new AtomicLong();
        this.deliverTime = new AtomicLong();
        this.closed = new AtomicBoolean();
        if (deleteDir) {
            try {
                AbstractLocalNodeImpl.deleteRecursively(config.getDir());
                Files.createDirectories(config.getDir(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.store = this.mkStore();
        this.addShutdownHook();
    }

    protected abstract S mkStore();

    protected abstract long getNow();

    protected final boolean isNotYetClosed() {
        return !this.closed.getAndSet(true);
    }

    public void close() throws Exception {
        S store = this.store;
        if (store != null) {
            store.close();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        LOGGER.info("time spent checking requests: " + String.valueOf(this.checkTime) + "ms");
        LOGGER.info("time spent delivering requests: " + String.valueOf(this.deliverTime) + "ms");
    }

    public final String getNameOfSignatureAlgorithmForRequests() {
        return this.caches.getConsensusParams().getSignature().getName();
    }

    public final TransactionReference getTakamakaCode() throws NoSuchElementException {
        return this.getClassTag(this.getManifest()).getJar();
    }

    public final StorageReference getManifest() throws NoSuchElementException {
        return (StorageReference)this.store.getManifest().orElseThrow(() -> new NoSuchElementException("no manifest set for this node"));
    }

    public final TransactionResponse getPolledResponse(TransactionReference reference) throws TransactionRejectedException, TimeoutException, InterruptedException {
        try {
            Objects.requireNonNull(reference);
            Semaphore semaphore = (Semaphore)this.semaphores.get(reference);
            if (semaphore != null) {
                semaphore.acquire();
            }
            long delay = this.config.getPollingDelay();
            for (long attempt = 1L; attempt <= Math.max(1L, this.config.getMaxPollingAttempts()); ++attempt) {
                try {
                    TransactionResponse response = this.getResponse(reference);
                    this.getRequest(reference);
                    return response;
                }
                catch (NoSuchElementException e) {
                    Thread.sleep(delay);
                    delay = delay * 110L / 100L;
                    continue;
                }
            }
            throw new TimeoutException("cannot find the response of transaction reference " + String.valueOf(reference) + ": tried " + this.config.getMaxPollingAttempts() + " times");
        }
        catch (TransactionRejectedException | InterruptedException | TimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "unexpected exception", e);
            throw e;
        }
    }

    public final TransactionRequest<?> getRequest(TransactionReference reference) throws NoSuchElementException {
        Optional request;
        Objects.requireNonNull(reference);
        try {
            request = this.caches.getRequest(reference);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "unexpected exception", e);
            throw e;
        }
        return (TransactionRequest)request.orElseThrow(() -> new NoSuchElementException("unknown transaction reference " + String.valueOf(reference)));
    }

    public final TransactionResponse getResponse(TransactionReference reference) throws TransactionRejectedException, NoSuchElementException {
        String error;
        Objects.requireNonNull(reference);
        try {
            Optional response = this.caches.getResponse(reference);
            if (response.isPresent()) {
                return (TransactionResponse)response.get();
            }
            error = this.store.getError(reference).orElseGet(() -> this.recentCheckTransactionErrors.get(reference));
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Unexpected exception", e);
            throw e;
        }
        if (error != null) {
            throw new TransactionRejectedException(error);
        }
        throw new NoSuchElementException("unknown transaction reference " + String.valueOf(reference));
    }

    public final ClassTag getClassTag(StorageReference reference) throws NoSuchElementException {
        Objects.requireNonNull(reference);
        try {
            if (this.isNotCommitted(reference.getTransaction())) {
                throw new NoSuchElementException("Unknown transaction reference " + String.valueOf(reference.getTransaction()));
            }
            return this.storeUtilities.getClassTagUncommitted(reference);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "unexpected exception", e);
            throw e;
        }
    }

    public final Stream<Update> getState(StorageReference reference) throws NoSuchElementException {
        Objects.requireNonNull(reference);
        try {
            if (this.isNotCommitted(reference.getTransaction())) {
                throw new NoSuchElementException("Unknown transaction reference " + String.valueOf(reference.getTransaction()));
            }
            return this.storeUtilities.getStateCommitted(reference);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Unexpected exception", e);
            throw e;
        }
    }

    public final TransactionReference addJarStoreInitialTransaction(JarStoreInitialTransactionRequest request) throws TransactionRejectedException {
        return (TransactionReference)AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> {
            TransactionReference reference = this.post((TransactionRequest<?>)request);
            this.getPolledResponse(reference);
            return reference;
        });
    }

    public void addInitializationTransaction(InitializationTransactionRequest request) throws TransactionRejectedException {
        AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> this.getPolledResponse(this.post((TransactionRequest<?>)request)));
    }

    public final StorageReference addGameteCreationTransaction(GameteCreationTransactionRequest request) throws TransactionRejectedException {
        return (StorageReference)AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> ((GameteCreationTransactionResponse)this.getPolledResponse(this.post((TransactionRequest<?>)request))).getGamete());
    }

    public final TransactionReference addJarStoreTransaction(JarStoreTransactionRequest request) throws TransactionRejectedException, TransactionException {
        return (TransactionReference)AbstractLocalNodeImpl.wrapInCaseOfExceptionMedium(() -> this.postJarStoreTransaction(request).get());
    }

    public final StorageReference addConstructorCallTransaction(ConstructorCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageReference)AbstractLocalNodeImpl.wrapInCaseOfExceptionFull(() -> (StorageReference)this.postConstructorCallTransaction(request).get());
    }

    public final StorageValue addInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNodeImpl.wrapInCaseOfExceptionFull(() -> this.postInstanceMethodCallTransaction(request).get());
    }

    public final StorageValue addStaticMethodCallTransaction(StaticMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNodeImpl.wrapInCaseOfExceptionFull(() -> this.postStaticMethodCallTransaction(request).get());
    }

    public final StorageValue runInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNodeImpl.wrapInCaseOfExceptionFull(() -> {
            StorageValue result;
            TransactionReference reference = TransactionReferences.of((byte[])this.hasher.hash((Object)request));
            LOGGER.info(String.valueOf(reference) + ": running start (" + request.getClass().getSimpleName() + " -> " + request.getStaticTarget().getMethodName() + ")");
            Object object = this.deliverTransactionLock;
            synchronized (object) {
                result = this.getOutcome(new InstanceViewMethodCallResponseBuilder(reference, request, this.internal).getResponse());
            }
            LOGGER.info(String.valueOf(reference) + ": running success");
            return result;
        });
    }

    public final StorageValue runStaticMethodCallTransaction(StaticMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        return (StorageValue)AbstractLocalNodeImpl.wrapInCaseOfExceptionFull(() -> {
            StorageValue result;
            TransactionReference reference = TransactionReferences.of((byte[])this.hasher.hash((Object)request));
            LOGGER.info(String.valueOf(reference) + ": running start (" + request.getClass().getSimpleName() + " -> " + request.getStaticTarget().getMethodName() + ")");
            Object object = this.deliverTransactionLock;
            synchronized (object) {
                result = this.getOutcome(new StaticViewMethodCallResponseBuilder(reference, request, this.internal).getResponse());
            }
            LOGGER.info(String.valueOf(reference) + ": running success");
            return result;
        });
    }

    public final JarSupplier postJarStoreTransaction(JarStoreTransactionRequest request) throws TransactionRejectedException {
        return (JarSupplier)AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> this.jarSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    public final CodeSupplier<StorageReference> postConstructorCallTransaction(ConstructorCallTransactionRequest request) throws TransactionRejectedException {
        return (CodeSupplier)AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> this.constructorSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    public final CodeSupplier<StorageValue> postInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException {
        return (CodeSupplier)AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> this.methodSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    public final CodeSupplier<StorageValue> postStaticMethodCallTransaction(StaticMethodCallTransactionRequest request) throws TransactionRejectedException {
        return (CodeSupplier)AbstractLocalNodeImpl.wrapInCaseOfExceptionSimple(() -> this.methodSupplierFor(this.post((TransactionRequest<?>)request)));
    }

    protected final void checkTransaction(TransactionRequest<?> request) throws TransactionRejectedException {
        long start = System.currentTimeMillis();
        TransactionReference reference = TransactionReferences.of((byte[])this.hasher.hash(request));
        this.recentCheckTransactionErrors.put(reference, null);
        try {
            LOGGER.info(String.valueOf(reference) + ": checking start (" + request.getClass().getSimpleName() + ")");
            this.responseBuilderFor(reference, request);
            LOGGER.info(String.valueOf(reference) + ": checking success");
        }
        catch (TransactionRejectedException e) {
            this.signalSemaphore(reference);
            this.recentCheckTransactionErrors.put(reference, this.trimmedMessage(e));
            LOGGER.info(String.valueOf(reference) + ": checking failed: " + this.trimmedMessage(e));
            LOGGER.log(Level.INFO, "transaction rejected", e);
            throw e;
        }
        catch (RuntimeException e) {
            this.signalSemaphore(reference);
            this.recentCheckTransactionErrors.put(reference, this.trimmedMessage(e));
            LOGGER.log(Level.WARNING, String.valueOf(reference) + ": checking failed with unexpected exception", e);
            throw e;
        }
        finally {
            this.checkTime.addAndGet(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TransactionResponse deliverTransaction(TransactionRequest<?> request) throws TransactionRejectedException {
        long start = System.currentTimeMillis();
        TransactionReference reference = TransactionReferences.of((byte[])this.hasher.hash(request));
        try {
            TransactionResponse response;
            LOGGER.info(String.valueOf(reference) + ": delivering start (" + request.getClass().getSimpleName() + ")");
            Object object = this.deliverTransactionLock;
            synchronized (object) {
                ResponseBuilder<?, ?> responseBuilder = this.responseBuilderFor(reference, request);
                response = responseBuilder.getResponse();
                this.store.push(reference, request, response);
                responseBuilder.replaceReverifiedResponses();
                this.scheduleForNotificationOfEvents(response);
                this.takeNoteForNextReward(request, response);
                this.invalidateCachesIfNeeded(response, responseBuilder.getClassLoader());
            }
            LOGGER.info(String.valueOf(reference) + ": delivering success");
            object = response;
            return object;
        }
        catch (TransactionRejectedException e) {
            this.store.push(reference, request, this.trimmedMessage(e));
            LOGGER.info(String.valueOf(reference) + ": delivering failed: " + this.trimmedMessage(e));
            LOGGER.log(Level.INFO, "transaction rejected", e);
            throw e;
        }
        catch (IOException | ClassNotFoundException e) {
            this.store.push(reference, request, this.trimmedMessage(e));
            LOGGER.log(Level.SEVERE, String.valueOf(reference) + ": delivering failed with unexpected exception", e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.store.push(reference, request, this.trimmedMessage(e));
            LOGGER.log(Level.WARNING, String.valueOf(reference) + ": delivering failed with unexpected exception", e);
            throw e;
        }
        finally {
            this.signalSemaphore(reference);
            this.deliverTime.addAndGet(System.currentTimeMillis() - start);
        }
    }

    protected final boolean rewardValidators(String behaving, String misbehaving) {
        block9: {
            if (this.caches.getConsensusParams() == null) {
                return false;
            }
            try {
                BigInteger extra;
                BigInteger finalSupply;
                Optional manifest = this.store.getManifestUncommitted();
                if (!manifest.isPresent()) break block9;
                StorageReference caller = (StorageReference)manifest.get();
                BigInteger nonce = this.storeUtilities.getNonceUncommitted(caller);
                StorageReference validators = (StorageReference)this.caches.getValidators().get();
                TransactionReference takamakaCode = this.getTakamakaCode();
                BigInteger minted = this.coinsSinceLastReward.subtract(this.coinsSinceLastRewardWithoutInflation);
                BigInteger currentSupply = this.storeUtilities.getCurrentSupplyUncommitted(validators);
                if (minted.signum() > 0) {
                    finalSupply = this.caches.getConsensusParams().getFinalSupply();
                    extra = finalSupply.subtract(currentSupply.add(minted));
                    if (extra.signum() < 0) {
                        minted = minted.add(extra);
                    }
                } else if (minted.signum() < 0 && (extra = (finalSupply = this.caches.getConsensusParams().getFinalSupply()).subtract(currentSupply.add(minted))).signum() > 0) {
                    minted = minted.add(extra);
                }
                InstanceSystemMethodCallTransactionRequest request = TransactionRequests.instanceSystemMethodCall((StorageReference)caller, (BigInteger)nonce, (BigInteger)GAS_FOR_REWARD, (TransactionReference)takamakaCode, (MethodSignature)MethodSignatures.VALIDATORS_REWARD, (StorageReference)validators, (StorageValue[])new StorageValue[]{StorageValues.bigIntegerOf((BigInteger)this.coinsSinceLastReward), StorageValues.bigIntegerOf((BigInteger)minted), StorageValues.stringOf((String)behaving), StorageValues.stringOf((String)misbehaving), StorageValues.bigIntegerOf((BigInteger)this.gasConsumedSinceLastReward), StorageValues.bigIntegerOf((BigInteger)this.numberOfTransactionsSinceLastReward)});
                this.checkTransaction((TransactionRequest<?>)request);
                ResponseBuilder<?, ?> responseBuilder = this.responseBuilderFor(TransactionReferences.of((byte[])this.hasher.hash((Object)request)), (TransactionRequest<?>)request);
                TransactionResponse response = responseBuilder.getResponse();
                if (!(response instanceof TransactionResponseWithUpdates) || ((TransactionResponseWithUpdates)response).getUpdates().count() > 1L) {
                    response = this.deliverTransaction((TransactionRequest<?>)request);
                }
                if (response instanceof MethodCallTransactionFailedResponse) {
                    MethodCallTransactionFailedResponse responseAsFailed = (MethodCallTransactionFailedResponse)response;
                    LOGGER.log(Level.WARNING, "could not reward the validators: " + responseAsFailed.getWhere() + ": " + responseAsFailed.getClassNameOfCause() + ": " + responseAsFailed.getMessageOfCause());
                    break block9;
                }
                LOGGER.info("units of gas consumed for CPU, RAM or storage since the previous reward: " + String.valueOf(this.gasConsumedSinceLastReward));
                LOGGER.info("units of coin rewarded to the validators for their work since the previous reward: " + String.valueOf(this.coinsSinceLastReward));
                LOGGER.info("units of coin minted since the previous reward: " + String.valueOf(minted));
                this.gasConsumedSinceLastReward = BigInteger.ZERO;
                this.coinsSinceLastReward = BigInteger.ZERO;
                this.coinsSinceLastRewardWithoutInflation = BigInteger.ZERO;
                this.numberOfTransactionsSinceLastReward = BigInteger.ZERO;
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "could not reward the validators", e);
            }
        }
        return false;
    }

    protected final String trimmedMessage(Throwable t) {
        long maxErrorLength;
        String message = t.getMessage();
        int length = message.length();
        if ((long)length > (maxErrorLength = this.caches.getConsensusParams().getMaxErrorLength())) {
            return message.substring(0, (int)maxErrorLength) + "...";
        }
        return message;
    }

    protected final void notifyEventsOf(TransactionResponseWithEvents response) {
        try {
            response.getEvents().forEachOrdered(event -> this.notifyEvent(this.storeUtilities.getCreatorUncommitted(event), (StorageReference)event));
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "unexpected exception", e);
            throw e;
        }
    }

    protected final TransactionReference post(TransactionRequest<?> request) throws TransactionRejectedException {
        TransactionReference reference = TransactionReferences.of((byte[])this.hasher.hash(request));
        LOGGER.info(String.valueOf(reference) + ": posting (" + request.getClass().getSimpleName() + ")");
        if (this.caches.getResponseUncommitted(reference).isPresent()) {
            throw new TransactionRejectedException("repeated request");
        }
        this.createSemaphore(reference);
        this.postRequest(request);
        return reference;
    }

    protected void invalidateCachesIfNeeded(TransactionResponse response, EngineClassLoader classLoader) throws ClassNotFoundException {
        this.caches.invalidateIfNeeded(response, classLoader);
    }

    protected ResponseBuilder<?, ?> responseBuilderFor(TransactionReference reference, TransactionRequest<?> request) throws TransactionRejectedException {
        if (request instanceof JarStoreInitialTransactionRequest) {
            return new JarStoreInitialResponseBuilder(reference, (JarStoreInitialTransactionRequest)request, this.internal);
        }
        if (request instanceof GameteCreationTransactionRequest) {
            return new GameteCreationResponseBuilder(reference, (GameteCreationTransactionRequest)request, this.internal);
        }
        if (request instanceof JarStoreTransactionRequest) {
            return new JarStoreResponseBuilder(reference, (JarStoreTransactionRequest)request, this.internal);
        }
        if (request instanceof ConstructorCallTransactionRequest) {
            return new ConstructorCallResponseBuilder(reference, (ConstructorCallTransactionRequest)request, this.internal);
        }
        if (request instanceof AbstractInstanceMethodCallTransactionRequest) {
            AbstractInstanceMethodCallTransactionRequest aimctr = (AbstractInstanceMethodCallTransactionRequest)request;
            return new InstanceMethodCallResponseBuilder(reference, aimctr, this.internal);
        }
        if (request instanceof StaticMethodCallTransactionRequest) {
            return new StaticMethodCallResponseBuilder(reference, (StaticMethodCallTransactionRequest)request, this.internal);
        }
        if (request instanceof InitializationTransactionRequest) {
            return new InitializationResponseBuilder(reference, (InitializationTransactionRequest)request, this.internal);
        }
        throw new TransactionRejectedException("Unexpected transaction request of class " + request.getClass().getName());
    }

    protected abstract void postRequest(TransactionRequest<?> var1);

    protected abstract void scheduleForNotificationOfEvents(TransactionResponseWithEvents var1);

    private boolean isNotCommitted(TransactionReference transaction) {
        try {
            this.getResponse(transaction);
            return false;
        }
        catch (TransactionRejectedException | NoSuchElementException e) {
            return true;
        }
    }

    private void takeNoteForNextReward(TransactionRequest<?> request, TransactionResponse response) {
        if (!(request instanceof SystemTransactionRequest)) {
            this.numberOfTransactionsSinceLastReward = this.numberOfTransactionsSinceLastReward.add(BigInteger.ONE);
            if (response instanceof NonInitialTransactionResponse) {
                NonInitialTransactionResponse responseAsNonInitial = (NonInitialTransactionResponse)response;
                BigInteger gasConsumedButPenalty = responseAsNonInitial.getGasConsumedForCPU().add(responseAsNonInitial.getGasConsumedForStorage()).add(responseAsNonInitial.getGasConsumedForRAM());
                this.gasConsumedSinceLastReward = this.gasConsumedSinceLastReward.add(gasConsumedButPenalty);
                BigInteger gasConsumedTotal = gasConsumedButPenalty;
                if (response instanceof FailedTransactionResponse) {
                    gasConsumedTotal = gasConsumedTotal.add(((FailedTransactionResponse)response).getGasConsumedForPenalty());
                }
                BigInteger gasPrice = ((NonInitialTransactionRequest)request).getGasPrice();
                BigInteger reward = gasConsumedTotal.multiply(gasPrice);
                this.coinsSinceLastRewardWithoutInflation = this.coinsSinceLastRewardWithoutInflation.add(reward);
                gasConsumedTotal = this.addInflation(gasConsumedTotal);
                reward = gasConsumedTotal.multiply(gasPrice);
                this.coinsSinceLastReward = this.coinsSinceLastReward.add(reward);
            }
        }
    }

    private BigInteger addInflation(BigInteger gas) {
        Optional currentInflation = this.caches.getCurrentInflation();
        if (currentInflation.isPresent()) {
            gas = gas.multiply(_100_000_000.add(BigInteger.valueOf((Long)currentInflation.get()))).divide(_100_000_000);
        }
        return gas;
    }

    private void scheduleForNotificationOfEvents(TransactionResponse response) {
        TransactionResponseWithEvents responseWithEvents;
        if (response instanceof TransactionResponseWithEvents && (responseWithEvents = (TransactionResponseWithEvents)response).getEvents().count() > 0L) {
            this.scheduleForNotificationOfEvents(responseWithEvents);
        }
    }

    private void createSemaphore(TransactionReference reference) {
        if (this.semaphores.putIfAbsent(reference, new Semaphore(0)) != null) {
            throw new IllegalStateException("repeated request");
        }
    }

    private void signalSemaphore(TransactionReference reference) {
        Semaphore semaphore = (Semaphore)this.semaphores.remove(reference);
        if (semaphore != null) {
            semaphore.release();
        }
    }

    private static void deleteRecursively(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private class NodeInternalImpl
    implements NodeInternal {
        private NodeInternalImpl() {
        }

        @Override
        public LocalNodeConfig<?, ?> getConfig() {
            return AbstractLocalNodeImpl.this.config;
        }

        @Override
        public NodeCache getCaches() {
            return AbstractLocalNodeImpl.this.caches;
        }

        @Override
        public GasCostModel getGasCostModel() {
            return AbstractLocalNodeImpl.this.gasCostModel;
        }

        @Override
        public Store getStore() {
            return AbstractLocalNodeImpl.this.store;
        }

        @Override
        public StoreUtility getStoreUtilities() {
            return AbstractLocalNodeImpl.this.storeUtilities;
        }

        @Override
        public TransactionRequest<?> getRequest(TransactionReference reference) throws NoSuchElementException {
            return AbstractLocalNodeImpl.this.getRequest(reference);
        }

        @Override
        public TransactionResponse getResponse(TransactionReference reference) throws TransactionRejectedException, NoSuchElementException {
            return AbstractLocalNodeImpl.this.getResponse(reference);
        }

        @Override
        public ClassTag getClassTag(StorageReference object) throws NoSuchElementException {
            return AbstractLocalNodeImpl.this.getClassTag(object);
        }

        @Override
        public StorageValue runInstanceMethodCallTransaction(InstanceMethodCallTransactionRequest request) throws TransactionRejectedException, TransactionException, CodeExecutionException {
            return AbstractLocalNodeImpl.this.runInstanceMethodCallTransaction(request);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return AbstractLocalNodeImpl.this.executor.submit(task);
        }

        @Override
        public void submit(Runnable task) {
            AbstractLocalNodeImpl.this.executor.submit(task);
        }

        @Override
        public long getNow() {
            return AbstractLocalNodeImpl.this.getNow();
        }
    }
}

