/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionResponses;
import io.hotmoka.beans.api.requests.StaticMethodCallTransactionRequest;
import io.hotmoka.beans.api.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.values.StorageValue;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.MethodCallResponseBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.stream.Stream;

public class StaticMethodCallResponseBuilder
extends MethodCallResponseBuilder<StaticMethodCallTransactionRequest> {
    public StaticMethodCallResponseBuilder(TransactionReference reference, StaticMethodCallTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    public MethodCallTransactionResponse getResponse() throws TransactionRejectedException {
        return (MethodCallTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends MethodCallResponseBuilder.ResponseCreator {
        private Object[] deserializedActuals;

        private ResponseCreator() throws TransactionRejectedException {
            super(StaticMethodCallResponseBuilder.this);
        }

        protected MethodCallTransactionResponse body() {
            try {
                Object result;
                this.init();
                this.deserializedActuals = ((StaticMethodCallTransactionRequest)StaticMethodCallResponseBuilder.this.request).actuals().map(this.deserializer::deserialize).toArray(Object[]::new);
                Method methodJVM = StaticMethodCallResponseBuilder.this.getMethod();
                boolean isView = CodeCallResponseBuilder.hasAnnotation(methodJVM, "io.takamaka.code.lang.View");
                this.validateCallee(methodJVM, isView);
                this.ensureWhiteListingOf(methodJVM, this.deserializedActuals);
                try {
                    result = methodJVM.invoke(null, this.deserializedActuals);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.isCheckedForThrowsExceptions(cause, methodJVM)) {
                        this.viewMustBeSatisfied(isView, null);
                        this.chargeGasForStorageOf(TransactionResponses.methodCallException((String)cause.getClass().getName(), (String)cause.getMessage(), (String)StaticMethodCallResponseBuilder.this.where(cause), (boolean)false, this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                        this.refundPayerForAllRemainingGas();
                        return TransactionResponses.methodCallException((String)cause.getClass().getName(), (String)cause.getMessage(), (String)StaticMethodCallResponseBuilder.this.where(cause), (boolean)false, this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
                    }
                    throw cause;
                }
                this.viewMustBeSatisfied(isView, result);
                if (methodJVM.getReturnType() == Void.TYPE) {
                    this.chargeGasForStorageOf(TransactionResponses.voidMethodCallSuccessful((boolean)false, this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                    this.refundPayerForAllRemainingGas();
                    return TransactionResponses.voidMethodCallSuccessful((boolean)false, this.updates(), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
                }
                this.chargeGasForStorageOf(TransactionResponses.methodCallSuccessful((StorageValue)this.serializer.serialize(result), (boolean)false, this.updates(result), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return TransactionResponses.methodCallSuccessful((StorageValue)this.serializer.serialize(result), (boolean)false, this.updates(result), this.storageReferencesOfEvents(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return TransactionResponses.methodCallFailed((String)t.getClass().getName(), (String)t.getMessage(), (String)StaticMethodCallResponseBuilder.this.where(t), (boolean)false, this.updatesToBalanceOrNonceOfCaller(), (BigInteger)this.gasConsumedForCPU(), (BigInteger)this.gasConsumedForRAM(), (BigInteger)this.gasConsumedForStorage(), (BigInteger)this.gasConsumedForPenalty());
            }
        }

        @Override
        protected final Stream<Object> getDeserializedActuals() {
            return Stream.of(this.deserializedActuals);
        }

        private void validateCallee(Method methodJVM, boolean isView) throws NoSuchMethodException {
            if (!Modifier.isStatic(methodJVM.getModifiers())) {
                throw new NoSuchMethodException("cannot call an instance method");
            }
            if (!isView && StaticMethodCallResponseBuilder.this.isView()) {
                throw new NoSuchMethodException("cannot call a method not annotated as @View");
            }
        }
    }
}

