/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionResponses;
import io.hotmoka.beans.api.requests.MethodCallTransactionRequest;
import io.hotmoka.beans.api.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.api.signatures.MethodSignature;
import io.hotmoka.beans.api.signatures.NonVoidMethodSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.updates.Update;
import io.hotmoka.node.NonWhiteListedCallException;
import io.hotmoka.node.SideEffectsInViewMethodException;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class MethodCallResponseBuilder<Request extends MethodCallTransactionRequest>
extends CodeCallResponseBuilder<Request, MethodCallTransactionResponse> {
    protected MethodCallResponseBuilder(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected final int gasForStoringFailedResponse() {
        BigInteger gas = ((MethodCallTransactionRequest)this.request).getGasLimit();
        return TransactionResponses.methodCallFailed((String)"placeholder for the name of the exception", (String)"placeholder for the message of the exception", (String)"placeholder for where", (boolean)false, Stream.empty(), (BigInteger)gas, (BigInteger)gas, (BigInteger)gas, (BigInteger)gas).size();
    }

    protected final Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        Class<Void> clazz;
        MethodSignature method = ((MethodCallTransactionRequest)this.request).getStaticTarget();
        if (method instanceof NonVoidMethodSignature) {
            NonVoidMethodSignature nvms = (NonVoidMethodSignature)method;
            clazz = this.storageTypeToClass.toClass(nvms.getReturnType());
        } else {
            clazz = Void.TYPE;
        }
        Class<Void> returnType = clazz;
        Class[] argTypes = this.formalsAsClass();
        return (Method)this.classLoader.resolveMethod(method.getDefiningClass().getName(), method.getMethodName(), argTypes, returnType).orElseThrow(() -> new NoSuchMethodException(method.toString()));
    }

    protected abstract class ResponseCreator
    extends CodeCallResponseBuilder.ResponseCreator {
        protected ResponseCreator() throws TransactionRejectedException {
            super(MethodCallResponseBuilder.this);
        }

        protected final void viewMustBeSatisfied(boolean isView, Object result) throws SideEffectsInViewMethodException {
            if (isView && !this.onlyAffectedBalanceOrNonceOfCallerOrBalanceOfValidators(result)) {
                throw new SideEffectsInViewMethodException(((MethodCallTransactionRequest)MethodCallResponseBuilder.this.request).getStaticTarget());
            }
        }

        protected void ensureWhiteListingOf(Method executable, Object[] actuals) throws ClassNotFoundException {
            Optional model = MethodCallResponseBuilder.this.classLoader.getWhiteListingWizard().whiteListingModelOf(executable);
            if (model.isEmpty()) {
                throw new NonWhiteListedCallException("illegal call to non-white-listed method " + String.valueOf(((MethodCallTransactionRequest)MethodCallResponseBuilder.this.request).getStaticTarget().getDefiningClass()) + "." + ((MethodCallTransactionRequest)MethodCallResponseBuilder.this.request).getStaticTarget().getMethodName());
            }
            Annotation[][] anns = ((Method)model.get()).getParameterAnnotations();
            String methodName = ((Method)model.get()).getName();
            for (int pos = 0; pos < actuals.length; ++pos) {
                this.checkWhiteListingProofObligations(methodName, actuals[pos], anns[pos]);
            }
        }

        private boolean onlyAffectedBalanceOrNonceOfCallerOrBalanceOfValidators(Object result) {
            return this.updates(result).allMatch(x$0 -> this.isUpdateToBalanceOrNonceOfCaller((Update)x$0));
        }
    }
}

