/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.FieldSignatures;
import io.hotmoka.beans.StorageTypes;
import io.hotmoka.beans.Updates;
import io.hotmoka.beans.api.signatures.FieldSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.types.ClassType;
import io.hotmoka.beans.api.types.StorageType;
import io.hotmoka.beans.api.updates.Update;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.node.DeserializationError;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.internal.transactions.AbstractResponseBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpdatesExtractorFromRAM {
    private final AbstractResponseBuilder<?, ?> builder;

    public UpdatesExtractorFromRAM(AbstractResponseBuilder<?, ?> builder) {
        this.builder = builder;
    }

    public Stream<Update> extractUpdatesFrom(Stream<Object> objects) {
        return (UpdatesExtractorFromRAM)this.new Processor(objects).updates.stream();
    }

    private class Processor {
        private final EngineClassLoader classLoader;
        private final List<Object> workingSet;
        private final Set<StorageReference> seen = new HashSet<StorageReference>();
        private final SortedSet<Update> updates = new TreeSet<Update>();

        private Processor(Stream<Object> objects) {
            this.classLoader = UpdatesExtractorFromRAM.this.builder.classLoader;
            this.workingSet = objects.filter(object -> this.seen.add(this.classLoader.getStorageReferenceOf(object))).collect(Collectors.toList());
            do {
                new ExtractedUpdatesSingleObject(this.workingSet.remove(this.workingSet.size() - 1));
            } while (!this.workingSet.isEmpty());
        }

        private class ExtractedUpdatesSingleObject {
            private final StorageReference storageReference;
            private final boolean inStorage;

            private ExtractedUpdatesSingleObject(Object object) {
                Class<?> clazz = object.getClass();
                this.storageReference = Processor.this.classLoader.getStorageReferenceOf(object);
                this.inStorage = Processor.this.classLoader.getInStorageOf(object);
                if (!this.inStorage) {
                    Processor.this.updates.add((Update)Updates.classTag((StorageReference)this.storageReference, (ClassType)StorageTypes.classOf(clazz), (TransactionReference)Processor.this.classLoader.transactionThatInstalledJarFor(clazz)));
                }
                Class<?> previous = null;
                while (previous != Processor.this.classLoader.getStorage()) {
                    this.addUpdatesForFieldsDefinedInClass(clazz, object);
                    previous = clazz;
                    clazz = clazz.getSuperclass();
                }
            }

            private void recursiveExtract(Object s) {
                if (s != null) {
                    Class<?> clazz = s.getClass();
                    if (Processor.this.classLoader.getStorage().isAssignableFrom(clazz)) {
                        if (Processor.this.seen.add(Processor.this.classLoader.getStorageReferenceOf(s))) {
                            Processor.this.workingSet.add(s);
                        }
                    } else if (Processor.this.classLoader.isLazilyLoaded(clazz)) {
                        throw new DeserializationError("a field of a storage object cannot hold a " + clazz.getName());
                    }
                }
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, String fieldClassName, Object o) {
                FieldSignature field = FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.classNamed((String)fieldClassName));
                if (o == null) {
                    Processor.this.updates.add((Update)Updates.toNull((StorageReference)this.storageReference, (FieldSignature)field, (boolean)false));
                } else if (Processor.this.classLoader.getStorage().isAssignableFrom(o.getClass())) {
                    StorageReference storageReference2 = Processor.this.classLoader.getStorageReferenceOf(o);
                    Processor.this.updates.add((Update)Updates.ofStorage((StorageReference)this.storageReference, (FieldSignature)field, (StorageReference)storageReference2));
                    if (Processor.this.seen.add(storageReference2)) {
                        Processor.this.workingSet.add(o);
                    }
                } else if (o instanceof String) {
                    String s = (String)o;
                    Processor.this.updates.add((Update)Updates.ofString((StorageReference)this.storageReference, (FieldSignature)field, (String)s));
                } else if (o instanceof BigInteger) {
                    BigInteger bi = (BigInteger)o;
                    Processor.this.updates.add((Update)Updates.ofBigInteger((StorageReference)this.storageReference, (FieldSignature)field, (BigInteger)bi));
                } else if (o instanceof Enum) {
                    Enum e = (Enum)o;
                    Class<?> clazz = e.getClass();
                    if (this.hasInstanceFields(clazz)) {
                        throw new DeserializationError("Field " + String.valueOf(field) + " of a storage object cannot hold an enumeration of class " + clazz.getName() + ": it has instance non-transient fields");
                    }
                    Processor.this.updates.add((Update)Updates.ofEnum((StorageReference)this.storageReference, (FieldSignature)field, (String)clazz.getName(), (String)e.name(), (boolean)false));
                } else {
                    throw new DeserializationError("Field " + String.valueOf(field) + " of a storage object cannot hold a " + o.getClass().getName());
                }
            }

            private boolean hasInstanceFields(Class<?> clazz) {
                return Stream.of(clazz.getDeclaredFields()).map(Field::getModifiers).anyMatch(modifiers -> !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, boolean s) {
                Processor.this.updates.add((Update)Updates.ofBoolean((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.BOOLEAN), (boolean)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, byte s) {
                Processor.this.updates.add((Update)Updates.ofByte((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.BYTE), (byte)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, char s) {
                Processor.this.updates.add((Update)Updates.ofChar((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.CHAR), (char)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, double s) {
                Processor.this.updates.add((Update)Updates.ofDouble((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.DOUBLE), (double)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, float s) {
                Processor.this.updates.add((Update)Updates.ofFloat((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.FLOAT), (float)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, int s) {
                Processor.this.updates.add((Update)Updates.ofInt((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.INT), (int)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, long s) {
                Processor.this.updates.add((Update)Updates.ofLong((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.LONG), (long)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, short s) {
                Processor.this.updates.add((Update)Updates.ofShort((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.SHORT), (short)s));
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, String s) {
                if (s == null) {
                    Processor.this.updates.add((Update)Updates.toNull((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.STRING), (boolean)true));
                } else {
                    Processor.this.updates.add((Update)Updates.ofString((StorageReference)this.storageReference, (FieldSignature)FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.STRING), (String)s));
                }
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, BigInteger bi) {
                FieldSignature field = FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.BIG_INTEGER);
                if (bi == null) {
                    Processor.this.updates.add((Update)Updates.toNull((StorageReference)this.storageReference, (FieldSignature)field, (boolean)true));
                } else {
                    Processor.this.updates.add((Update)Updates.ofBigInteger((StorageReference)this.storageReference, (FieldSignature)field, (BigInteger)bi));
                }
            }

            private void addUpdateFor(String fieldDefiningClass, String fieldName, String fieldClassName, Enum<?> element) {
                FieldSignature field = FieldSignatures.of((String)fieldDefiningClass, (String)fieldName, (StorageType)StorageTypes.classNamed((String)fieldClassName));
                if (element == null) {
                    Processor.this.updates.add((Update)Updates.toNull((StorageReference)this.storageReference, (FieldSignature)field, (boolean)true));
                } else {
                    Processor.this.updates.add((Update)Updates.ofEnum((StorageReference)this.storageReference, (FieldSignature)field, (String)element.getClass().getName(), (String)element.name(), (boolean)true));
                }
            }

            private void addUpdatesForFieldsDefinedInClass(Class<?> clazz, Object object) {
                for (Field field : clazz.getDeclaredFields()) {
                    Object oldValue;
                    Object currentValue;
                    if (this.isStaticOrTransient(field)) continue;
                    field.setAccessible(true);
                    try {
                        currentValue = field.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new IllegalStateException("cannot access field " + field.getDeclaringClass().getName() + "." + field.getName(), e);
                    }
                    String oldName = "\u00a7old_" + field.getName();
                    try {
                        Field oldField = field.getDeclaringClass().getDeclaredField(oldName);
                        oldField.setAccessible(true);
                        oldValue = oldField.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw new IllegalStateException("cannot access old value for field " + field.getDeclaringClass().getName() + "." + field.getName(), e);
                    }
                    if (!this.inStorage || !Objects.equals(oldValue, currentValue)) {
                        this.addUpdateFor(field, currentValue);
                    }
                    if (!this.inStorage || !Processor.this.classLoader.isLazilyLoaded(field.getType())) continue;
                    this.recursiveExtract(oldValue);
                }
            }

            private void addUpdateFor(Field field, Object currentValue) {
                Class<?> fieldType = field.getType();
                String fieldDefiningClass = field.getDeclaringClass().getName();
                String fieldName = field.getName();
                if (fieldType == Character.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, ((Character)currentValue).charValue());
                } else if (fieldType == Boolean.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Boolean)currentValue);
                } else if (fieldType == Byte.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Byte)currentValue);
                } else if (fieldType == Short.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Short)currentValue);
                } else if (fieldType == Integer.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Integer)currentValue);
                } else if (fieldType == Long.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Long)currentValue);
                } else if (fieldType == Float.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, ((Float)currentValue).floatValue());
                } else if (fieldType == Double.TYPE) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (Double)currentValue);
                } else if (fieldType == BigInteger.class) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (BigInteger)currentValue);
                } else if (fieldType == String.class) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, (String)currentValue);
                } else if (fieldType.isEnum()) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, fieldType.getName(), (Enum)currentValue);
                } else if (Processor.this.classLoader.isLazilyLoaded(fieldType)) {
                    this.addUpdateFor(fieldDefiningClass, fieldName, fieldType.getName(), currentValue);
                } else {
                    throw new IllegalStateException("unexpected field in storage object: " + fieldDefiningClass + "." + fieldName);
                }
            }

            private boolean isStaticOrTransient(Field field) {
                int modifiers = field.getModifiers();
                return Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers);
            }
        }
    }
}

