/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.FieldSignatures;
import io.hotmoka.beans.api.responses.TransactionResponse;
import io.hotmoka.beans.api.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.api.signatures.FieldSignature;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.updates.ClassTag;
import io.hotmoka.beans.api.updates.Update;
import io.hotmoka.beans.api.updates.UpdateOfField;
import io.hotmoka.beans.api.values.BigIntegerValue;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.beans.api.values.StringValue;
import io.hotmoka.node.api.TransactionRejectedException;
import io.hotmoka.node.local.api.NodeCache;
import io.hotmoka.node.local.api.StoreUtility;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.stores.Store;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class StoreUtilityImpl
implements StoreUtility {
    private static final Logger logger = Logger.getLogger(StoreUtilityImpl.class.getName());
    private final NodeInternal node;
    private Store store;

    public StoreUtilityImpl(NodeInternal node) {
        this.node = node;
    }

    private Store getStore() {
        return this.store != null ? this.store : this.node.getStore();
    }

    public StoreUtilityImpl(NodeInternal node, Store store) {
        this.node = node;
        this.store = store;
    }

    public Optional<TransactionReference> getTakamakaCodeUncommitted() {
        return this.getStore().getManifestUncommitted().map(this::getClassTagUncommitted).map(ClassTag::getJar);
    }

    public Optional<StorageReference> getManifestUncommitted() {
        return this.getStore().getManifestUncommitted();
    }

    public boolean nodeIsInitializedUncommitted() {
        return this.getManifestUncommitted().isPresent();
    }

    public Optional<StorageReference> getGasStationUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignatures.MANIFEST_GAS_STATION_FIELD));
    }

    public Optional<StorageReference> getValidatorsUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignatures.MANIFEST_VALIDATORS_FIELD));
    }

    public Optional<StorageReference> getGameteUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignatures.MANIFEST_GAMETE_FIELD));
    }

    public Optional<StorageReference> getVersionsUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignatures.MANIFEST_VERSIONS_FIELD));
    }

    public BigInteger getBalanceUncommitted(StorageReference contract) {
        return this.getBigIntegerFieldUncommitted(contract, FieldSignatures.BALANCE_FIELD);
    }

    public BigInteger getRedBalanceUncommitted(StorageReference contract) {
        return this.getBigIntegerFieldUncommitted(contract, FieldSignatures.RED_BALANCE_FIELD);
    }

    public BigInteger getCurrentSupplyUncommitted(StorageReference validators) {
        return this.getBigIntegerFieldUncommitted(validators, FieldSignatures.ABSTRACT_VALIDATORS_CURRENT_SUPPLY_FIELD);
    }

    public String getPublicKeyUncommitted(StorageReference account) {
        return this.getStringFieldUncommitted(account, FieldSignatures.EOA_PUBLIC_KEY_FIELD);
    }

    public StorageReference getCreatorUncommitted(StorageReference event) {
        return this.getReferenceFieldUncommitted(event, FieldSignatures.EVENT_CREATOR_FIELD);
    }

    public BigInteger getNonceUncommitted(StorageReference account) {
        return this.getBigIntegerFieldUncommitted(account, FieldSignatures.EOA_NONCE_FIELD);
    }

    public BigInteger getTotalBalanceUncommitted(StorageReference contract) {
        return this.getBalanceUncommitted(contract).add(this.getRedBalanceUncommitted(contract));
    }

    public String getClassNameUncommitted(StorageReference reference) {
        return this.getClassTagUncommitted(reference).getClazz().getName();
    }

    public ClassTag getClassTagUncommitted(StorageReference reference) {
        Optional response = this.node.getCaches().getResponseUncommitted(reference.getTransaction());
        Object t = response.get();
        if (t instanceof TransactionResponseWithUpdates) {
            TransactionResponseWithUpdates trwu = (TransactionResponseWithUpdates)t;
            return trwu.getUpdates().filter(update -> update instanceof ClassTag && update.getObject().equals((Object)reference)).map(update -> (ClassTag)update).findFirst().get();
        }
        throw new RuntimeException("Transaction reference " + String.valueOf(reference.getTransaction()) + " does not contain updates");
    }

    public Stream<Update> getStateCommitted(StorageReference object) {
        HashSet updates = new HashSet();
        Stream history = this.getStore().getHistory(object);
        history.forEachOrdered(transaction -> this.addUpdatesCommitted(object, (TransactionReference)transaction, updates));
        return updates.stream();
    }

    public Stream<UpdateOfField> getEagerFieldsUncommitted(StorageReference object) {
        HashSet fieldsAlreadySeen = new HashSet();
        NodeCache caches = this.node.getCaches();
        return this.getStore().getHistoryUncommitted(object).flatMap(transaction -> StoreUtilityImpl.enforceHasUpdates((TransactionResponse)caches.getResponseUncommitted(transaction).get()).getUpdates()).filter(update -> update.isEager() && update instanceof UpdateOfField && update.getObject().equals((Object)object) && fieldsAlreadySeen.add(((UpdateOfField)update).getField())).map(update -> (UpdateOfField)update);
    }

    public Optional<UpdateOfField> getLastUpdateToFieldUncommitted(StorageReference object, FieldSignature field) {
        return this.getStore().getHistoryUncommitted(object).map(transaction -> this.getLastUpdateUncommitted(object, field, (TransactionReference)transaction)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<UpdateOfField> getLastUpdateToFinalFieldUncommitted(StorageReference object, FieldSignature field) {
        return this.getLastUpdateUncommitted(object, field, object.getTransaction());
    }

    private static TransactionResponseWithUpdates enforceHasUpdates(TransactionResponse response) {
        if (response instanceof TransactionResponseWithUpdates) {
            return (TransactionResponseWithUpdates)response;
        }
        throw new RuntimeException("Transaction " + String.valueOf(response) + " does not contain updates");
    }

    private void addUpdatesCommitted(StorageReference object, TransactionReference transaction, Set<Update> updates) {
        try {
            TransactionResponse response = this.node.getResponse(transaction);
            if (!(response instanceof TransactionResponseWithUpdates)) {
                throw new RuntimeException("Storage reference " + String.valueOf(transaction) + " does not contain updates");
            }
            TransactionResponseWithUpdates trwu = (TransactionResponseWithUpdates)response;
            trwu.getUpdates().filter(update -> {
                if (!update.getObject().equals((Object)object)) return false;
                if (!updates.stream().noneMatch(arg_0 -> ((Update)update).sameProperty(arg_0))) return false;
                return true;
            }).forEach(updates::add);
        }
        catch (TransactionRejectedException e) {
            logger.log(Level.WARNING, "unexpected exception", e);
            throw new RuntimeException(e);
        }
    }

    private StorageReference getReferenceFieldUncommitted(StorageReference object, FieldSignature field) {
        return (StorageReference)this.getLastUpdateToFieldUncommitted(object, field).get().getValue();
    }

    private BigInteger getBigIntegerFieldUncommitted(StorageReference object, FieldSignature field) {
        return ((BigIntegerValue)this.getLastUpdateToFieldUncommitted(object, field).get().getValue()).getValue();
    }

    private String getStringFieldUncommitted(StorageReference object, FieldSignature field) {
        return ((StringValue)this.getLastUpdateToFieldUncommitted(object, field).get().getValue()).getValue();
    }

    private Optional<UpdateOfField> getLastUpdateUncommitted(StorageReference object, FieldSignature field, TransactionReference transaction) {
        TransactionResponse response = (TransactionResponse)this.node.getCaches().getResponseUncommitted(transaction).orElseThrow(() -> new RuntimeException("Unknown transaction reference " + String.valueOf(transaction)));
        if (!(response instanceof TransactionResponseWithUpdates)) {
            throw new RuntimeException("Transaction reference " + String.valueOf(transaction) + " does not contain updates");
        }
        return ((TransactionResponseWithUpdates)response).getUpdates().filter(update -> update instanceof UpdateOfField).map(update -> (UpdateOfField)update).filter(update -> update.getObject().equals((Object)object) && update.getField().equals((Object)field)).findFirst();
    }
}

