/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class LRUCache<K, V> {
    private final int maxCapacity;
    private final Map<K, Node<K, V>> map;
    private Node<K, V> head;
    private Node<K, V> tail;

    public LRUCache(int maxCapacity) {
        this(16, maxCapacity);
    }

    public LRUCache(int initialCapacity, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.map = new HashMap<K, Node<K, V>>(Math.min(initialCapacity, maxCapacity));
    }

    private void removeNode(Node<K, V> node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
    }

    private void offerNode(Node<K, V> node) {
        if (this.head == null) {
            this.tail = node;
            this.head = this.tail;
        } else {
            this.tail.next = node;
            node.prev = this.tail;
            node.next = null;
            this.tail = node;
        }
    }

    public synchronized void put(K key, V value) {
        if (this.map.containsKey(key)) {
            Node<K, V> node = this.map.get(key);
            node.value = value;
            this.removeNode(node);
            this.offerNode(node);
        } else {
            if (this.map.size() == this.maxCapacity) {
                this.map.remove(this.head.key);
                this.removeNode(this.head);
            }
            Node<K, V> node = new Node<K, V>(key, value);
            this.offerNode(node);
            this.map.put(key, node);
        }
    }

    public synchronized V get(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        this.removeNode(node);
        this.offerNode(node);
        return node.value;
    }

    public synchronized void clear() {
        this.map.clear();
        this.tail = null;
        this.head = null;
    }

    public <E extends Exception> V computeIfAbsent(K key, ValueSupplier<K, V, E> supplier) throws E {
        V old = this.get(key);
        if (old == null) {
            V _new = supplier.supply(key);
            if (_new != null) {
                this.put(key, _new);
            }
            return _new;
        }
        return old;
    }

    public V computeIfAbsentNoException(K key, Function<K, V> supplier) {
        V old = this.get(key);
        if (old == null) {
            V _new = supplier.apply(key);
            if (_new != null) {
                this.put(key, _new);
            }
            return _new;
        }
        return old;
    }

    public Optional<V> computeIfAbsentOptional(K key, Function<K, Optional<V>> supplier) {
        V old = this.get(key);
        if (old == null) {
            Optional<V> _new = supplier.apply(key);
            _new.ifPresent(v -> this.put(key, v));
            return _new;
        }
        return Optional.of(old);
    }

    private static class Node<K, V> {
        private V value;
        private final K key;
        private Node<K, V> next;
        private Node<K, V> prev;

        public Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static interface ValueSupplier<K, V, E extends Exception> {
        public V supply(K var1) throws E;
    }
}

