/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.api.responses.TransactionResponse;
import io.hotmoka.beans.api.responses.TransactionResponseWithInstrumentedJar;
import io.hotmoka.beans.api.transactions.TransactionReference;
import io.hotmoka.beans.api.values.StorageReference;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.UnsupportedVerificationVersionException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.Reverification;
import io.hotmoka.verification.TakamakaClassLoaders;
import io.hotmoka.verification.api.TakamakaClassLoader;
import io.hotmoka.whitelisting.api.WhiteListingWizard;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class EngineClassLoaderImpl
implements EngineClassLoader {
    private final TakamakaClassLoader parent;
    private final Method fromContract;
    private final Method payableFromContractInt;
    private final Method payableFromContractLong;
    private final Method payableFromContractBigInteger;
    private final Method redPayableInt;
    private final Method redPayableLong;
    private final Method redPayableBigInteger;
    private final Field externallyOwnedAccountNonce;
    private final Field abstractValidatorsCurrentSupply;
    private final Field storageReference;
    private final Field inStorage;
    private final Field balanceField;
    private final Field redBalanceField;
    private final int[] lengthsOfJars;
    private final TransactionReference[] transactionsOfJars;
    private final ConcurrentMap<String, TransactionReference> transactionsThatInstalledJarForClasses = new ConcurrentHashMap<String, TransactionReference>();
    private final Reverification reverification;
    private static final int CLASS_END_LENGTH = ".class".length();

    public EngineClassLoaderImpl(byte[] jar, Stream<TransactionReference> dependencies, NodeInternal node, boolean reverify, ConsensusConfig<?, ?> consensus) throws ClassNotFoundException, UnsupportedVerificationVersionException, IOException {
        try {
            List dependenciesAsList = dependencies.collect(Collectors.toList());
            this.reverification = reverify && consensus != null ? new Reverification(dependenciesAsList.stream(), node, consensus) : new Reverification(Stream.empty(), node, consensus);
            ArrayList<byte[]> jars = new ArrayList<byte[]>();
            ArrayList<TransactionReference> transactionsOfJars = new ArrayList<TransactionReference>();
            this.parent = this.mkTakamakaClassLoader(dependenciesAsList.stream(), consensus, jar, node, jars, transactionsOfJars);
            this.lengthsOfJars = jars.stream().mapToInt(bytes -> ((byte[])bytes).length).toArray();
            this.transactionsOfJars = (TransactionReference[])transactionsOfJars.toArray(TransactionReference[]::new);
            Class<?> contract = this.getContract();
            Class<?> storage = this.getStorage();
            this.fromContract = storage.getDeclaredMethod("fromContract", contract);
            this.fromContract.setAccessible(true);
            this.payableFromContractInt = contract.getDeclaredMethod("payableFromContract", contract, Integer.TYPE);
            this.payableFromContractInt.setAccessible(true);
            this.payableFromContractLong = contract.getDeclaredMethod("payableFromContract", contract, Long.TYPE);
            this.payableFromContractLong.setAccessible(true);
            this.payableFromContractBigInteger = contract.getDeclaredMethod("payableFromContract", contract, BigInteger.class);
            this.payableFromContractBigInteger.setAccessible(true);
            this.redPayableInt = contract.getDeclaredMethod("redPayable", contract, Integer.TYPE);
            this.redPayableInt.setAccessible(true);
            this.redPayableLong = contract.getDeclaredMethod("redPayable", contract, Long.TYPE);
            this.redPayableLong.setAccessible(true);
            this.redPayableBigInteger = contract.getDeclaredMethod("redPayable", contract, BigInteger.class);
            this.redPayableBigInteger.setAccessible(true);
            this.redBalanceField = contract.getDeclaredField("balanceRed");
            this.redBalanceField.setAccessible(true);
            this.externallyOwnedAccountNonce = this.getExternallyOwnedAccount().getDeclaredField("nonce");
            this.externallyOwnedAccountNonce.setAccessible(true);
            this.abstractValidatorsCurrentSupply = this.getAbstractValidators().getDeclaredField("currentSupply");
            this.abstractValidatorsCurrentSupply.setAccessible(true);
            this.storageReference = storage.getDeclaredField("storageReference");
            this.storageReference.setAccessible(true);
            this.inStorage = storage.getDeclaredField("inStorage");
            this.inStorage.setAccessible(true);
            this.balanceField = contract.getDeclaredField("balance");
            this.balanceField.setAccessible(true);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("unexpected class change", e);
        }
    }

    private TakamakaClassLoader mkTakamakaClassLoader(Stream<TransactionReference> dependencies, ConsensusConfig<?, ?> consensus, byte[] start, NodeInternal node, List<byte[]> jars, ArrayList<TransactionReference> transactionsOfJars) throws ClassNotFoundException {
        AtomicInteger counter = new AtomicInteger();
        if (start != null) {
            jars.add(start);
            transactionsOfJars.add(null);
            counter.incrementAndGet();
        }
        dependencies.forEachOrdered(dependency -> this.addJars((TransactionReference)dependency, consensus, jars, (List<TransactionReference>)transactionsOfJars, node, counter));
        this.processClassInJar(jars, transactionsOfJars);
        return TakamakaClassLoaders.of(jars.stream(), (long)(consensus != null ? consensus.getVerificationVersion() : 0L));
    }

    private void processClassInJar(List<byte[]> jars, List<TransactionReference> transactionsOfJars) {
        HashMap<String, Integer> packages = new HashMap<String, Integer>();
        int pos = 0;
        for (byte[] jar : jars) {
            try (ZipInputStream jis = new ZipInputStream(new ByteArrayInputStream(jar));){
                ZipEntry entry;
                while ((entry = jis.getNextEntry()) != null) {
                    TransactionReference reference;
                    String className = entry.getName();
                    if (!className.endsWith(".class")) continue;
                    int lastDot = (className = className.substring(0, className.length() - CLASS_END_LENGTH).replace('/', '.')).lastIndexOf(46);
                    if (lastDot == 0) {
                        throw new IllegalArgumentException("package names cannot start with a dot");
                    }
                    String packageName = lastDot < 0 ? "" : className.substring(0, lastDot);
                    Integer previously = (Integer)packages.get(packageName);
                    if (previously == null) {
                        packages.put(packageName, pos);
                    } else if (previously != pos) {
                        if (packageName.isEmpty()) {
                            throw new IllegalArgumentException("the default package cannot be split across more jars");
                        }
                        throw new IllegalArgumentException("package " + packageName + " cannot be split across more jars");
                    }
                    if ((reference = transactionsOfJars.get(pos)) == null) continue;
                    this.transactionsThatInstalledJarForClasses.put(className, reference);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ++pos;
        }
    }

    private void addJars(TransactionReference classpath, ConsensusConfig<?, ?> consensus, List<byte[]> jars, List<TransactionReference> jarTransactions, NodeInternal node, AtomicInteger counter) {
        if (consensus != null && (long)counter.incrementAndGet() > consensus.getMaxDependencies()) {
            throw new IllegalArgumentException("too many dependencies in classpath: max is " + consensus.getMaxDependencies());
        }
        TransactionResponseWithInstrumentedJar responseWithInstrumentedJar = this.getResponseWithInstrumentedJarAtUncommitted(classpath, node);
        responseWithInstrumentedJar.getDependencies().forEachOrdered(dependency -> this.addJars((TransactionReference)dependency, consensus, jars, jarTransactions, node, counter));
        jars.add(responseWithInstrumentedJar.getInstrumentedJar());
        jarTransactions.add(classpath);
        if (consensus != null && jars.stream().mapToLong(bytes -> ((byte[])bytes).length).sum() > consensus.getMaxCumulativeSizeOfDependencies()) {
            throw new IllegalArgumentException("too large cumulative size of dependencies in classpath: max is " + consensus.getMaxCumulativeSizeOfDependencies() + " bytes");
        }
    }

    private TransactionResponseWithInstrumentedJar getResponseWithInstrumentedJarAtUncommitted(TransactionReference reference, NodeInternal node) {
        TransactionResponse response = this.reverification.getReverifiedResponse(reference).or(() -> node.getCaches().getResponseUncommitted(reference)).orElseThrow(() -> new IllegalArgumentException("unknown transaction reference " + String.valueOf(reference)));
        if (!(response instanceof TransactionResponseWithInstrumentedJar)) {
            throw new IllegalArgumentException("the transaction " + String.valueOf(reference) + " did not install a jar in store");
        }
        return (TransactionResponseWithInstrumentedJar)response;
    }

    public final IntStream getLengthsOfJars() {
        return IntStream.of(this.lengthsOfJars);
    }

    public final Stream<TransactionReference> getTransactionsOfJars() {
        return Stream.of(this.transactionsOfJars);
    }

    public final TransactionReference transactionThatInstalledJarFor(Class<?> clazz) {
        return (TransactionReference)this.transactionsThatInstalledJarForClasses.get(clazz.getName());
    }

    public final StorageReference getStorageReferenceOf(Object object) {
        try {
            return (StorageReference)this.storageReference.get(object);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot read the storage reference of a storage object of class " + object.getClass().getName(), e);
        }
    }

    public final boolean getInStorageOf(Object object) {
        try {
            return (Boolean)this.inStorage.get(object);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot read the inStorage tag of a storage object of class " + object.getClass().getName(), e);
        }
    }

    public final BigInteger getBalanceOf(Object object) {
        try {
            return (BigInteger)this.balanceField.get(object);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot read the balance field of a contract object of class " + object.getClass().getName(), e);
        }
    }

    public final BigInteger getRedBalanceOf(Object object) {
        try {
            return (BigInteger)this.redBalanceField.get(object);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot read the red balance field of a contract object of class " + object.getClass().getName(), e);
        }
    }

    public final void setBalanceOf(Object object, BigInteger value) {
        try {
            this.balanceField.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot write the balance field of a contract object of class " + object.getClass().getName(), e);
        }
    }

    public final void setNonceOf(Object object, BigInteger value) {
        Class<?> clazz = object.getClass();
        try {
            if (!this.getExternallyOwnedAccount().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("unknown account class " + String.valueOf(clazz));
            }
            this.externallyOwnedAccountNonce.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot write the nonce field of an account object of class " + clazz.getName(), e);
        }
    }

    public final void increaseCurrentSupply(Object validators, BigInteger amount) {
        Class<?> clazz = validators.getClass();
        try {
            if (!this.getAbstractValidators().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("unknown validators class " + String.valueOf(clazz));
            }
            this.abstractValidatorsCurrentSupply.set(validators, ((BigInteger)this.abstractValidatorsCurrentSupply.get(validators)).add(amount));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot access the current supply field of a validators object of class " + clazz.getName(), e);
        }
    }

    public final void setRedBalanceOf(Object object, BigInteger value) {
        try {
            this.redBalanceField.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot write the red balance field of a contract object of class " + object.getClass().getName(), e);
        }
    }

    public final void fromContract(Object callee, Object caller) throws Throwable {
        try {
            this.fromContract.invoke(callee, caller);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call Storage.fromContract()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void payableFromContract(Object callee, Object payer, BigInteger amount) throws Throwable {
        try {
            this.payableFromContractBigInteger.invoke(callee, payer, amount);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call Contract.payableFromContract()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void redPayableFromContract(Object callee, Object caller, BigInteger amount) throws Throwable {
        try {
            this.redPayableBigInteger.invoke(callee, caller, amount);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call RedGreenContract.redPayableFromContract()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void payableFromContract(Object callee, Object caller, int amount) throws Throwable {
        try {
            this.payableFromContractInt.invoke(callee, caller, amount);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call Contract.payableFromContract()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void redPayableFromContract(Object callee, Object caller, int amount) throws Throwable {
        try {
            this.redPayableInt.invoke(callee, caller, amount);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call RedGreenContract.redPayableEntry()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void payableFromContract(Object callee, Object caller, long amount) throws Throwable {
        try {
            this.payableFromContractLong.invoke(callee, caller, amount);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call Contract.payableFromContract()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final void redPayableFromContract(Object callee, Object caller, long amount) throws Throwable {
        try {
            this.redPayableLong.invoke(callee, caller, amount);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot call RedGreenContract.redPayable()", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void replaceReverifiedResponses() {
        this.reverification.replace();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.parent.loadClass(className);
    }

    public WhiteListingWizard getWhiteListingWizard() {
        return this.parent.getWhiteListingWizard();
    }

    public Optional<Field> resolveField(String className, String name, Class<?> type) throws ClassNotFoundException {
        return this.parent.resolveField(className, name, type);
    }

    public Optional<Field> resolveField(Class<?> clazz, String name, Class<?> type) {
        return this.parent.resolveField(clazz, name, type);
    }

    public Optional<Constructor<?>> resolveConstructor(String className, Class<?>[] args) throws ClassNotFoundException {
        return this.parent.resolveConstructor(className, (Class[])args);
    }

    public Optional<Constructor<?>> resolveConstructor(Class<?> clazz, Class<?>[] args) {
        return this.parent.resolveConstructor(clazz, (Class[])args);
    }

    public Optional<Method> resolveMethod(String className, String methodName, Class<?>[] args, Class<?> returnType) throws ClassNotFoundException {
        return this.parent.resolveMethod(className, methodName, (Class[])args, returnType);
    }

    public Optional<Method> resolveMethod(Class<?> clazz, String methodName, Class<?>[] args, Class<?> returnType) {
        return this.parent.resolveMethod(clazz, methodName, (Class[])args, returnType);
    }

    public Optional<Method> resolveInterfaceMethod(String className, String methodName, Class<?>[] args, Class<?> returnType) throws ClassNotFoundException {
        return this.parent.resolveInterfaceMethod(className, methodName, (Class[])args, returnType);
    }

    public Optional<Method> resolveInterfaceMethod(Class<?> clazz, String methodName, Class<?>[] args, Class<?> returnType) {
        return this.parent.resolveInterfaceMethod(clazz, methodName, (Class[])args, returnType);
    }

    public boolean isStorage(String className) throws ClassNotFoundException {
        return this.parent.isStorage(className);
    }

    public boolean isContract(String className) throws ClassNotFoundException {
        return this.parent.isContract(className);
    }

    public boolean isConsensusUpdateEvent(String className) throws ClassNotFoundException {
        return this.parent.isConsensusUpdateEvent(className);
    }

    public boolean isGasPriceUpdateEvent(String className) throws ClassNotFoundException {
        return this.parent.isGasPriceUpdateEvent(className);
    }

    public boolean isInflationUpdateEvent(String className) throws ClassNotFoundException {
        return this.parent.isInflationUpdateEvent(className);
    }

    public boolean isValidatorsUpdateEvent(String className) throws ClassNotFoundException {
        return this.parent.isValidatorsUpdateEvent(className);
    }

    public boolean isa(String className, String superclassName) throws ClassNotFoundException {
        return this.parent.isa(className, superclassName);
    }

    public boolean isInterface(String className) throws ClassNotFoundException {
        return this.parent.isInterface(className);
    }

    public boolean isExported(String className) throws ClassNotFoundException {
        return this.parent.isExported(className);
    }

    public boolean isLazilyLoaded(Class<?> type) {
        return this.parent.isLazilyLoaded(type);
    }

    public boolean isEagerlyLoaded(Class<?> type) {
        return this.parent.isEagerlyLoaded(type);
    }

    public Class<?> getContract() {
        return this.parent.getContract();
    }

    public Class<?> getStorage() {
        return this.parent.getStorage();
    }

    public Class<?> getExternallyOwnedAccount() {
        return this.parent.getExternallyOwnedAccount();
    }

    public Class<?> getAbstractValidators() {
        return this.parent.getAbstractValidators();
    }

    public Class<?> getGamete() {
        return this.parent.getGamete();
    }

    public Class<?> getAccount() {
        return this.parent.getAccount();
    }

    public Class<?> getAccountED25519() {
        return this.parent.getAccountED25519();
    }

    public Class<?> getAccountQTESLA1() {
        return this.parent.getAccountQTESLA1();
    }

    public Class<?> getAccountQTESLA3() {
        return this.parent.getAccountQTESLA3();
    }

    public Class<?> getAccountSHA256DSA() {
        return this.parent.getAccountSHA256DSA();
    }

    public ClassLoader getJavaClassLoader() {
        return this.parent.getJavaClassLoader();
    }

    public long getVerificationVersion() {
        return this.parent.getVerificationVersion();
    }
}

