/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.JarStoreTransactionRequest;
import io.hotmoka.beans.responses.JarStoreNonInitialTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionFailedResponse;
import io.hotmoka.beans.responses.JarStoreTransactionSuccessfulResponse;
import io.hotmoka.instrumentation.InstrumentedJars;
import io.hotmoka.instrumentation.api.GasCostModel;
import io.hotmoka.instrumentation.api.InstrumentedJar;
import io.hotmoka.node.local.AbstractNonInitialResponseBuilder;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.UnsupportedVerificationVersionException;
import io.hotmoka.node.local.internal.EngineClassLoaderImpl;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.verification.VerifiedJars;
import io.hotmoka.verification.api.TakamakaClassLoader;
import io.hotmoka.verification.api.VerifiedJar;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class JarStoreResponseBuilder
extends AbstractNonInitialResponseBuilder<JarStoreTransactionRequest, JarStoreNonInitialTransactionResponse> {
    private static final Logger LOGGER = Logger.getLogger(JarStoreResponseBuilder.class.getName());

    public JarStoreResponseBuilder(TransactionReference reference, JarStoreTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected EngineClassLoader mkClassLoader() throws ClassNotFoundException, UnsupportedVerificationVersionException, IOException {
        return new EngineClassLoaderImpl(((JarStoreTransactionRequest)this.request).getJar(), ((JarStoreTransactionRequest)this.request).getDependencies(), this.node, true, this.consensus);
    }

    @Override
    protected BigInteger minimalGasRequiredForTransaction() {
        int jarLength = ((JarStoreTransactionRequest)this.request).getJarLength();
        BigInteger result = super.minimalGasRequiredForTransaction();
        result = result.add(this.gasCostModel.cpuCostForInstallingJar(jarLength));
        result = result.add(this.gasCostModel.ramCostForInstallingJar(jarLength));
        return result;
    }

    @Override
    protected final int gasForStoringFailedResponse() {
        BigInteger gas = ((JarStoreTransactionRequest)this.request).gasLimit;
        return new JarStoreTransactionFailedResponse("placeholder for the name of the exception", "placeholder for the message of the exception", Stream.empty(), gas, gas, gas, gas).size();
    }

    public JarStoreNonInitialTransactionResponse getResponse() throws TransactionRejectedException {
        return (JarStoreNonInitialTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends AbstractNonInitialResponseBuilder.ResponseCreator {
        private ResponseCreator() throws TransactionRejectedException {
            super(JarStoreResponseBuilder.this);
        }

        protected JarStoreNonInitialTransactionResponse body() {
            try {
                this.init();
                int jarLength = ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getJarLength();
                this.chargeGasForCPU(JarStoreResponseBuilder.this.gasCostModel.cpuCostForInstallingJar(jarLength));
                this.chargeGasForRAM(JarStoreResponseBuilder.this.gasCostModel.ramCostForInstallingJar(jarLength));
                VerifiedJar verifiedJar = VerifiedJars.of((byte[])((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getJar(), (TakamakaClassLoader)JarStoreResponseBuilder.this.classLoader, (boolean)false, (boolean)JarStoreResponseBuilder.this.consensus.allowsSelfCharged(), (boolean)JarStoreResponseBuilder.this.consensus.skipsVerification());
                InstrumentedJar instrumentedJar = InstrumentedJars.of((VerifiedJar)verifiedJar, (GasCostModel)JarStoreResponseBuilder.this.gasCostModel);
                byte[] instrumentedBytes = instrumentedJar.toBytes();
                this.chargeGasForStorageOf(new JarStoreTransactionSuccessfulResponse(instrumentedBytes, ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getDependencies(), JarStoreResponseBuilder.this.consensus.getVerificationVersion(), this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return new JarStoreTransactionSuccessfulResponse(instrumentedBytes, ((JarStoreTransactionRequest)JarStoreResponseBuilder.this.request).getDependencies(), JarStoreResponseBuilder.this.consensus.getVerificationVersion(), this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "jar store failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return new JarStoreTransactionFailedResponse(t.getClass().getName(), t.getMessage(), this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage(), this.gasConsumedForPenalty());
            }
        }

        @Override
        public void event(Object event) {
        }
    }
}

