/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.CodeExecutionTransactionRequest;
import io.hotmoka.beans.responses.CodeExecutionTransactionResponse;
import io.hotmoka.beans.types.StorageType;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.node.NonWhiteListedCallException;
import io.hotmoka.node.local.AbstractNonInitialResponseBuilder;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.Serializer;
import io.hotmoka.whitelisting.Dummy;
import io.hotmoka.whitelisting.api.ResolvingClassLoader;
import io.hotmoka.whitelisting.api.WhiteListingPredicate;
import io.hotmoka.whitelisting.api.WhiteListingProofObligation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CodeCallResponseBuilder<Request extends CodeExecutionTransactionRequest<Response>, Response extends CodeExecutionTransactionResponse>
extends AbstractNonInitialResponseBuilder<Request, Response> {
    protected CodeCallResponseBuilder(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
        try {
            if (this.transactionIsSigned()) {
                this.argumentsAreExported();
            }
        }
        catch (Throwable t) {
            throw CodeCallResponseBuilder.wrapAsTransactionRejectedException(t);
        }
    }

    private void argumentsAreExported() throws TransactionRejectedException, ClassNotFoundException {
        List args = ((CodeExecutionTransactionRequest)this.request).actuals().filter(actual -> actual instanceof StorageReference).map(actual -> (StorageReference)actual).collect(Collectors.toList());
        for (StorageReference arg : args) {
            this.enforceExported(arg);
        }
    }

    protected final void enforceExported(StorageReference reference) throws TransactionRejectedException, ClassNotFoundException {
        ClassTag classTag = this.node.getClassTag(reference);
        if (!this.classLoader.isExported(classTag.clazz.name)) {
            throw new TransactionRejectedException("cannot pass as argument a value of the non-exported type " + String.valueOf(classTag.clazz));
        }
    }

    protected static boolean hasAnnotation(Executable executable, String annotationName) {
        return Stream.of(executable.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getName().equals(annotationName));
    }

    protected final String where(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace != null) {
            for (StackTraceElement cursor : stackTrace) {
                int line = cursor.getLineNumber();
                if (line < 0 || cursor.getClassName().startsWith("io.takamaka.code.")) continue;
                try {
                    Class clazz = this.classLoader.loadClass(cursor.getClassName());
                    if (clazz.getClassLoader() instanceof ResolvingClassLoader) {
                        return cursor.getFileName() + ":" + line;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected final Class<?>[] formalsAsClass() throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        for (StorageType type : ((CodeExecutionTransactionRequest)this.request).getStaticTarget().formals().collect(Collectors.toList())) {
            classes.add(this.storageTypeToClass.toClass(type));
        }
        return (Class[])classes.toArray(Class[]::new);
    }

    protected final Class<?>[] formalsAsClassForFromContract() throws ClassNotFoundException {
        ArrayList<Class<Dummy>> classes = new ArrayList<Class<Dummy>>();
        for (StorageType type : ((CodeExecutionTransactionRequest)this.request).getStaticTarget().formals().collect(Collectors.toList())) {
            classes.add(this.storageTypeToClass.toClass(type));
        }
        classes.add(this.classLoader.getContract());
        classes.add(Dummy.class);
        return (Class[])classes.toArray(Class[]::new);
    }

    protected abstract class ResponseCreator
    extends AbstractNonInitialResponseBuilder.ResponseCreator {
        protected final Serializer serializer;
        private final List<Object> events;

        protected ResponseCreator() throws TransactionRejectedException {
            super(CodeCallResponseBuilder.this);
            this.events = new ArrayList<Object>();
            try {
                this.serializer = new Serializer(CodeCallResponseBuilder.this);
            }
            catch (Throwable t) {
                throw new TransactionRejectedException(t);
            }
        }

        protected abstract Stream<Object> getDeserializedActuals();

        @Override
        public final void event(Object event) {
            if (event == null) {
                throw new NullPointerException("an event cannot be null");
            }
            this.events.add(event);
        }

        protected final void checkWhiteListingProofObligations(String methodName, Object value, Annotation[] annotations) {
            Stream.of(annotations).map(Annotation::annotationType).map(annotationType -> annotationType.getAnnotation(WhiteListingProofObligation.class)).filter(Objects::nonNull).map(WhiteListingProofObligation::check).map(this::createWhiteListingPredicateFrom).filter(predicate -> !predicate.test(value, CodeCallResponseBuilder.this.classLoader.getWhiteListingWizard())).map(predicate -> predicate.messageIfFailed(methodName)).map(NonWhiteListedCallException::new).findFirst().ifPresent(exception -> {
                throw exception;
            });
        }

        private WhiteListingPredicate createWhiteListingPredicateFrom(Class<? extends WhiteListingPredicate> clazz) {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        protected final boolean isCheckedForThrowsExceptions(Throwable cause, Executable executable) {
            return this.isChecked(cause) && CodeCallResponseBuilder.hasAnnotation(executable, "io.takamaka.code.lang.ThrowsExceptions");
        }

        private boolean isChecked(Throwable t) {
            return !(t instanceof RuntimeException) && !(t instanceof Error);
        }

        protected void scanPotentiallyAffectedObjects(Consumer<Object> consumer) {
            consumer.accept(this.getDeserializedCaller());
            this.getDeserializedValidators().ifPresent(consumer);
            Class storage = CodeCallResponseBuilder.this.classLoader.getStorage();
            this.getDeserializedActuals().filter(actual -> actual != null && storage.isAssignableFrom(actual.getClass())).forEach(consumer);
            this.events.forEach(consumer);
        }

        protected final Stream<Update> updates() {
            ArrayList potentiallyAffectedObjects = new ArrayList();
            this.scanPotentiallyAffectedObjects(potentiallyAffectedObjects::add);
            return this.updatesExtractor.extractUpdatesFrom(potentiallyAffectedObjects.stream());
        }

        protected final Stream<Update> updates(Object result) {
            ArrayList<Object> potentiallyAffectedObjects = new ArrayList<Object>();
            Class storage = CodeCallResponseBuilder.this.classLoader.getStorage();
            if (result != null && storage.isAssignableFrom(result.getClass())) {
                potentiallyAffectedObjects.add(result);
            }
            this.scanPotentiallyAffectedObjects(potentiallyAffectedObjects::add);
            return this.updatesExtractor.extractUpdatesFrom(potentiallyAffectedObjects.stream());
        }

        protected final Stream<StorageReference> storageReferencesOfEvents() {
            return this.events.stream().map(arg_0 -> ((EngineClassLoader)CodeCallResponseBuilder.this.classLoader).getStorageReferenceOf(arg_0));
        }
    }
}

