/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.SystemTransactionRequest;
import io.hotmoka.beans.requests.TransactionRequest;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.node.DeserializationError;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.ResponseBuilder;
import io.hotmoka.node.local.api.UnsupportedVerificationVersionException;
import io.hotmoka.node.local.internal.Deserializer;
import io.hotmoka.node.local.internal.EngineClassLoaderImpl;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.StorageTypeToClass;
import io.hotmoka.node.local.internal.UpdatesExtractorFromRAM;
import io.hotmoka.node.local.internal.runtime.Runtime;
import io.hotmoka.verification.VerificationException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;

public abstract class AbstractResponseBuilder<Request extends TransactionRequest<Response>, Response extends TransactionResponse>
implements ResponseBuilder<Request, Response> {
    public final NodeInternal node;
    public final StorageTypeToClass storageTypeToClass;
    public final EngineClassLoader classLoader;
    protected final Request request;
    protected final TransactionReference reference;
    protected final ConsensusConfig<?, ?> consensus;

    protected AbstractResponseBuilder(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        try {
            this.request = request;
            this.reference = reference;
            this.node = node;
            this.consensus = node.getCaches().getConsensusParams();
            this.classLoader = this.mkClassLoader();
            this.storageTypeToClass = new StorageTypeToClass(this);
        }
        catch (Throwable t) {
            throw AbstractResponseBuilder.wrapAsTransactionRejectedException(t);
        }
    }

    public final Request getRequest() {
        return this.request;
    }

    public final EngineClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final void replaceReverifiedResponses() {
        ((EngineClassLoaderImpl)this.classLoader).replaceReverifiedResponses();
    }

    protected abstract EngineClassLoader mkClassLoader() throws ClassNotFoundException, UnsupportedVerificationVersionException, IOException;

    protected static TransactionRejectedException wrapAsTransactionRejectedException(Throwable t) {
        return t instanceof TransactionRejectedException ? (TransactionRejectedException)t : new TransactionRejectedException(t);
    }

    public abstract class ResponseCreator {
        protected final Deserializer deserializer;
        protected final UpdatesExtractorFromRAM updatesExtractor;
        private final long now;
        private BigInteger nextProgressive = BigInteger.ZERO;

        protected ResponseCreator() throws TransactionRejectedException {
            try {
                this.deserializer = new Deserializer(AbstractResponseBuilder.this, AbstractResponseBuilder.this.node.getStoreUtilities());
                this.updatesExtractor = new UpdatesExtractorFromRAM(AbstractResponseBuilder.this);
                this.now = AbstractResponseBuilder.this.node.getNow();
            }
            catch (Throwable t) {
                throw new TransactionRejectedException(t);
            }
        }

        public final Response create() throws TransactionRejectedException {
            try {
                return (TransactionResponse)AbstractResponseBuilder.this.node.submit(new TakamakaCallable(this::body)).get();
            }
            catch (ExecutionException e) {
                throw AbstractResponseBuilder.wrapAsTransactionRejectedException(e.getCause());
            }
            catch (Throwable t) {
                throw AbstractResponseBuilder.wrapAsTransactionRejectedException(t);
            }
        }

        protected abstract Response body() throws ClassNotFoundException, UnsupportedVerificationVersionException, VerificationException;

        public final long now() {
            return this.now;
        }

        public final boolean isSystemCall() {
            return AbstractResponseBuilder.this.request instanceof SystemTransactionRequest;
        }

        public abstract void event(Object var1);

        public abstract <T> T withGas(BigInteger var1, Callable<T> var2) throws Exception;

        public abstract void chargeGasForCPU(BigInteger var1);

        public abstract void chargeGasForRAM(BigInteger var1);

        public final Object deserializeLastUpdateFor(StorageReference object, FieldSignature field) {
            UpdateOfField update = (UpdateOfField)AbstractResponseBuilder.this.node.getStoreUtilities().getLastUpdateToFieldUncommitted(object, field).orElseThrow(() -> new DeserializationError("did not find the last update for " + String.valueOf(field) + " of " + String.valueOf(object)));
            return this.deserializer.deserialize(update.getValue());
        }

        public final Object deserializeLastUpdateForFinal(StorageReference object, FieldSignature field) {
            UpdateOfField update = (UpdateOfField)AbstractResponseBuilder.this.node.getStoreUtilities().getLastUpdateToFinalFieldUncommitted(object, field).orElseThrow(() -> new DeserializationError("did not find the last update for " + String.valueOf(field) + " of " + String.valueOf(object)));
            return this.deserializer.deserialize(update.getValue());
        }

        public final StorageReference getNextStorageReference() {
            BigInteger result = this.nextProgressive;
            this.nextProgressive = this.nextProgressive.add(BigInteger.ONE);
            return new StorageReference(AbstractResponseBuilder.this.reference, result);
        }

        public final EngineClassLoaderImpl getClassLoader() {
            return (EngineClassLoaderImpl)AbstractResponseBuilder.this.classLoader;
        }

        protected final Stream<Update> extractUpdatesFrom(Stream<Object> objects) {
            return this.updatesExtractor.extractUpdatesFrom(objects);
        }

        private final class TakamakaCallable
        implements Callable<Response> {
            private final Callable<Response> body;

            private TakamakaCallable(Callable<Response> body) {
                this.body = body;
            }

            @Override
            public Response call() throws Exception {
                try {
                    Runtime.responseCreators.set(ResponseCreator.this);
                    TransactionResponse transactionResponse = (TransactionResponse)this.body.call();
                    return transactionResponse;
                }
                finally {
                    Runtime.responseCreators.remove();
                }
            }
        }
    }
}

