/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithUpdates;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.node.local.api.NodeCache;
import io.hotmoka.node.local.api.StoreUtility;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.stores.Store;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class StoreUtilityImpl
implements StoreUtility {
    private static final Logger logger = Logger.getLogger(StoreUtilityImpl.class.getName());
    private final NodeInternal node;
    private Store store;

    public StoreUtilityImpl(NodeInternal node) {
        this.node = node;
    }

    private Store getStore() {
        return this.store != null ? this.store : this.node.getStore();
    }

    public StoreUtilityImpl(NodeInternal node, Store store) {
        this.node = node;
        this.store = store;
    }

    public Optional<TransactionReference> getTakamakaCodeUncommitted() {
        return this.getStore().getManifestUncommitted().map(this::getClassTagUncommitted).map(_classTag -> _classTag.jar);
    }

    public Optional<StorageReference> getManifestUncommitted() {
        return this.getStore().getManifestUncommitted();
    }

    public boolean nodeIsInitializedUncommitted() {
        return this.getManifestUncommitted().isPresent();
    }

    public Optional<StorageReference> getGasStationUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_GAS_STATION_FIELD));
    }

    public Optional<StorageReference> getValidatorsUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_VALIDATORS_FIELD));
    }

    public Optional<StorageReference> getGameteUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_GAMETE_FIELD));
    }

    public Optional<StorageReference> getVersionsUncommitted() {
        return this.getManifestUncommitted().map(_manifest -> this.getReferenceFieldUncommitted((StorageReference)_manifest, FieldSignature.MANIFEST_VERSIONS_FIELD));
    }

    public BigInteger getBalanceUncommitted(StorageReference contract) {
        return this.getBigIntegerFieldUncommitted(contract, FieldSignature.BALANCE_FIELD);
    }

    public BigInteger getRedBalanceUncommitted(StorageReference contract) {
        return this.getBigIntegerFieldUncommitted(contract, FieldSignature.RED_BALANCE_FIELD);
    }

    public BigInteger getCurrentSupplyUncommitted(StorageReference validators) {
        return this.getBigIntegerFieldUncommitted(validators, FieldSignature.ABSTRACT_VALIDATORS_CURRENT_SUPPLY_FIELD);
    }

    public String getPublicKeyUncommitted(StorageReference account) {
        return this.getStringFieldUncommitted(account, FieldSignature.EOA_PUBLIC_KEY_FIELD);
    }

    public StorageReference getCreatorUncommitted(StorageReference event) {
        return this.getReferenceFieldUncommitted(event, FieldSignature.EVENT_CREATOR_FIELD);
    }

    public BigInteger getNonceUncommitted(StorageReference account) {
        return this.getBigIntegerFieldUncommitted(account, FieldSignature.EOA_NONCE_FIELD);
    }

    public BigInteger getTotalBalanceUncommitted(StorageReference contract) {
        return this.getBalanceUncommitted(contract).add(this.getRedBalanceUncommitted(contract));
    }

    public String getClassNameUncommitted(StorageReference reference) {
        return this.getClassTagUncommitted((StorageReference)reference).clazz.name;
    }

    public ClassTag getClassTagUncommitted(StorageReference reference) {
        Optional response = this.node.getCaches().getResponseUncommitted(reference.transaction);
        if (!(response.get() instanceof TransactionResponseWithUpdates)) {
            throw new RuntimeException("Transaction reference " + String.valueOf(reference.transaction) + " does not contain updates");
        }
        return ((TransactionResponseWithUpdates)response.get()).getUpdates().filter(update -> update instanceof ClassTag && update.object.equals((Object)reference)).map(update -> (ClassTag)update).findFirst().get();
    }

    public Stream<Update> getStateCommitted(StorageReference object) {
        HashSet updates = new HashSet();
        Stream history = this.getStore().getHistory(object);
        history.forEachOrdered(transaction -> this.addUpdatesCommitted(object, (TransactionReference)transaction, updates));
        return updates.stream();
    }

    public Stream<UpdateOfField> getEagerFieldsUncommitted(StorageReference object) {
        HashSet fieldsAlreadySeen = new HashSet();
        NodeCache caches = this.node.getCaches();
        return this.getStore().getHistoryUncommitted(object).flatMap(transaction -> StoreUtilityImpl.enforceHasUpdates((TransactionResponse)caches.getResponseUncommitted(transaction).get()).getUpdates()).filter(update -> update.isEager() && update instanceof UpdateOfField && update.object.equals((Object)object) && fieldsAlreadySeen.add(((UpdateOfField)update).getField())).map(update -> (UpdateOfField)update);
    }

    public Optional<UpdateOfField> getLastUpdateToFieldUncommitted(StorageReference object, FieldSignature field) {
        return this.getStore().getHistoryUncommitted(object).map(transaction -> this.getLastUpdateUncommitted(object, field, (TransactionReference)transaction)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<UpdateOfField> getLastUpdateToFinalFieldUncommitted(StorageReference object, FieldSignature field) {
        return this.getLastUpdateUncommitted(object, field, object.transaction);
    }

    private static TransactionResponseWithUpdates enforceHasUpdates(TransactionResponse response) {
        if (response instanceof TransactionResponseWithUpdates) {
            return (TransactionResponseWithUpdates)response;
        }
        throw new RuntimeException("Transaction " + String.valueOf(response) + " does not contain updates");
    }

    private void addUpdatesCommitted(StorageReference object, TransactionReference transaction, Set<Update> updates) {
        try {
            TransactionResponse response = this.node.getResponse(transaction);
            if (!(response instanceof TransactionResponseWithUpdates)) {
                throw new RuntimeException("Storage reference " + String.valueOf(transaction) + " does not contain updates");
            }
            ((TransactionResponseWithUpdates)response).getUpdates().filter(update -> {
                if (!update.object.equals((Object)object)) return false;
                if (!updates.stream().noneMatch(arg_0 -> ((Update)update).sameProperty(arg_0))) return false;
                return true;
            }).forEach(updates::add);
        }
        catch (TransactionRejectedException e) {
            logger.log(Level.WARNING, "unexpected exception", e);
            throw new RuntimeException(e);
        }
    }

    private StorageReference getReferenceFieldUncommitted(StorageReference object, FieldSignature field) {
        return (StorageReference)this.getLastUpdateToFieldUncommitted(object, field).get().getValue();
    }

    private BigInteger getBigIntegerFieldUncommitted(StorageReference object, FieldSignature field) {
        return ((BigIntegerValue)this.getLastUpdateToFieldUncommitted((StorageReference)object, (FieldSignature)field).get().getValue()).value;
    }

    private String getStringFieldUncommitted(StorageReference object, FieldSignature field) {
        return ((StringValue)this.getLastUpdateToFieldUncommitted((StorageReference)object, (FieldSignature)field).get().getValue()).value;
    }

    private Optional<UpdateOfField> getLastUpdateUncommitted(StorageReference object, FieldSignature field, TransactionReference transaction) {
        TransactionResponse response = (TransactionResponse)this.node.getCaches().getResponseUncommitted(transaction).orElseThrow(() -> new RuntimeException("Unknown transaction reference " + String.valueOf(transaction)));
        if (!(response instanceof TransactionResponseWithUpdates)) {
            throw new RuntimeException("Transaction reference " + String.valueOf(transaction) + " does not contain updates");
        }
        return ((TransactionResponseWithUpdates)response).getUpdates().filter(update -> update instanceof UpdateOfField).map(update -> (UpdateOfField)update).filter(update -> update.object.equals((Object)object) && update.getField().equals((Object)field)).findFirst();
    }
}

