/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.CodeExecutionException;
import io.hotmoka.beans.TransactionException;
import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.InstanceMethodCallTransactionRequest;
import io.hotmoka.beans.requests.SignedTransactionRequest;
import io.hotmoka.beans.requests.TransactionRequest;
import io.hotmoka.beans.responses.InitializationTransactionResponse;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithEvents;
import io.hotmoka.beans.signatures.CodeSignature;
import io.hotmoka.beans.signatures.MethodSignature;
import io.hotmoka.beans.signatures.NonVoidMethodSignature;
import io.hotmoka.beans.types.BasicTypes;
import io.hotmoka.beans.types.ClassType;
import io.hotmoka.beans.types.StorageType;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.BooleanValue;
import io.hotmoka.beans.values.IntValue;
import io.hotmoka.beans.values.LongValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.crypto.SignatureAlgorithms;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.exceptions.CheckSupplier;
import io.hotmoka.exceptions.UncheckPredicate;
import io.hotmoka.node.SimpleValidatorsConsensusConfigBuilders;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.api.SimpleValidatorsConsensusConfigBuilder;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.NodeCache;
import io.hotmoka.node.local.api.StoreUtility;
import io.hotmoka.node.local.api.UnsupportedVerificationVersionException;
import io.hotmoka.node.local.internal.EngineClassLoaderImpl;
import io.hotmoka.node.local.internal.LRUCache;
import io.hotmoka.node.local.internal.NodeInternal;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class NodeCachesImpl
implements NodeCache {
    protected static final Logger logger = Logger.getLogger(NodeCachesImpl.class.getName());
    private final NodeInternal node;
    private final LRUCache<TransactionReference, TransactionRequest<?>> requests;
    private final LRUCache<TransactionReference, TransactionResponse> responses;
    private final LRUCache<SignedTransactionRequest, Boolean> checkedSignatures;
    private final LRUCache<TransactionReference, EngineClassLoader> classLoaders = new LRUCache(100, 1000);
    private volatile ConsensusConfig<?, ?> consensus;
    private volatile Optional<StorageReference> gamete;
    private volatile Optional<StorageReference> validators;
    private volatile Optional<StorageReference> versions;
    private volatile Optional<StorageReference> gasStation;
    private volatile BigInteger gasPrice;
    private volatile Long inflation;
    private static final BigInteger _100_000 = BigInteger.valueOf(100000L);

    public NodeCachesImpl(NodeInternal node, ConsensusConfig<?, ?> consensus) {
        this.node = node;
        this.requests = new LRUCache(100, node.getConfig().getRequestCacheSize());
        this.responses = new LRUCache(100, node.getConfig().getResponseCacheSize());
        this.checkedSignatures = new LRUCache(100, 1000);
        this.validators = Optional.empty();
        this.versions = Optional.empty();
        this.gasStation = Optional.empty();
        this.gamete = Optional.empty();
        this.consensus = consensus;
    }

    public final void invalidateIfNeeded(TransactionResponse response, EngineClassLoader classLoader) throws ClassNotFoundException {
        if (this.consensusParametersMightHaveChanged(response, classLoader)) {
            long versionBefore = this.consensus.getVerificationVersion();
            logger.info("recomputing the consensus cache since the information in the manifest might have changed");
            this.recomputeConsensus();
            logger.info("the consensus cache has been recomputed");
            this.classLoaders.clear();
            if (versionBefore != this.consensus.getVerificationVersion()) {
                logger.info("the version of the verification module has changed from " + versionBefore + " to " + this.consensus.getVerificationVersion());
            }
        }
        if (this.gasPriceMightHaveChanged(response, classLoader)) {
            BigInteger gasPriceBefore = this.gasPrice;
            logger.info("recomputing the gas price cache since it has changed");
            this.recomputeGasPrice();
            logger.info("the gas price cache has been recomputed and changed from " + String.valueOf(gasPriceBefore) + " to " + String.valueOf(this.gasPrice));
        }
        if (this.inflationMightHaveChanged(response, classLoader)) {
            Long inflationBefore = this.inflation;
            logger.info("recomputing the inflation cache since it has changed");
            this.recomputeInflation();
            logger.info("the inflation cache has been recomputed and changed from " + inflationBefore + " to " + this.inflation);
        }
    }

    public final void recomputeConsensus() {
        try {
            StorageReference gasStation = this.getGasStation().get();
            StorageReference validators = this.getValidators().get();
            StorageReference versions = this.getVersions().get();
            TransactionReference takamakaCode = (TransactionReference)this.node.getStoreUtilities().getTakamakaCodeUncommitted().get();
            StorageReference manifest = (StorageReference)this.node.getStore().getManifestUncommitted().get();
            String genesisTime = ((StringValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_GENESIS_TIME, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            String chainId = ((StringValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_CHAIN_ID, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            StorageReference gamete = (StorageReference)this.node.runInstanceMethodCallTransaction(new InstanceMethodCallTransactionRequest(manifest, _100_000, takamakaCode, CodeSignature.GET_GAMETE, manifest, new StorageValue[0]));
            String publicKeyOfGamete = ((StringValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.PUBLIC_KEY, (StorageReference)gamete, (StorageValue[])new StorageValue[0]))).value;
            long maxErrorLength = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_ERROR_LENGTH, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            long maxDependencies = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_DEPENDENCIES, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            long maxCumulativeSizeOfDependencies = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_CUMULATIVE_SIZE_OF_DEPENDENCIES, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            boolean allowsSelfCharged = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.ALLOWS_SELF_CHARGED, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            boolean allowsFaucet = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.ALLOWS_UNSIGNED_FAUCET, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            boolean skipsVerification = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.SKIPS_VERIFICATION, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            String signature = ((StringValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_SIGNATURE, (StorageReference)manifest, (StorageValue[])new StorageValue[0]))).value;
            BigInteger ticketForNewPoll = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_TICKET_FOR_NEW_POLL, (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            BigInteger initialGasPrice = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_INITIAL_GAS_PRICE, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            BigInteger maxGasPerTransaction = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_MAX_GAS_PER_TRANSACTION, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            boolean ignoresGasPrice = ((BooleanValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.IGNORES_GAS_PRICE, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            BigInteger targetGasAtReward = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_TARGET_GAS_AT_REWARD, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            long oblivion = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_OBLIVION, (StorageReference)gasStation, (StorageValue[])new StorageValue[0]))).value;
            long initialInflation = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_INITIAL_INFLATION, (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            long verificationVersion = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_VERIFICATION_VERSION, (StorageReference)versions, (StorageValue[])new StorageValue[0]))).value;
            BigInteger initialSupply = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_INITIAL_SUPPLY, (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            BigInteger initialRedSupply = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_INITIAL_RED_SUPPLY, (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            BigInteger finalSupply = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)CodeSignature.GET_FINAL_SUPPLY, (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            int buyerSurcharge = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)new NonVoidMethodSignature((ClassType)ClassType.VALIDATORS, (String)"getBuyerSurcharge", (StorageType)BasicTypes.INT, (StorageType[])new StorageType[0]), (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            int slashingForMisbehaving = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)new NonVoidMethodSignature((ClassType)ClassType.VALIDATORS, (String)"getSlashingForMisbehaving", (StorageType)BasicTypes.INT, (StorageType[])new StorageType[0]), (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            int slashingForNotBehaving = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)new NonVoidMethodSignature((ClassType)ClassType.VALIDATORS, (String)"getSlashingForNotBehaving", (StorageType)BasicTypes.INT, (StorageType[])new StorageType[0]), (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            int percentStaked = ((IntValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)manifest, (BigInteger)NodeCachesImpl._100_000, (TransactionReference)takamakaCode, (MethodSignature)new NonVoidMethodSignature((ClassType)ClassType.VALIDATORS, (String)"getPercentStaked", (StorageType)BasicTypes.INT, (StorageType[])new StorageType[0]), (StorageReference)validators, (StorageValue[])new StorageValue[0]))).value;
            this.consensus = ((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)((SimpleValidatorsConsensusConfigBuilder)SimpleValidatorsConsensusConfigBuilders.defaults().setGenesisTime(LocalDateTime.parse(genesisTime, DateTimeFormatter.ISO_DATE_TIME))).setChainId(chainId)).setMaxGasPerTransaction(maxGasPerTransaction)).ignoreGasPrice(ignoresGasPrice)).signRequestsWith(SignatureAlgorithms.of((String)signature))).setInitialGasPrice(initialGasPrice)).setTargetGasAtReward(targetGasAtReward)).setOblivion(oblivion)).setInitialInflation(initialInflation)).setMaxErrorLength(maxErrorLength)).setMaxDependencies(maxDependencies)).setMaxCumulativeSizeOfDependencies(maxCumulativeSizeOfDependencies)).allowSelfCharged(allowsSelfCharged)).allowUnsignedFaucet(allowsFaucet)).skipVerification(skipsVerification)).setVerificationVersion(verificationVersion)).setTicketForNewPoll(ticketForNewPoll)).setInitialSupply(initialSupply)).setFinalSupply(finalSupply)).setInitialRedSupply(initialRedSupply)).setPublicKeyOfGamete(publicKeyOfGamete)).setPercentStaked(percentStaked)).setBuyerSurcharge(buyerSurcharge)).setSlashingForMisbehaving(slashingForMisbehaving)).setSlashingForNotBehaving(slashingForNotBehaving)).build();
        }
        catch (CodeExecutionException | TransactionException | TransactionRejectedException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "could not reconstruct the consensus parameters from the manifest", e);
            throw new RuntimeException("could not reconstruct the consensus parameters from the manifest", e);
        }
    }

    public final Optional<TransactionRequest<?>> getRequest(TransactionReference reference) {
        Objects.requireNonNull(reference);
        return this.requests.computeIfAbsentOptional(reference, _reference -> this.node.getStore().getRequest(_reference));
    }

    public final Optional<TransactionResponse> getResponse(TransactionReference reference) {
        Objects.requireNonNull(reference);
        return this.responses.computeIfAbsentOptional(reference, _reference -> this.node.getStore().getResponse(_reference));
    }

    public final Optional<TransactionResponse> getResponseUncommitted(TransactionReference reference) {
        return this.getResponse(reference).or(() -> this.node.getStore().getResponseUncommitted(reference));
    }

    public final EngineClassLoader getClassLoader(TransactionReference classpath) throws ClassNotFoundException, UnsupportedVerificationVersionException, IOException {
        EngineClassLoader classLoader = this.classLoaders.get(classpath);
        if (classLoader != null) {
            return classLoader;
        }
        EngineClassLoaderImpl classLoader2 = new EngineClassLoaderImpl(null, Stream.of(classpath), this.node, true, this.consensus);
        return this.classLoaders.computeIfAbsent(classpath, _classpath -> classLoader2);
    }

    public final boolean signatureIsValid(SignedTransactionRequest request, SignatureAlgorithm signatureAlgorithm) throws GeneralSecurityException {
        return this.checkedSignatures.computeIfAbsent(request, _request -> this.verifiesSignature(signatureAlgorithm, request));
    }

    private boolean verifiesSignature(SignatureAlgorithm signature, SignedTransactionRequest request) throws GeneralSecurityException {
        return signature.getVerifier(this.getPublicKey(request.getCaller(), signature), SignedTransactionRequest::toByteArrayWithoutSignature).verify((Object)request, request.getSignature());
    }

    public final ConsensusConfig<?, ?> getConsensusParams() {
        return this.consensus;
    }

    public final Optional<StorageReference> getGamete() {
        if (this.gamete.isEmpty()) {
            this.gamete = this.node.getStoreUtilities().getGameteUncommitted();
        }
        return this.gamete;
    }

    public final Optional<StorageReference> getValidators() {
        if (this.validators.isEmpty()) {
            this.validators = this.node.getStoreUtilities().getValidatorsUncommitted();
        }
        return this.validators;
    }

    public final Optional<StorageReference> getVersions() {
        if (this.versions.isEmpty()) {
            this.versions = this.node.getStoreUtilities().getVersionsUncommitted();
        }
        return this.versions;
    }

    public final Optional<StorageReference> getGasStation() {
        if (this.gasStation.isEmpty()) {
            this.gasStation = this.node.getStoreUtilities().getGasStationUncommitted();
        }
        return this.gasStation;
    }

    public final Optional<BigInteger> getGasPrice() {
        if (this.gasPrice == null) {
            this.recomputeGasPrice();
        }
        return Optional.ofNullable(this.gasPrice);
    }

    public final Optional<Long> getCurrentInflation() {
        if (this.inflation == null) {
            this.recomputeInflation();
        }
        return Optional.ofNullable(this.inflation);
    }

    private PublicKey getPublicKey(StorageReference reference, SignatureAlgorithm signatureAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        String publicKeyEncodedBase64 = this.node.getStoreUtilities().getPublicKeyUncommitted(reference);
        byte[] publicKeyEncoded = Base64.getDecoder().decode(publicKeyEncodedBase64);
        return signatureAlgorithm.publicKeyFromEncoding(publicKeyEncoded);
    }

    private void recomputeGasPrice() {
        Optional manifest = this.node.getStore().getManifestUncommitted();
        if (manifest.isPresent()) {
            try {
                this.gasPrice = ((BigIntegerValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)((StorageReference)manifest.get()), (BigInteger)NodeCachesImpl._100_000, (TransactionReference)((TransactionReference)this.node.getStoreUtilities().getTakamakaCodeUncommitted().get()), (MethodSignature)CodeSignature.GET_GAS_PRICE, (StorageReference)this.getGasStation().get(), (StorageValue[])new StorageValue[0]))).value;
            }
            catch (CodeExecutionException | TransactionException | TransactionRejectedException e) {
                throw new RuntimeException("could not determine the gas price", e);
            }
        }
    }

    private void recomputeInflation() {
        Optional manifest = this.node.getStore().getManifestUncommitted();
        if (manifest.isPresent()) {
            try {
                this.inflation = ((LongValue)this.node.runInstanceMethodCallTransaction((InstanceMethodCallTransactionRequest)new InstanceMethodCallTransactionRequest((StorageReference)((StorageReference)manifest.get()), (BigInteger)NodeCachesImpl._100_000, (TransactionReference)((TransactionReference)this.node.getStoreUtilities().getTakamakaCodeUncommitted().get()), (MethodSignature)CodeSignature.GET_CURRENT_INFLATION, (StorageReference)this.getValidators().get(), (StorageValue[])new StorageValue[0]))).value;
            }
            catch (CodeExecutionException | TransactionException | TransactionRejectedException e) {
                throw new RuntimeException("could not determine the current inflation", e);
            }
        }
    }

    private boolean consensusParametersMightHaveChanged(TransactionResponse response, EngineClassLoader classLoader) throws ClassNotFoundException {
        if (response instanceof InitializationTransactionResponse) {
            return true;
        }
        if (this.isInitializedUncommitted() && response instanceof TransactionResponseWithEvents) {
            Stream events = ((TransactionResponseWithEvents)response).getEvents();
            StorageReference manifest = (StorageReference)this.node.getStore().getManifestUncommitted().get();
            StorageReference gasStation = this.getGasStation().get();
            StorageReference versions = this.getVersions().get();
            StorageReference validators = this.getValidators().get();
            return (Boolean)CheckSupplier.check(ClassNotFoundException.class, () -> events.filter(UncheckPredicate.uncheck(event -> this.isConsensusUpdateEvent((StorageReference)event, classLoader))).map(arg_0 -> ((StoreUtility)this.node.getStoreUtilities()).getCreatorUncommitted(arg_0)).anyMatch(creator -> creator.equals((Object)manifest) || creator.equals((Object)validators) || creator.equals((Object)gasStation) || creator.equals((Object)versions)));
        }
        return false;
    }

    private boolean isInitializedUncommitted() {
        return this.node.getStore().getManifestUncommitted().isPresent();
    }

    private boolean isConsensusUpdateEvent(StorageReference event, EngineClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.isConsensusUpdateEvent(this.node.getStoreUtilities().getClassNameUncommitted(event));
    }

    private boolean gasPriceMightHaveChanged(TransactionResponse response, EngineClassLoader classLoader) throws ClassNotFoundException {
        if (response instanceof InitializationTransactionResponse) {
            return true;
        }
        if (this.isInitializedUncommitted() && response instanceof TransactionResponseWithEvents) {
            Stream events = ((TransactionResponseWithEvents)response).getEvents();
            StorageReference gasStation = this.getGasStation().get();
            return (Boolean)CheckSupplier.check(ClassNotFoundException.class, () -> events.filter(UncheckPredicate.uncheck(event -> this.isGasPriceUpdateEvent((StorageReference)event, classLoader))).map(arg_0 -> ((StoreUtility)this.node.getStoreUtilities()).getCreatorUncommitted(arg_0)).anyMatch(arg_0 -> ((StorageReference)gasStation).equals(arg_0)));
        }
        return false;
    }

    private boolean inflationMightHaveChanged(TransactionResponse response, EngineClassLoader classLoader) throws ClassNotFoundException {
        if (response instanceof InitializationTransactionResponse) {
            return true;
        }
        if (this.isInitializedUncommitted() && response instanceof TransactionResponseWithEvents) {
            Stream events = ((TransactionResponseWithEvents)response).getEvents();
            StorageReference validators = this.getValidators().get();
            return (Boolean)CheckSupplier.check(ClassNotFoundException.class, () -> events.filter(UncheckPredicate.uncheck(event -> this.isInflationUpdateEvent((StorageReference)event, classLoader))).map(arg_0 -> ((StoreUtility)this.node.getStoreUtilities()).getCreatorUncommitted(arg_0)).anyMatch(arg_0 -> ((StorageReference)validators).equals(arg_0)));
        }
        return false;
    }

    private boolean isGasPriceUpdateEvent(StorageReference event, EngineClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.isGasPriceUpdateEvent(this.node.getStoreUtilities().getClassNameUncommitted(event));
    }

    private boolean isInflationUpdateEvent(StorageReference event, EngineClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.isInflationUpdateEvent(this.node.getStoreUtilities().getClassNameUncommitted(event));
    }
}

