/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.StaticMethodCallTransactionRequest;
import io.hotmoka.beans.responses.MethodCallTransactionExceptionResponse;
import io.hotmoka.beans.responses.MethodCallTransactionFailedResponse;
import io.hotmoka.beans.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.responses.MethodCallTransactionSuccessfulResponse;
import io.hotmoka.beans.responses.VoidMethodCallTransactionSuccessfulResponse;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import io.hotmoka.node.local.internal.transactions.MethodCallResponseBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;

public class StaticMethodCallResponseBuilder
extends MethodCallResponseBuilder<StaticMethodCallTransactionRequest> {
    public StaticMethodCallResponseBuilder(TransactionReference reference, StaticMethodCallTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    public MethodCallTransactionResponse getResponse() throws TransactionRejectedException {
        return (MethodCallTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends MethodCallResponseBuilder.ResponseCreator {
        private Object[] deserializedActuals;

        private ResponseCreator() throws TransactionRejectedException {
            super(StaticMethodCallResponseBuilder.this);
        }

        protected MethodCallTransactionResponse body() {
            try {
                Object result;
                this.init();
                this.deserializedActuals = ((StaticMethodCallTransactionRequest)StaticMethodCallResponseBuilder.this.request).actuals().map(this.deserializer::deserialize).toArray(Object[]::new);
                Method methodJVM = StaticMethodCallResponseBuilder.this.getMethod();
                boolean isView = CodeCallResponseBuilder.hasAnnotation(methodJVM, "io.takamaka.code.lang.View");
                this.validateCallee(methodJVM, isView);
                this.ensureWhiteListingOf(methodJVM, this.deserializedActuals);
                try {
                    result = methodJVM.invoke(null, this.deserializedActuals);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.isCheckedForThrowsExceptions(cause, methodJVM)) {
                        this.viewMustBeSatisfied(isView, null);
                        this.chargeGasForStorageOf(new MethodCallTransactionExceptionResponse(cause.getClass().getName(), cause.getMessage(), StaticMethodCallResponseBuilder.this.where(cause), false, this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                        this.refundPayerForAllRemainingGas();
                        return new MethodCallTransactionExceptionResponse(cause.getClass().getName(), cause.getMessage(), StaticMethodCallResponseBuilder.this.where(cause), false, this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
                    }
                    throw cause;
                }
                this.viewMustBeSatisfied(isView, result);
                if (methodJVM.getReturnType() == Void.TYPE) {
                    this.chargeGasForStorageOf(new VoidMethodCallTransactionSuccessfulResponse(false, this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                    this.refundPayerForAllRemainingGas();
                    return new VoidMethodCallTransactionSuccessfulResponse(false, this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
                }
                this.chargeGasForStorageOf(new MethodCallTransactionSuccessfulResponse(this.serializer.serialize(result), false, this.updates(result), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return new MethodCallTransactionSuccessfulResponse(this.serializer.serialize(result), false, this.updates(result), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return new MethodCallTransactionFailedResponse(t.getClass().getName(), t.getMessage(), StaticMethodCallResponseBuilder.this.where(t), false, this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage(), this.gasConsumedForPenalty());
            }
        }

        @Override
        protected final Stream<Object> getDeserializedActuals() {
            return Stream.of(this.deserializedActuals);
        }

        private void validateCallee(Method methodJVM, boolean isView) throws NoSuchMethodException {
            if (!Modifier.isStatic(methodJVM.getModifiers())) {
                throw new NoSuchMethodException("cannot call an instance method");
            }
            if (!isView && StaticMethodCallResponseBuilder.this.isView()) {
                throw new NoSuchMethodException("cannot call a method not annotated as @View");
            }
        }
    }
}

