/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.MethodCallTransactionRequest;
import io.hotmoka.beans.responses.MethodCallTransactionFailedResponse;
import io.hotmoka.beans.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.signatures.MethodSignature;
import io.hotmoka.beans.signatures.NonVoidMethodSignature;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.node.NonWhiteListedCallException;
import io.hotmoka.node.SideEffectsInViewMethodException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class MethodCallResponseBuilder<Request extends MethodCallTransactionRequest>
extends CodeCallResponseBuilder<Request, MethodCallTransactionResponse> {
    protected MethodCallResponseBuilder(TransactionReference reference, Request request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected final int gasForStoringFailedResponse() {
        BigInteger gas = ((MethodCallTransactionRequest)this.request).gasLimit;
        return new MethodCallTransactionFailedResponse("placeholder for the name of the exception", "placeholder for the message of the exception", "placeholder for where", false, Stream.empty(), gas, gas, gas, gas).size();
    }

    protected final Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        MethodSignature method = ((MethodCallTransactionRequest)this.request).method;
        Class<Void> returnType = method instanceof NonVoidMethodSignature ? this.storageTypeToClass.toClass(((NonVoidMethodSignature)method).returnType) : Void.TYPE;
        Class[] argTypes = this.formalsAsClass();
        return (Method)this.classLoader.resolveMethod(method.definingClass.name, method.methodName, argTypes, returnType).orElseThrow(() -> new NoSuchMethodException(method.toString()));
    }

    protected abstract class ResponseCreator
    extends CodeCallResponseBuilder.ResponseCreator {
        protected ResponseCreator() throws TransactionRejectedException {
            super(MethodCallResponseBuilder.this);
        }

        protected final void viewMustBeSatisfied(boolean isView, Object result) throws SideEffectsInViewMethodException {
            if (isView && !this.onlyAffectedBalanceOrNonceOfCallerOrBalanceOfValidators(result)) {
                throw new SideEffectsInViewMethodException(((MethodCallTransactionRequest)MethodCallResponseBuilder.this.request).method);
            }
        }

        protected void ensureWhiteListingOf(Method executable, Object[] actuals) throws ClassNotFoundException {
            Optional model = MethodCallResponseBuilder.this.classLoader.getWhiteListingWizard().whiteListingModelOf(executable);
            if (model.isEmpty()) {
                throw new NonWhiteListedCallException("illegal call to non-white-listed method " + ((MethodCallTransactionRequest)MethodCallResponseBuilder.this.request).method.definingClass.name + "." + ((MethodCallTransactionRequest)MethodCallResponseBuilder.this.request).method.methodName);
            }
            Annotation[][] anns = ((Method)model.get()).getParameterAnnotations();
            String methodName = ((Method)model.get()).getName();
            for (int pos = 0; pos < actuals.length; ++pos) {
                this.checkWhiteListingProofObligations(methodName, actuals[pos], anns[pos]);
            }
        }

        private boolean onlyAffectedBalanceOrNonceOfCallerOrBalanceOfValidators(Object result) {
            return this.updates(result).allMatch(x$0 -> this.isUpdateToBalanceOrNonceOfCaller((Update)x$0));
        }
    }
}

