/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.transactions;

import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.ConstructorCallTransactionRequest;
import io.hotmoka.beans.responses.ConstructorCallTransactionExceptionResponse;
import io.hotmoka.beans.responses.ConstructorCallTransactionFailedResponse;
import io.hotmoka.beans.responses.ConstructorCallTransactionResponse;
import io.hotmoka.beans.responses.ConstructorCallTransactionSuccessfulResponse;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.node.NonWhiteListedCallException;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.node.local.internal.transactions.CodeCallResponseBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ConstructorCallResponseBuilder
extends CodeCallResponseBuilder<ConstructorCallTransactionRequest, ConstructorCallTransactionResponse> {
    private static final Logger LOGGER = Logger.getLogger(ConstructorCallResponseBuilder.class.getName());

    public ConstructorCallResponseBuilder(TransactionReference reference, ConstructorCallTransactionRequest request, NodeInternal node) throws TransactionRejectedException {
        super(reference, request, node);
    }

    @Override
    protected final int gasForStoringFailedResponse() {
        BigInteger gas = ((ConstructorCallTransactionRequest)this.request).gasLimit;
        return new ConstructorCallTransactionFailedResponse("placeholder for the name of the exception", "placeholder for the message of the exception", "placeholder for where", Stream.empty(), gas, gas, gas, gas).size();
    }

    public ConstructorCallTransactionResponse getResponse() throws TransactionRejectedException {
        return (ConstructorCallTransactionResponse)new ResponseCreator().create();
    }

    private class ResponseCreator
    extends CodeCallResponseBuilder.ResponseCreator {
        private Object[] deserializedActuals;

        private ResponseCreator() throws TransactionRejectedException {
        }

        protected ConstructorCallTransactionResponse body() {
            try {
                Object result;
                Object[] deserializedActuals;
                Constructor<?> constructorJVM;
                this.init();
                this.deserializedActuals = ((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).actuals().map(this.deserializer::deserialize).toArray(Object[]::new);
                try {
                    constructorJVM = this.getConstructor();
                    deserializedActuals = this.deserializedActuals;
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructorJVM = this.getEntryConstructor();
                        deserializedActuals = this.addExtraActualsForFromContract();
                    }
                    catch (NoSuchMethodException ee) {
                        throw e;
                    }
                }
                this.ensureWhiteListingOf(constructorJVM, deserializedActuals);
                try {
                    result = constructorJVM.newInstance(deserializedActuals);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.isCheckedForThrowsExceptions(cause, constructorJVM)) {
                        this.chargeGasForStorageOf(new ConstructorCallTransactionExceptionResponse(cause.getClass().getName(), cause.getMessage(), ConstructorCallResponseBuilder.this.where(cause), this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                        this.refundPayerForAllRemainingGas();
                        return new ConstructorCallTransactionExceptionResponse(cause.getClass().getName(), cause.getMessage(), ConstructorCallResponseBuilder.this.where(cause), this.updates(), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
                    }
                    throw cause;
                }
                this.chargeGasForStorageOf(new ConstructorCallTransactionSuccessfulResponse((StorageReference)this.serializer.serialize(result), this.updates(result), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage()));
                this.refundPayerForAllRemainingGas();
                return new ConstructorCallTransactionSuccessfulResponse((StorageReference)this.serializer.serialize(result), this.updates(result), this.storageReferencesOfEvents(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage());
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "constructor call failed", t);
                this.resetBalanceOfPayerToInitialValueMinusAllPromisedGas();
                return new ConstructorCallTransactionFailedResponse(t.getClass().getName(), t.getMessage(), ConstructorCallResponseBuilder.this.where(t), this.updatesToBalanceOrNonceOfCaller(), this.gasConsumedForCPU(), this.gasConsumedForRAM(), this.gasConsumedForStorage(), this.gasConsumedForPenalty());
            }
        }

        private Constructor<?> getConstructor() throws ClassNotFoundException, NoSuchMethodException {
            Class[] argTypes = ConstructorCallResponseBuilder.this.formalsAsClass();
            return (Constructor)ConstructorCallResponseBuilder.this.classLoader.resolveConstructor(((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).constructor.definingClass.name, argTypes).orElseThrow(() -> new NoSuchMethodException(((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).constructor.toString()));
        }

        private Constructor<?> getEntryConstructor() throws ClassNotFoundException, NoSuchMethodException {
            Class[] argTypes = ConstructorCallResponseBuilder.this.formalsAsClassForFromContract();
            return (Constructor)ConstructorCallResponseBuilder.this.classLoader.resolveConstructor(((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).constructor.definingClass.name, argTypes).orElseThrow(() -> new NoSuchMethodException(((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).constructor.toString()));
        }

        private Object[] addExtraActualsForFromContract() {
            int al = this.deserializedActuals.length;
            Object[] result = new Object[al + 2];
            System.arraycopy(this.deserializedActuals, 0, result, 0, al);
            result[al] = this.getDeserializedCaller();
            result[al + 1] = null;
            return result;
        }

        private void ensureWhiteListingOf(Constructor<?> executable, Object[] actuals) {
            Optional model = ConstructorCallResponseBuilder.this.classLoader.getWhiteListingWizard().whiteListingModelOf(executable);
            if (model.isEmpty()) {
                throw new NonWhiteListedCallException("illegal call to non-white-listed constructor of " + ((ConstructorCallTransactionRequest)ConstructorCallResponseBuilder.this.request).constructor.definingClass.name);
            }
            Annotation[][] anns = ((Constructor)model.get()).getParameterAnnotations();
            for (int pos = 0; pos < anns.length; ++pos) {
                this.checkWhiteListingProofObligations(((Constructor)model.get()).getName(), actuals[pos], anns[pos]);
            }
        }

        @Override
        protected final Stream<Object> getDeserializedActuals() {
            return Stream.of(this.deserializedActuals);
        }
    }
}

