/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal.runtime;

import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.types.ClassType;
import io.hotmoka.beans.types.StorageType;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.node.NonWhiteListedCallException;
import io.hotmoka.node.local.internal.EngineClassLoaderImpl;
import io.hotmoka.node.local.internal.transactions.AbstractResponseBuilder;
import io.hotmoka.whitelisting.Dummy;
import io.hotmoka.whitelisting.api.WhiteListingPredicate;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.concurrent.Callable;

public abstract class Runtime {
    public static final ThreadLocal<AbstractResponseBuilder.ResponseCreator> responseCreators = new ThreadLocal();

    private static AbstractResponseBuilder.ResponseCreator getResponseCreator() {
        return responseCreators.get();
    }

    public static Object deserializeLastLazyUpdateFor(Object object, String definingClass, String name, String fieldClassName) {
        AbstractResponseBuilder.ResponseCreator responseCreator = Runtime.getResponseCreator();
        return responseCreator.deserializeLastUpdateFor(responseCreator.getClassLoader().getStorageReferenceOf(object), new FieldSignature(definingClass, name, (StorageType)new ClassType(fieldClassName)));
    }

    public static Object deserializeLastLazyUpdateForFinal(Object object, String definingClass, String name, String fieldClassName) {
        AbstractResponseBuilder.ResponseCreator responseCreator = Runtime.getResponseCreator();
        return responseCreator.deserializeLastUpdateForFinal(responseCreator.getClassLoader().getStorageReferenceOf(object), new FieldSignature(definingClass, name, (StorageType)new ClassType(fieldClassName)));
    }

    public static void fromContract(Object callee, Object caller) throws Throwable {
        Runtime.getResponseCreator().getClassLoader().fromContract(callee, caller);
    }

    public static void payableFromContract(Object callee, Object caller, Dummy dummy, BigInteger amount) throws Throwable {
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        classLoader.fromContract(callee, caller);
        if (dummy == Dummy.METHOD_ON_THIS) {
            classLoader.payableFromContract(callee, callee, amount);
        } else {
            classLoader.payableFromContract(callee, caller, amount);
        }
    }

    public static void redPayableFromContract(Object callee, Object caller, Dummy dummy, BigInteger amount) throws Throwable {
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        classLoader.fromContract(callee, caller);
        if (dummy == Dummy.METHOD_ON_THIS) {
            classLoader.redPayableFromContract(callee, callee, amount);
        } else {
            classLoader.redPayableFromContract(callee, caller, amount);
        }
    }

    public static void payableFromContract(Object callee, Object caller, Dummy dummy, int amount) throws Throwable {
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        classLoader.fromContract(callee, caller);
        if (dummy == Dummy.METHOD_ON_THIS) {
            classLoader.payableFromContract(callee, callee, amount);
        } else {
            classLoader.payableFromContract(callee, caller, amount);
        }
    }

    public static void redPayableFromContract(Object callee, Object caller, Dummy dummy, int amount) throws Throwable {
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        classLoader.fromContract(callee, caller);
        if (dummy == Dummy.METHOD_ON_THIS) {
            classLoader.redPayableFromContract(callee, callee, amount);
        } else {
            classLoader.redPayableFromContract(callee, caller, amount);
        }
    }

    public static void payableFromContract(Object callee, Object caller, Dummy dummy, long amount) throws Throwable {
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        classLoader.fromContract(callee, caller);
        if (dummy == Dummy.METHOD_ON_THIS) {
            classLoader.payableFromContract(callee, callee, amount);
        } else {
            classLoader.payableFromContract(callee, caller, amount);
        }
    }

    public static void redPayableFromContract(Object callee, Object caller, Dummy dummy, long amount) throws Throwable {
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        classLoader.fromContract(callee, caller);
        if (dummy == Dummy.METHOD_ON_THIS) {
            classLoader.redPayableFromContract(callee, callee, amount);
        } else {
            classLoader.redPayableFromContract(callee, caller, amount);
        }
    }

    public static void event(Object event) {
        Runtime.getResponseCreator().event(event);
    }

    public static void mint(Object caller, Object eoa, BigInteger amount) {
        AbstractResponseBuilder.ResponseCreator creator = Runtime.getResponseCreator();
        if (!creator.canCallMintBurnFromGamete(caller)) {
            throw new IllegalArgumentException("the caller is not allowed to mint coins for an account");
        }
        if (amount.signum() < 0) {
            throw new IllegalArgumentException("the amount of coins to mint cannot be negative");
        }
        EngineClassLoaderImpl classLoader = creator.getClassLoader();
        BigInteger balance = classLoader.getBalanceOf(eoa);
        classLoader.setBalanceOf(eoa, balance.add(amount));
        creator.addToTotalSupply(amount);
    }

    public static void burn(Object caller, Object eoa, BigInteger amount) {
        AbstractResponseBuilder.ResponseCreator creator = Runtime.getResponseCreator();
        if (!creator.canCallMintBurnFromGamete(caller)) {
            throw new IllegalArgumentException("the caller is not allowed to burn coins from an account");
        }
        if (amount.signum() < 0) {
            throw new IllegalArgumentException("the amount of coins to burn cannot be negative");
        }
        EngineClassLoaderImpl classLoader = creator.getClassLoader();
        BigInteger balance = classLoader.getBalanceOf(eoa);
        BigInteger finalBalance = balance.subtract(amount);
        if (finalBalance.signum() < 0) {
            throw new IllegalArgumentException("the final balance of the account, after burning, cannot be negative");
        }
        classLoader.setBalanceOf(eoa, finalBalance);
        creator.addToTotalSupply(amount.negate());
    }

    public static <T> T withGas(BigInteger amount, Callable<T> what) throws Exception {
        return Runtime.getResponseCreator().withGas(amount, what);
    }

    public static long now() {
        return Runtime.getResponseCreator().now();
    }

    public static boolean isSystemCall() {
        return Runtime.getResponseCreator().isSystemCall();
    }

    public static boolean inStorageOf(Object object) {
        return Runtime.getResponseCreator().getClassLoader().getInStorageOf(object);
    }

    public static int compareStorageReferencesOf(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        EngineClassLoaderImpl classLoader = Runtime.getResponseCreator().getClassLoader();
        return classLoader.getStorageReferenceOf(o1).compareTo((StorageValue)classLoader.getStorageReferenceOf(o2));
    }

    public static Object getNextStorageReference() {
        return Runtime.getResponseCreator().getNextStorageReference();
    }

    public static void checkWhiteListingPredicate(Object value, Class<? extends WhiteListingPredicate> predicateClass, String methodName) {
        try {
            WhiteListingPredicate predicate = predicateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!predicate.test(value, Runtime.getResponseCreator().getClassLoader().getWhiteListingWizard())) {
                throw new NonWhiteListedCallException(predicate.messageIfFailed(methodName));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void chargeForRAM(BigInteger ram) {
        Runtime.getResponseCreator().chargeGasForRAM(ram);
    }

    public static void chargeForRAM(long ram) {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(ram));
    }

    public static void chargeForRAM(int ram) {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(ram));
    }

    public static void chargeForRAM1() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.ONE);
    }

    public static void chargeForRAM2() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.TWO);
    }

    public static void chargeForRAM3() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(3L));
    }

    public static void chargeForRAM4() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(4L));
    }

    public static void chargeForRAM5() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(5L));
    }

    public static void chargeForRAM6() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(6L));
    }

    public static void chargeForRAM7() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(7L));
    }

    public static void chargeForRAM8() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(8L));
    }

    public static void chargeForRAM9() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(9L));
    }

    public static void chargeForRAM10() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(10L));
    }

    public static void chargeForRAM11() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(11L));
    }

    public static void chargeForRAM12() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(12L));
    }

    public static void chargeForRAM13() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(13L));
    }

    public static void chargeForRAM14() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(14L));
    }

    public static void chargeForRAM15() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(15L));
    }

    public static void chargeForRAM16() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(16L));
    }

    public static void chargeForRAM17() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(17L));
    }

    public static void chargeForRAM18() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(18L));
    }

    public static void chargeForRAM19() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(19L));
    }

    public static void chargeForRAM20() {
        Runtime.getResponseCreator().chargeGasForRAM(BigInteger.valueOf(20L));
    }

    public static void charge(long cpu) {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(cpu));
    }

    public static void charge(int cpu) {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(cpu));
    }

    public static void charge1() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.ONE);
    }

    public static void charge2() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(2L));
    }

    public static void charge3() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(3L));
    }

    public static void charge4() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(4L));
    }

    public static void charge5() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(5L));
    }

    public static void charge6() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(6L));
    }

    public static void charge7() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(7L));
    }

    public static void charge8() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(8L));
    }

    public static void charge9() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(9L));
    }

    public static void charge10() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(10L));
    }

    public static void charge11() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(11L));
    }

    public static void charge12() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(12L));
    }

    public static void charge13() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(13L));
    }

    public static void charge14() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(14L));
    }

    public static void charge15() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(15L));
    }

    public static void charge16() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(16L));
    }

    public static void charge17() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(17L));
    }

    public static void charge18() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(18L));
    }

    public static void charge19() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(19L));
    }

    public static void charge20() {
        Runtime.getResponseCreator().chargeGasForCPU(BigInteger.valueOf(20L));
    }
}

