/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.AbstractJarStoreTransactionRequest;
import io.hotmoka.beans.requests.InitialTransactionRequest;
import io.hotmoka.beans.responses.JarStoreInitialTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionFailedResponse;
import io.hotmoka.beans.responses.JarStoreTransactionResponse;
import io.hotmoka.beans.responses.JarStoreTransactionSuccessfulResponse;
import io.hotmoka.beans.responses.TransactionResponse;
import io.hotmoka.beans.responses.TransactionResponseWithInstrumentedJar;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.local.internal.NodeInternal;
import io.hotmoka.verification.TakamakaClassLoaders;
import io.hotmoka.verification.UnsupportedVerificationVersionException;
import io.hotmoka.verification.VerificationException;
import io.hotmoka.verification.VerifiedJars;
import io.hotmoka.verification.api.Error;
import io.hotmoka.verification.api.TakamakaClassLoader;
import io.hotmoka.verification.api.VerifiedJar;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class Reverification {
    protected static final Logger logger = Logger.getLogger(Reverification.class.getName());
    private final ConcurrentMap<TransactionReference, TransactionResponse> reverified = new ConcurrentHashMap<TransactionReference, TransactionResponse>();
    private final NodeInternal node;
    private final ConsensusConfig<?, ?> consensus;

    public Reverification(Stream<TransactionReference> transactions, NodeInternal node, ConsensusConfig<?, ?> consensus) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        this.node = node;
        this.consensus = consensus;
        AtomicInteger counter = new AtomicInteger();
        for (TransactionReference dependency : (TransactionReference[])transactions.toArray(TransactionReference[]::new)) {
            this.reverify(dependency, counter);
        }
    }

    public Optional<TransactionResponse> getReverifiedResponse(TransactionReference transaction) {
        return Optional.ofNullable((TransactionResponse)this.reverified.get(transaction));
    }

    public void replace() {
        this.reverified.forEach((reference, response) -> {
            this.node.getStore().replace(reference, this.node.getRequest((TransactionReference)reference), response);
            logger.info(String.valueOf(reference) + ": updated after reverification");
        });
        this.reverified.clear();
    }

    private List<JarStoreTransactionResponse> reverify(TransactionReference transaction, AtomicInteger counter) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        if (this.consensus != null && (long)counter.incrementAndGet() > this.consensus.getMaxDependencies()) {
            throw new IllegalArgumentException("too many dependencies in classpath: max is " + this.consensus.getMaxDependencies());
        }
        TransactionResponseWithInstrumentedJar response = this.getResponseWithInstrumentedJarAtUncommitted(transaction);
        List<JarStoreTransactionResponse> reverifiedDependencies = this.reverifiedDependenciesOf(response, counter);
        if (this.anyFailed(reverifiedDependencies)) {
            return List.of(this.transformIntoFailed(response, transaction, "the reverification of a dependency failed"));
        }
        if (!this.needsReverification(response)) {
            return this.union(reverifiedDependencies, (JarStoreTransactionResponse)response);
        }
        VerifiedJar vj = this.recomputeVerifiedJarFor(transaction, reverifiedDependencies);
        if (vj.hasErrors()) {
            return List.of(this.transformIntoFailed(response, transaction, ((Error)vj.getFirstError().get()).getMessage()));
        }
        return this.union(reverifiedDependencies, this.updateVersion(response, transaction));
    }

    private VerifiedJar recomputeVerifiedJarFor(TransactionReference transaction, List<JarStoreTransactionResponse> reverifiedDependencies) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        AbstractJarStoreTransactionRequest jarStoreRequestOfTransaction = (AbstractJarStoreTransactionRequest)this.node.getRequest(transaction);
        byte[] jar = jarStoreRequestOfTransaction.getJar();
        ArrayList<byte[]> jars = new ArrayList<byte[]>();
        jars.add(jar);
        reverifiedDependencies.stream().map(dependency -> (TransactionResponseWithInstrumentedJar)dependency).map(TransactionResponseWithInstrumentedJar::getInstrumentedJar).forEachOrdered(jars::add);
        if (this.consensus != null && jars.stream().mapToLong(bytes -> ((byte[])bytes).length).sum() > this.consensus.getMaxCumulativeSizeOfDependencies()) {
            throw new IllegalArgumentException("too large cumulative size of dependencies in classpath: max is " + this.consensus.getMaxCumulativeSizeOfDependencies() + " bytes");
        }
        TakamakaClassLoader tcl = TakamakaClassLoaders.of(jars.stream(), (long)(this.consensus != null ? this.consensus.getVerificationVersion() : 0L));
        try {
            return VerifiedJars.of((byte[])jar, (TakamakaClassLoader)tcl, (boolean)(jarStoreRequestOfTransaction instanceof InitialTransactionRequest), (this.consensus != null && this.consensus.allowsSelfCharged() ? 1 : 0) != 0, (this.consensus != null && this.consensus.skipsVerification() ? 1 : 0) != 0);
        }
        catch (UnsupportedVerificationVersionException e) {
            throw new io.hotmoka.node.local.api.UnsupportedVerificationVersionException(e.verificationVerification);
        }
    }

    private boolean needsReverification(TransactionResponseWithInstrumentedJar response) {
        return response.getVerificationVersion() != this.consensus.getVerificationVersion();
    }

    private List<JarStoreTransactionResponse> reverifiedDependenciesOf(TransactionResponseWithInstrumentedJar response, AtomicInteger counter) throws ClassNotFoundException, io.hotmoka.node.local.api.UnsupportedVerificationVersionException, IOException {
        ArrayList<JarStoreTransactionResponse> reverifiedDependencies = new ArrayList<JarStoreTransactionResponse>();
        for (TransactionReference dependency : (TransactionReference[])response.getDependencies().toArray(TransactionReference[]::new)) {
            reverifiedDependencies.addAll(this.reverify(dependency, counter));
        }
        return reverifiedDependencies;
    }

    private boolean anyFailed(List<JarStoreTransactionResponse> responses) {
        return responses.stream().anyMatch(response -> response instanceof JarStoreTransactionFailedResponse);
    }

    private List<JarStoreTransactionResponse> union(List<JarStoreTransactionResponse> responses, JarStoreTransactionResponse added) {
        responses.add(added);
        return responses;
    }

    private JarStoreTransactionFailedResponse transformIntoFailed(TransactionResponseWithInstrumentedJar response, TransactionReference transaction, String error) {
        if (response instanceof JarStoreInitialTransactionResponse) {
            throw new RuntimeException("the reverification of the initial jar store transaction " + String.valueOf(transaction) + " failed: its jar cannot be used");
        }
        JarStoreTransactionSuccessfulResponse currentResponseAsNonInitial = (JarStoreTransactionSuccessfulResponse)response;
        JarStoreTransactionFailedResponse replacement = new JarStoreTransactionFailedResponse(VerificationException.class.getName(), error, currentResponseAsNonInitial.getUpdates(), currentResponseAsNonInitial.gasConsumedForCPU, currentResponseAsNonInitial.gasConsumedForRAM, currentResponseAsNonInitial.gasConsumedForStorage, BigInteger.ZERO);
        this.reverified.put(transaction, (TransactionResponse)replacement);
        return replacement;
    }

    private JarStoreTransactionResponse updateVersion(TransactionResponseWithInstrumentedJar response, TransactionReference transaction) {
        JarStoreInitialTransactionResponse replacement;
        if (response instanceof JarStoreInitialTransactionResponse) {
            replacement = new JarStoreInitialTransactionResponse(response.getInstrumentedJar(), response.getDependencies(), this.consensus.getVerificationVersion());
        } else {
            JarStoreTransactionSuccessfulResponse currentResponseAsNonInitial = (JarStoreTransactionSuccessfulResponse)response;
            replacement = new JarStoreTransactionSuccessfulResponse(response.getInstrumentedJar(), response.getDependencies(), this.consensus.getVerificationVersion(), currentResponseAsNonInitial.getUpdates(), currentResponseAsNonInitial.gasConsumedForCPU, currentResponseAsNonInitial.gasConsumedForRAM, currentResponseAsNonInitial.gasConsumedForStorage);
        }
        this.reverified.put(transaction, (TransactionResponse)replacement);
        return replacement;
    }

    private TransactionResponseWithInstrumentedJar getResponseWithInstrumentedJarAtUncommitted(TransactionReference reference) throws NoSuchElementException {
        TransactionResponse response = (TransactionResponse)this.node.getCaches().getResponseUncommitted(reference).orElseThrow(() -> new RuntimeException("unknown transaction reference " + String.valueOf(reference)));
        if (!(response instanceof TransactionResponseWithInstrumentedJar)) {
            throw new NoSuchElementException("the transaction " + String.valueOf(reference) + " did not install a jar in store");
        }
        return (TransactionResponseWithInstrumentedJar)response;
    }
}

