/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.local.internal;

import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.BooleanValue;
import io.hotmoka.beans.values.ByteValue;
import io.hotmoka.beans.values.CharValue;
import io.hotmoka.beans.values.DoubleValue;
import io.hotmoka.beans.values.EnumValue;
import io.hotmoka.beans.values.FloatValue;
import io.hotmoka.beans.values.IntValue;
import io.hotmoka.beans.values.LongValue;
import io.hotmoka.beans.values.NullValue;
import io.hotmoka.beans.values.ShortValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.node.DeserializationError;
import io.hotmoka.node.local.api.EngineClassLoader;
import io.hotmoka.node.local.api.StoreUtility;
import io.hotmoka.node.local.internal.StorageTypeToClass;
import io.hotmoka.node.local.internal.transactions.AbstractResponseBuilder;
import io.hotmoka.whitelisting.Dummy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class Deserializer {
    private final StoreUtility storeUtilities;
    private final StorageTypeToClass storageTypeToClass;
    private final EngineClassLoader classLoader;
    private final Map<StorageReference, Object> cache = new HashMap<StorageReference, Object>();
    private final Comparator<Update> updateComparator = new Comparator<Update>(){

        @Override
        public int compare(Update update1, Update update2) {
            if (update1 instanceof UpdateOfField && update2 instanceof UpdateOfField) {
                FieldSignature field1 = ((UpdateOfField)update1).getField();
                FieldSignature field2 = ((UpdateOfField)update2).getField();
                try {
                    Class clazz2;
                    String className1 = field1.definingClass.name;
                    String className2 = field2.definingClass.name;
                    if (className1.equals(className2)) {
                        int diff = field1.name.compareTo(field2.name);
                        if (diff != 0) {
                            return diff;
                        }
                        return field1.type.toString().compareTo(field2.type.toString());
                    }
                    Class clazz1 = Deserializer.this.classLoader.loadClass(className1);
                    if (clazz1.isAssignableFrom(clazz2 = Deserializer.this.classLoader.loadClass(className2))) {
                        return -1;
                    }
                    if (clazz2.isAssignableFrom(clazz1)) {
                        return 1;
                    }
                    throw new IllegalStateException("Updates are not on the same supeclass chain");
                }
                catch (ClassNotFoundException e) {
                    throw new DeserializationError((Throwable)e);
                }
            }
            return update1.compareTo(update2);
        }
    };

    public Deserializer(AbstractResponseBuilder<?, ?> builder, StoreUtility storeUtilities) {
        this.storeUtilities = storeUtilities;
        this.storageTypeToClass = builder.storageTypeToClass;
        this.classLoader = builder.classLoader;
    }

    public Object deserialize(StorageValue value) {
        if (value instanceof StorageReference) {
            return this.cache.computeIfAbsent((StorageReference)value, this::createStorageObject);
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).value;
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).value;
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).value;
        }
        if (value instanceof NullValue) {
            return null;
        }
        if (value instanceof ByteValue) {
            return ((ByteValue)value).value;
        }
        if (value instanceof ShortValue) {
            return ((ShortValue)value).value;
        }
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).value);
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).value);
        }
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).value;
        }
        if (value instanceof StringValue) {
            return new String(((StringValue)value).value);
        }
        if (value instanceof BigIntegerValue) {
            return new BigInteger(value.toString());
        }
        if (value instanceof EnumValue) {
            EnumValue ev = (EnumValue)value;
            try {
                Class enumClass = this.classLoader.loadClass(ev.enumClassName);
                Optional<Field> fieldOfElement = Stream.of(enumClass.getDeclaredFields()).filter(field -> Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers())).filter(field -> field.getName().equals(ev.name)).filter(field -> field.getType() == enumClass).findFirst();
                Field field2 = fieldOfElement.orElseThrow(() -> new DeserializationError("cannot find enum constant " + ev.name));
                field2.setAccessible(true);
                return field2.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException e) {
                throw new DeserializationError((Throwable)e);
            }
        }
        throw new DeserializationError("unexpected storage value");
    }

    private Object createStorageObject(StorageReference reference) {
        try {
            ArrayList<Class> formals = new ArrayList<Class>();
            ArrayList<StorageReference> actuals = new ArrayList<StorageReference>();
            formals.add(Object.class);
            actuals.add(reference);
            ClassTag classTag = this.storeUtilities.getClassTagUncommitted(reference);
            this.storeUtilities.getEagerFieldsUncommitted(reference).sorted(this.updateComparator).forEachOrdered(update -> {
                try {
                    formals.add(this.storageTypeToClass.toClass(update.getField().type));
                    actuals.add((StorageReference)this.deserialize(update.getValue()));
                }
                catch (ClassNotFoundException e) {
                    throw new DeserializationError((Throwable)e);
                }
            });
            Class clazz = this.classLoader.loadClass(classTag.clazz.name);
            TransactionReference actual = this.classLoader.transactionThatInstalledJarFor(clazz);
            TransactionReference expected = classTag.jar;
            if (!actual.equals(expected)) {
                throw new DeserializationError("Class " + String.valueOf(classTag.clazz) + " was instantiated from jar at " + String.valueOf(expected) + " not from jar at " + String.valueOf(actual));
            }
            formals.add(Dummy.class);
            actuals.add(null);
            Constructor constructor = clazz.getConstructor((Class[])formals.toArray(Class[]::new));
            constructor.setAccessible(true);
            return constructor.newInstance(actuals.toArray(Object[]::new));
        }
        catch (DeserializationError e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationError((Throwable)e);
        }
    }
}

