/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.values;

import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.BooleanValue;
import io.hotmoka.beans.values.ByteValue;
import io.hotmoka.beans.values.CharValue;
import io.hotmoka.beans.values.DoubleValue;
import io.hotmoka.beans.values.EnumValue;
import io.hotmoka.beans.values.FloatValue;
import io.hotmoka.beans.values.IntValue;
import io.hotmoka.beans.values.LongValue;
import io.hotmoka.beans.values.NullValue;
import io.hotmoka.beans.values.ShortValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.network.requests.MethodCallTransactionRequestModel;
import io.hotmoka.network.values.StorageReferenceModel;
import java.math.BigInteger;

public class StorageValueModel {
    private static final String BIGINTEGER_NAME = BigInteger.class.getName();
    private static final String STRING_NAME = String.class.getName();
    public String value;
    public StorageReferenceModel reference;
    public String type;
    public String enumElementName;

    public StorageValueModel(StorageValue parent) {
        if (parent == null) {
            throw new RuntimeException("unexpected null storage value");
        }
        if (parent instanceof StorageReference) {
            this.value = null;
            this.reference = new StorageReferenceModel((StorageReference)parent);
            this.type = "reference";
            this.enumElementName = null;
        } else if (parent == NullValue.INSTANCE) {
            this.value = null;
            this.reference = null;
            this.type = "reference";
            this.enumElementName = null;
        } else if (parent instanceof EnumValue) {
            EnumValue parentAsEnumValue = (EnumValue)parent;
            this.value = null;
            this.reference = null;
            this.type = parentAsEnumValue.enumClassName;
            this.enumElementName = parentAsEnumValue.name;
        } else if (parent instanceof BigIntegerValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = BIGINTEGER_NAME;
            this.enumElementName = null;
        } else if (parent instanceof StringValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = STRING_NAME;
            this.enumElementName = null;
        } else if (parent instanceof IntValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "int";
            this.enumElementName = null;
        } else if (parent instanceof LongValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "long";
            this.enumElementName = null;
        } else if (parent instanceof ShortValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "short";
            this.enumElementName = null;
        } else if (parent instanceof CharValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "char";
            this.enumElementName = null;
        } else if (parent instanceof FloatValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "float";
            this.enumElementName = null;
        } else if (parent instanceof DoubleValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "double";
            this.enumElementName = null;
        } else if (parent instanceof ByteValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "byte";
            this.enumElementName = null;
        } else if (parent instanceof BooleanValue) {
            this.value = parent.toString();
            this.reference = null;
            this.type = "boolean";
            this.enumElementName = null;
        } else {
            throw new RuntimeException("unexpected storage value of class " + parent.getClass().getName());
        }
    }

    public StorageValueModel() {
    }

    public StorageValue toBean() {
        if (this.enumElementName != null) {
            return new EnumValue(this.type, this.enumElementName);
        }
        if (this.type.equals("reference")) {
            if (this.reference == null) {
                return NullValue.INSTANCE;
            }
            return this.reference.toBean();
        }
        if (this.value == null) {
            throw new RuntimeException("unexpected null value");
        }
        if (this.type.equals(BIGINTEGER_NAME)) {
            return new BigIntegerValue(new BigInteger(this.value));
        }
        if (this.type.equals(STRING_NAME)) {
            return new StringValue(this.value);
        }
        if (this.type.equals("boolean")) {
            return new BooleanValue(Boolean.parseBoolean(this.value));
        }
        if (this.type.equals("byte")) {
            return new ByteValue(Byte.parseByte(this.value));
        }
        if (this.type.equals("char")) {
            return new CharValue(this.value.charAt(0));
        }
        if (this.type.equals("short")) {
            return new ShortValue(Short.parseShort(this.value));
        }
        if (this.type.equals("int")) {
            return new IntValue(Integer.parseInt(this.value));
        }
        if (this.type.equals("long")) {
            return new LongValue(Long.parseLong(this.value));
        }
        if (this.type.equals("float")) {
            return new FloatValue(Float.parseFloat(this.value));
        }
        if (this.type.equals("double")) {
            return new DoubleValue(Double.parseDouble(this.value));
        }
        throw new RuntimeException("unexpected value type " + this.type);
    }

    public static StorageValueModel modelOfValueReturned(MethodCallTransactionRequestModel request, StorageValue returnedValue) {
        if (request.method.returnType == null && returnedValue == null) {
            return null;
        }
        if (request.method.returnType == null) {
            throw new RuntimeException("unexpected non-null return value for void method");
        }
        if (returnedValue == null) {
            throw new RuntimeException("unexpected null return value for non-void method");
        }
        return new StorageValueModel(returnedValue);
    }
}

