/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.updates;

import io.hotmoka.beans.signatures.FieldSignature;
import io.hotmoka.beans.updates.ClassTag;
import io.hotmoka.beans.updates.Update;
import io.hotmoka.beans.updates.UpdateOfBigInteger;
import io.hotmoka.beans.updates.UpdateOfBoolean;
import io.hotmoka.beans.updates.UpdateOfByte;
import io.hotmoka.beans.updates.UpdateOfChar;
import io.hotmoka.beans.updates.UpdateOfDouble;
import io.hotmoka.beans.updates.UpdateOfEnumEager;
import io.hotmoka.beans.updates.UpdateOfEnumLazy;
import io.hotmoka.beans.updates.UpdateOfField;
import io.hotmoka.beans.updates.UpdateOfFloat;
import io.hotmoka.beans.updates.UpdateOfInt;
import io.hotmoka.beans.updates.UpdateOfLong;
import io.hotmoka.beans.updates.UpdateOfShort;
import io.hotmoka.beans.updates.UpdateOfStorage;
import io.hotmoka.beans.updates.UpdateOfString;
import io.hotmoka.beans.updates.UpdateToNullEager;
import io.hotmoka.beans.updates.UpdateToNullLazy;
import io.hotmoka.beans.values.BigIntegerValue;
import io.hotmoka.beans.values.BooleanValue;
import io.hotmoka.beans.values.ByteValue;
import io.hotmoka.beans.values.CharValue;
import io.hotmoka.beans.values.DoubleValue;
import io.hotmoka.beans.values.EnumValue;
import io.hotmoka.beans.values.FloatValue;
import io.hotmoka.beans.values.IntValue;
import io.hotmoka.beans.values.LongValue;
import io.hotmoka.beans.values.NullValue;
import io.hotmoka.beans.values.ShortValue;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.beans.values.StringValue;
import io.hotmoka.network.signatures.FieldSignatureModel;
import io.hotmoka.network.values.StorageReferenceModel;
import io.hotmoka.network.values.StorageValueModel;
import io.hotmoka.network.values.TransactionReferenceModel;

public class UpdateModel {
    public FieldSignatureModel field;
    public StorageValueModel value;
    public String className;
    public TransactionReferenceModel jar;
    public StorageReferenceModel object;

    public UpdateModel(Update update) {
        this.object = new StorageReferenceModel(update.object);
        if (update instanceof ClassTag) {
            ClassTag classTag = (ClassTag)update;
            this.field = null;
            this.value = null;
            this.className = classTag.clazz.name;
            this.jar = new TransactionReferenceModel(classTag.jar);
        } else {
            UpdateOfField updateOfField = (UpdateOfField)update;
            this.field = new FieldSignatureModel(updateOfField.getField());
            this.value = new StorageValueModel(updateOfField.getValue());
            this.className = null;
            this.jar = null;
        }
    }

    public UpdateModel() {
    }

    public Update toBean() {
        if (this.object == null) {
            throw new RuntimeException("unexpected null update object");
        }
        if (this.className != null) {
            return new ClassTag(this.object.toBean(), this.className, this.jar.toBean());
        }
        FieldSignature field = this.field.toBean();
        StorageValue value = this.value.toBean();
        StorageReference object = this.object.toBean();
        if (value == NullValue.INSTANCE) {
            if (field.type.isEager()) {
                return new UpdateToNullEager(object, field);
            }
            return new UpdateToNullLazy(object, field);
        }
        if (value instanceof EnumValue) {
            if (field.type.isEager()) {
                return new UpdateOfEnumEager(object, field, ((EnumValue)value).enumClassName, ((EnumValue)value).name);
            }
            return new UpdateOfEnumLazy(object, field, ((EnumValue)value).enumClassName, ((EnumValue)value).name);
        }
        if (value instanceof BigIntegerValue) {
            return new UpdateOfBigInteger(object, field, ((BigIntegerValue)value).value);
        }
        if (value instanceof StringValue) {
            return new UpdateOfString(object, field, ((StringValue)value).value);
        }
        if (value instanceof StorageReference) {
            return new UpdateOfStorage(object, field, (StorageReference)value);
        }
        if (value instanceof BooleanValue) {
            return new UpdateOfBoolean(object, field, ((BooleanValue)value).value);
        }
        if (value instanceof ByteValue) {
            return new UpdateOfByte(object, field, ((ByteValue)value).value);
        }
        if (value instanceof CharValue) {
            return new UpdateOfChar(object, field, ((CharValue)value).value);
        }
        if (value instanceof DoubleValue) {
            return new UpdateOfDouble(object, field, ((DoubleValue)value).value);
        }
        if (value instanceof FloatValue) {
            return new UpdateOfFloat(object, field, ((FloatValue)value).value);
        }
        if (value instanceof IntValue) {
            return new UpdateOfInt(object, field, ((IntValue)value).value);
        }
        if (value instanceof LongValue) {
            return new UpdateOfLong(object, field, ((LongValue)value).value);
        }
        if (value instanceof ShortValue) {
            return new UpdateOfShort(object, field, ((ShortValue)value).value);
        }
        throw new RuntimeException("unexpected update value of class " + value.getClass().getName());
    }
}

