/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.signatures;

import io.hotmoka.beans.types.BasicTypes;
import io.hotmoka.beans.types.ClassType;
import io.hotmoka.beans.types.StorageType;

public abstract class SignatureModel {
    public String definingClass;

    protected SignatureModel(String definingClass) {
        this.definingClass = definingClass;
    }

    protected SignatureModel() {
    }

    protected static String nameOf(StorageType type) {
        if (type == null) {
            throw new RuntimeException("unexpected null type");
        }
        if (type instanceof BasicTypes) {
            return type.toString();
        }
        if (type instanceof ClassType) {
            return ((ClassType)type).name;
        }
        throw new RuntimeException("unexpected storage type of class " + type.getClass().getName());
    }

    protected static StorageType typeWithName(String name) {
        if (name == null) {
            throw new RuntimeException("unexpected null type name");
        }
        switch (name) {
            case "boolean": {
                return BasicTypes.BOOLEAN;
            }
            case "byte": {
                return BasicTypes.BYTE;
            }
            case "char": {
                return BasicTypes.CHAR;
            }
            case "short": {
                return BasicTypes.SHORT;
            }
            case "int": {
                return BasicTypes.INT;
            }
            case "long": {
                return BasicTypes.LONG;
            }
            case "float": {
                return BasicTypes.FLOAT;
            }
            case "double": {
                return BasicTypes.DOUBLE;
            }
        }
        return new ClassType(name);
    }
}

