/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.requests;

import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.requests.JarStoreInitialTransactionRequest;
import io.hotmoka.network.requests.InitialTransactionRequestModel;
import io.hotmoka.network.values.TransactionReferenceModel;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class JarStoreInitialTransactionRequestModel
extends InitialTransactionRequestModel {
    public String jar;
    public List<TransactionReferenceModel> dependencies;

    public JarStoreInitialTransactionRequestModel() {
    }

    public JarStoreInitialTransactionRequestModel(JarStoreInitialTransactionRequest request) {
        this.jar = Base64.getEncoder().encodeToString(request.getJar());
        this.dependencies = request.getDependencies().map(TransactionReferenceModel::new).collect(Collectors.toList());
    }

    public JarStoreInitialTransactionRequest toBean() {
        if (this.jar == null) {
            throw new RuntimeException("unexpected null jar");
        }
        return new JarStoreInitialTransactionRequest(this.decodeBase64(this.jar), (TransactionReference[])this.dependencies.stream().map(TransactionReferenceModel::toBean).toArray(TransactionReference[]::new));
    }
}

