/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.requests;

import io.hotmoka.beans.requests.ConstructorCallTransactionRequest;
import io.hotmoka.beans.requests.NonInitialTransactionRequest;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.network.requests.NonInitialTransactionRequestModel;
import io.hotmoka.network.signatures.ConstructorSignatureModel;
import io.hotmoka.network.values.StorageValueModel;
import java.math.BigInteger;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class ConstructorCallTransactionRequestModel
extends NonInitialTransactionRequestModel {
    public ConstructorSignatureModel constructorSignature;
    public List<StorageValueModel> actuals;
    public String chainId;
    public String signature;

    public ConstructorCallTransactionRequestModel() {
    }

    public ConstructorCallTransactionRequestModel(ConstructorCallTransactionRequest request) {
        super((NonInitialTransactionRequest<?>)request);
        this.signature = Base64.getEncoder().encodeToString(request.getSignature());
        this.chainId = request.chainId;
        this.constructorSignature = new ConstructorSignatureModel(request.constructor);
        this.actuals = request.actuals().map(StorageValueModel::new).collect(Collectors.toList());
    }

    public ConstructorCallTransactionRequest toBean() {
        return new ConstructorCallTransactionRequest(this.decodeBase64(this.signature), this.caller.toBean(), new BigInteger(this.nonce), this.chainId, new BigInteger(this.gasLimit), new BigInteger(this.gasPrice), this.classpath.toBean(), this.constructorSignature.toBean(), (StorageValue[])this.actuals.stream().map(StorageValueModel::toBean).toArray(StorageValue[]::new));
    }
}

