/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.network.errors;

import io.hotmoka.beans.CodeExecutionException;
import io.hotmoka.beans.TransactionException;
import io.hotmoka.beans.TransactionRejectedException;
import java.security.NoSuchAlgorithmException;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;

public class ErrorModel {
    public String message;
    public String exceptionClassName;

    public ErrorModel(String message, Class<? extends Exception> exceptionClass) {
        this.message = message;
        this.exceptionClassName = ErrorModel.abstractName(exceptionClass);
    }

    public ErrorModel() {
    }

    private static String abstractName(Class<? extends Exception> exceptionClass) {
        if (TransactionException.class.isAssignableFrom(exceptionClass)) {
            return TransactionException.class.getName();
        }
        if (TransactionRejectedException.class.isAssignableFrom(exceptionClass)) {
            return TransactionRejectedException.class.getName();
        }
        if (CodeExecutionException.class.isAssignableFrom(exceptionClass)) {
            return CodeExecutionException.class.getName();
        }
        if (NoSuchElementException.class.isAssignableFrom(exceptionClass)) {
            return NoSuchElementException.class.getName();
        }
        if (NoSuchAlgorithmException.class.isAssignableFrom(exceptionClass)) {
            return NoSuchAlgorithmException.class.getName();
        }
        if (InterruptedException.class.isAssignableFrom(exceptionClass)) {
            return InterruptedException.class.getName();
        }
        if (TimeoutException.class.isAssignableFrom(exceptionClass)) {
            return TimeoutException.class.getName();
        }
        return exceptionClass.getName();
    }

    public ErrorModel(Exception e) {
        this(e.getMessage() != null ? e.getMessage() : "", e.getClass());
    }
}

