/*
Copyright 2021 Dinu Berinde and Fausto Spoto

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package io.hotmoka.network.responses;

import io.hotmoka.beans.responses.MethodCallTransactionExceptionResponse;
import io.hotmoka.network.updates.UpdateModel;
import io.hotmoka.network.values.StorageReferenceModel;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class MethodCallTransactionExceptionResponseModel extends MethodCallTransactionResponseModel {

    /**
     * The events generated by this transaction.
     */
    private List<StorageReferenceModel> events;

    /**
     * The fully-qualified class name of the cause exception.
     */
    public String classNameOfCause;

    /**
     * The message of the cause exception.
     */
    public String messageOfCause;

    /**
     * The program point where the cause exception occurred.
     */
    public String where;

    public MethodCallTransactionExceptionResponseModel(MethodCallTransactionExceptionResponse response) {
        super(response);

        this.events = response.getEvents().map(StorageReferenceModel::new).collect(Collectors.toList());
        this.classNameOfCause = response.classNameOfCause;
        this.messageOfCause = response.messageOfCause;
        this.where = response.where;
    }

    public MethodCallTransactionExceptionResponseModel() {}

    public MethodCallTransactionExceptionResponse toBean() {
        return new MethodCallTransactionExceptionResponse(
        	classNameOfCause,
        	messageOfCause,
        	where,
        	selfCharged,
            updates.stream().map(UpdateModel::toBean),
            events.stream().map(StorageReferenceModel::toBean),
            new BigInteger(gasConsumedForCPU),
            new BigInteger(gasConsumedForRAM),
            new BigInteger(gasConsumedForStorage)
        );
    }
}
